/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBotAliasRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<PutBotAliasRequest.Builder, PutBotAliasRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutBotAliasRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PutBotAliasRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(PutBotAliasRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(PutBotAliasRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(PutBotAliasRequest::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<ConversationLogsRequest> CONVERSATION_LOGS_FIELD = SdkField
            .<ConversationLogsRequest> builder(MarshallingType.SDK_POJO).memberName("conversationLogs")
            .getter(getter(PutBotAliasRequest::conversationLogs)).setter(setter(Builder::conversationLogs))
            .constructor(ConversationLogsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogs").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(PutBotAliasRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            BOT_VERSION_FIELD, BOT_NAME_FIELD, CHECKSUM_FIELD, CONVERSATION_LOGS_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String botVersion;

    private final String botName;

    private final String checksum;

    private final ConversationLogsRequest conversationLogs;

    private final List<Tag> tags;

    private PutBotAliasRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botName = builder.botName;
        this.checksum = builder.checksum;
        this.conversationLogs = builder.conversationLogs;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the alias. The name is <i>not</i> case sensitive.
     * </p>
     * 
     * @return The name of the alias. The name is <i>not</i> case sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the alias.
     * </p>
     * 
     * @return A description of the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot.
     * </p>
     * 
     * @return The version of the bot.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The name of the bot.
     * </p>
     * 
     * @return The name of the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * Identifies a specific revision of the <code>$LATEST</code> version.
     * </p>
     * <p>
     * When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum you get a
     * <code>BadRequestException</code> exception.
     * </p>
     * <p>
     * When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most recent
     * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the
     * checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code>
     * exception.
     * </p>
     * 
     * @return Identifies a specific revision of the <code>$LATEST</code> version.</p>
     *         <p>
     *         When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum
     *         you get a <code>BadRequestException</code> exception.
     *         </p>
     *         <p>
     *         When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most
     *         recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
     *         field, or if the checksum does not match the <code>$LATEST</code> version, you get a
     *         <code>PreconditionFailedException</code> exception.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * Settings for conversation logs for the alias.
     * </p>
     * 
     * @return Settings for conversation logs for the alias.
     */
    public final ConversationLogsRequest conversationLogs() {
        return conversationLogs;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
     * <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
     * <code>TagResource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
     *         <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
     *         <code>TagResource</code> operation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(conversationLogs());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotAliasRequest)) {
            return false;
        }
        PutBotAliasRequest other = (PutBotAliasRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(botName(), other.botName())
                && Objects.equals(checksum(), other.checksum()) && Objects.equals(conversationLogs(), other.conversationLogs())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutBotAliasRequest").add("Name", name()).add("Description", description())
                .add("BotVersion", botVersion()).add("BotName", botName()).add("Checksum", checksum())
                .add("ConversationLogs", conversationLogs()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "conversationLogs":
            return Optional.ofNullable(clazz.cast(conversationLogs()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBotAliasRequest, T> g) {
        return obj -> g.apply((PutBotAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutBotAliasRequest> {
        /**
         * <p>
         * The name of the alias. The name is <i>not</i> case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the alias. The name is <i>not</i> case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the alias.
         * </p>
         * 
         * @param description
         *        A description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The name of the bot.
         * </p>
         * 
         * @param botName
         *        The name of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * Identifies a specific revision of the <code>$LATEST</code> version.
         * </p>
         * <p>
         * When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum you
         * get a <code>BadRequestException</code> exception.
         * </p>
         * <p>
         * When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most recent
         * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if
         * the checksum does not match the <code>$LATEST</code> version, you get a
         * <code>PreconditionFailedException</code> exception.
         * </p>
         * 
         * @param checksum
         *        Identifies a specific revision of the <code>$LATEST</code> version.</p>
         *        <p>
         *        When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a
         *        checksum you get a <code>BadRequestException</code> exception.
         *        </p>
         *        <p>
         *        When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most
         *        recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
         *        field, or if the checksum does not match the <code>$LATEST</code> version, you get a
         *        <code>PreconditionFailedException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * Settings for conversation logs for the alias.
         * </p>
         * 
         * @param conversationLogs
         *        Settings for conversation logs for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLogs(ConversationLogsRequest conversationLogs);

        /**
         * <p>
         * Settings for conversation logs for the alias.
         * </p>
         * This is a convenience that creates an instance of the {@link ConversationLogsRequest.Builder} avoiding the
         * need to create one manually via {@link ConversationLogsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConversationLogsRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #conversationLogs(ConversationLogsRequest)}.
         * 
         * @param conversationLogs
         *        a consumer that will call methods on {@link ConversationLogsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLogs(ConversationLogsRequest)
         */
        default Builder conversationLogs(Consumer<ConversationLogsRequest.Builder> conversationLogs) {
            return conversationLogs(ConversationLogsRequest.builder().applyMutation(conversationLogs).build());
        }

        /**
         * <p>
         * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
         * <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
         * <code>TagResource</code> operation.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use
         *        the <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
         *        <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
         * <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
         * <code>TagResource</code> operation.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use
         *        the <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
         *        <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
         * <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
         * <code>TagResource</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botVersion;

        private String botName;

        private String checksum;

        private ConversationLogsRequest conversationLogs;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotAliasRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            botVersion(model.botVersion);
            botName(model.botName);
            checksum(model.checksum);
            conversationLogs(model.conversationLogs);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final ConversationLogsRequest.Builder getConversationLogs() {
            return conversationLogs != null ? conversationLogs.toBuilder() : null;
        }

        @Override
        public final Builder conversationLogs(ConversationLogsRequest conversationLogs) {
            this.conversationLogs = conversationLogs;
            return this;
        }

        public final void setConversationLogs(ConversationLogsRequest.BuilderImpl conversationLogs) {
            this.conversationLogs = conversationLogs != null ? conversationLogs.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBotAliasRequest build() {
            return new PutBotAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
