/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a regular expression used to validate the value of a slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotTypeRegexConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotTypeRegexConfiguration.Builder, SlotTypeRegexConfiguration> {
    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pattern")
            .getter(getter(SlotTypeRegexConfiguration::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATTERN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pattern;

    private SlotTypeRegexConfiguration(BuilderImpl builder) {
        this.pattern = builder.pattern;
    }

    /**
     * <p>
     * A regular expression used to validate the value of a slot.
     * </p>
     * <p>
     * Use a standard regular expression. Amazon Lex supports the following characters in the regular expression:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A-Z, a-z
     * </p>
     * </li>
     * <li>
     * <p>
     * 0-9
     * </p>
     * </li>
     * <li>
     * <p>
     * Unicode characters ("\ u&lt;Unicode&gt;")
     * </p>
     * </li>
     * </ul>
     * <p>
     * Represent Unicode characters with four digits, for example "\u0041" or "\u005A".
     * </p>
     * <p>
     * The following regular expression operators are not supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Infinite repeaters: *, +, or {x,} with no upper bound.
     * </p>
     * </li>
     * <li>
     * <p>
     * Wild card (.)
     * </p>
     * </li>
     * </ul>
     * 
     * @return A regular expression used to validate the value of a slot. </p>
     *         <p>
     *         Use a standard regular expression. Amazon Lex supports the following characters in the regular
     *         expression:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A-Z, a-z
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         0-9
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Unicode characters ("\ u&lt;Unicode&gt;")
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Represent Unicode characters with four digits, for example "\u0041" or "\u005A".
     *         </p>
     *         <p>
     *         The following regular expression operators are not supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Infinite repeaters: *, +, or {x,} with no upper bound.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Wild card (.)
     *         </p>
     *         </li>
     */
    public final String pattern() {
        return pattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeRegexConfiguration)) {
            return false;
        }
        SlotTypeRegexConfiguration other = (SlotTypeRegexConfiguration) obj;
        return Objects.equals(pattern(), other.pattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotTypeRegexConfiguration").add("Pattern", pattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeRegexConfiguration, T> g) {
        return obj -> g.apply((SlotTypeRegexConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotTypeRegexConfiguration> {
        /**
         * <p>
         * A regular expression used to validate the value of a slot.
         * </p>
         * <p>
         * Use a standard regular expression. Amazon Lex supports the following characters in the regular expression:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z
         * </p>
         * </li>
         * <li>
         * <p>
         * 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * Unicode characters ("\ u&lt;Unicode&gt;")
         * </p>
         * </li>
         * </ul>
         * <p>
         * Represent Unicode characters with four digits, for example "\u0041" or "\u005A".
         * </p>
         * <p>
         * The following regular expression operators are not supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Infinite repeaters: *, +, or {x,} with no upper bound.
         * </p>
         * </li>
         * <li>
         * <p>
         * Wild card (.)
         * </p>
         * </li>
         * </ul>
         * 
         * @param pattern
         *        A regular expression used to validate the value of a slot. </p>
         *        <p>
         *        Use a standard regular expression. Amazon Lex supports the following characters in the regular
         *        expression:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unicode characters ("\ u&lt;Unicode&gt;")
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Represent Unicode characters with four digits, for example "\u0041" or "\u005A".
         *        </p>
         *        <p>
         *        The following regular expression operators are not supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Infinite repeaters: *, +, or {x,} with no upper bound.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Wild card (.)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);
    }

    static final class BuilderImpl implements Builder {
        private String pattern;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeRegexConfiguration model) {
            pattern(model.pattern);
        }

        public final String getPattern() {
            return pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public SlotTypeRegexConfiguration build() {
            return new SlotTypeRegexConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
