/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about conversation log settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLogsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationLogsResponse.Builder, ConversationLogsResponse> {
    private static final SdkField<List<LogSettingsResponse>> LOG_SETTINGS_FIELD = SdkField
            .<List<LogSettingsResponse>> builder(MarshallingType.LIST)
            .memberName("logSettings")
            .getter(getter(ConversationLogsResponse::logSettings))
            .setter(setter(Builder::logSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogSettingsResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogSettingsResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(ConversationLogsResponse::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_SETTINGS_FIELD,
            IAM_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LogSettingsResponse> logSettings;

    private final String iamRoleArn;

    private ConversationLogsResponse(BuilderImpl builder) {
        this.logSettings = builder.logSettings;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * Returns true if the LogSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLogSettings() {
        return logSettings != null && !(logSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings for your conversation logs. You can log text, audio, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The settings for your conversation logs. You can log text, audio, or both.
     */
    public final List<LogSettingsResponse> logSettings() {
        return logSettings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3
     *         bucket.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogSettings() ? logSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLogsResponse)) {
            return false;
        }
        ConversationLogsResponse other = (ConversationLogsResponse) obj;
        return hasLogSettings() == other.hasLogSettings() && Objects.equals(logSettings(), other.logSettings())
                && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLogsResponse").add("LogSettings", hasLogSettings() ? logSettings() : null)
                .add("IamRoleArn", iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logSettings":
            return Optional.ofNullable(clazz.cast(logSettings()));
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLogsResponse, T> g) {
        return obj -> g.apply((ConversationLogsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLogsResponse> {
        /**
         * <p>
         * The settings for your conversation logs. You can log text, audio, or both.
         * </p>
         * 
         * @param logSettings
         *        The settings for your conversation logs. You can log text, audio, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(Collection<LogSettingsResponse> logSettings);

        /**
         * <p>
         * The settings for your conversation logs. You can log text, audio, or both.
         * </p>
         * 
         * @param logSettings
         *        The settings for your conversation logs. You can log text, audio, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(LogSettingsResponse... logSettings);

        /**
         * <p>
         * The settings for your conversation logs. You can log text, audio, or both.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LogSettingsResponse>.Builder} avoiding the
         * need to create one manually via {@link List<LogSettingsResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogSettingsResponse>.Builder#build()} is called immediately
         * and its result is passed to {@link #logSettings(List<LogSettingsResponse>)}.
         * 
         * @param logSettings
         *        a consumer that will call methods on {@link List<LogSettingsResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logSettings(List<LogSettingsResponse>)
         */
        Builder logSettings(Consumer<LogSettingsResponse.Builder>... logSettings);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<LogSettingsResponse> logSettings = DefaultSdkAutoConstructList.getInstance();

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLogsResponse model) {
            logSettings(model.logSettings);
            iamRoleArn(model.iamRoleArn);
        }

        public final List<LogSettingsResponse.Builder> getLogSettings() {
            List<LogSettingsResponse.Builder> result = LogSettingsResponseListCopier.copyToBuilder(this.logSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder logSettings(Collection<LogSettingsResponse> logSettings) {
            this.logSettings = LogSettingsResponseListCopier.copy(logSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSettings(LogSettingsResponse... logSettings) {
            logSettings(Arrays.asList(logSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSettings(Consumer<LogSettingsResponse.Builder>... logSettings) {
            logSettings(Stream.of(logSettings).map(c -> LogSettingsResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLogSettings(Collection<LogSettingsResponse.BuilderImpl> logSettings) {
            this.logSettings = LogSettingsResponseListCopier.copyFromBuilder(logSettings);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public ConversationLogsResponse build() {
            return new ConversationLogsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
