/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutIntentRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<PutIntentRequest.Builder, PutIntentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutIntentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PutIntentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Slot>> SLOTS_FIELD = SdkField
            .<List<Slot>> builder(MarshallingType.LIST)
            .memberName("slots")
            .getter(getter(PutIntentRequest::slots))
            .setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Slot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Slot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(PutIntentRequest::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Prompt> CONFIRMATION_PROMPT_FIELD = SdkField.<Prompt> builder(MarshallingType.SDK_POJO)
            .memberName("confirmationPrompt").getter(getter(PutIntentRequest::confirmationPrompt))
            .setter(setter(Builder::confirmationPrompt)).constructor(Prompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationPrompt").build())
            .build();

    private static final SdkField<Statement> REJECTION_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .memberName("rejectionStatement").getter(getter(PutIntentRequest::rejectionStatement))
            .setter(setter(Builder::rejectionStatement)).constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionStatement").build())
            .build();

    private static final SdkField<FollowUpPrompt> FOLLOW_UP_PROMPT_FIELD = SdkField
            .<FollowUpPrompt> builder(MarshallingType.SDK_POJO).memberName("followUpPrompt")
            .getter(getter(PutIntentRequest::followUpPrompt)).setter(setter(Builder::followUpPrompt))
            .constructor(FollowUpPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followUpPrompt").build()).build();

    private static final SdkField<Statement> CONCLUSION_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .memberName("conclusionStatement").getter(getter(PutIntentRequest::conclusionStatement))
            .setter(setter(Builder::conclusionStatement)).constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conclusionStatement").build())
            .build();

    private static final SdkField<CodeHook> DIALOG_CODE_HOOK_FIELD = SdkField.<CodeHook> builder(MarshallingType.SDK_POJO)
            .memberName("dialogCodeHook").getter(getter(PutIntentRequest::dialogCodeHook))
            .setter(setter(Builder::dialogCodeHook)).constructor(CodeHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()).build();

    private static final SdkField<FulfillmentActivity> FULFILLMENT_ACTIVITY_FIELD = SdkField
            .<FulfillmentActivity> builder(MarshallingType.SDK_POJO).memberName("fulfillmentActivity")
            .getter(getter(PutIntentRequest::fulfillmentActivity)).setter(setter(Builder::fulfillmentActivity))
            .constructor(FulfillmentActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentActivity").build())
            .build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIntentSignature").getter(getter(PutIntentRequest::parentIntentSignature))
            .setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(PutIntentRequest::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createVersion").getter(getter(PutIntentRequest::createVersion)).setter(setter(Builder::createVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()).build();

    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<KendraConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraConfiguration")
            .getter(getter(PutIntentRequest::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(KendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField
            .<List<InputContext>> builder(MarshallingType.LIST)
            .memberName("inputContexts")
            .getter(getter(PutIntentRequest::inputContexts))
            .setter(setter(Builder::inputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField
            .<List<OutputContext>> builder(MarshallingType.LIST)
            .memberName("outputContexts")
            .getter(getter(PutIntentRequest::outputContexts))
            .setter(setter(Builder::outputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SLOTS_FIELD, SAMPLE_UTTERANCES_FIELD, CONFIRMATION_PROMPT_FIELD, REJECTION_STATEMENT_FIELD, FOLLOW_UP_PROMPT_FIELD,
            CONCLUSION_STATEMENT_FIELD, DIALOG_CODE_HOOK_FIELD, FULFILLMENT_ACTIVITY_FIELD, PARENT_INTENT_SIGNATURE_FIELD,
            CHECKSUM_FIELD, CREATE_VERSION_FIELD, KENDRA_CONFIGURATION_FIELD, INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD));

    private final String name;

    private final String description;

    private final List<Slot> slots;

    private final List<String> sampleUtterances;

    private final Prompt confirmationPrompt;

    private final Statement rejectionStatement;

    private final FollowUpPrompt followUpPrompt;

    private final Statement conclusionStatement;

    private final CodeHook dialogCodeHook;

    private final FulfillmentActivity fulfillmentActivity;

    private final String parentIntentSignature;

    private final String checksum;

    private final Boolean createVersion;

    private final KendraConfiguration kendraConfiguration;

    private final List<InputContext> inputContexts;

    private final List<OutputContext> outputContexts;

    private PutIntentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.checksum = builder.checksum;
        this.createVersion = builder.createVersion;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
    }

    /**
     * <p>
     * The name of the intent. The name is <i>not</i> case sensitive.
     * </p>
     * <p>
     * The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example,
     * because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a custom intent called
     * <code>HelpIntent</code>.
     * </p>
     * <p>
     * For a list of built-in intents, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return The name of the intent. The name is <i>not</i> case sensitive. </p>
     *         <p>
     *         The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For
     *         example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a
     *         custom intent called <code>HelpIntent</code>.
     *         </p>
     *         <p>
     *         For a list of built-in intents, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     *         >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the intent.
     * </p>
     * 
     * @return A description of the intent.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Slots property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSlots() {
        return slots != null && !(slots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts defined
     * in the slots. For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSlots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts
     *         defined in the slots. For more information, see <a>how-it-works</a>.
     */
    public final List<Slot> slots() {
        return slots;
    }

    /**
     * Returns true if the SampleUtterances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of utterances (strings) that a user might say to signal the intent. For example,
     * "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * </p>
     * <p>
     * In each utterance, a slot name is enclosed in curly braces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSampleUtterances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of utterances (strings) that a user might say to signal the intent. For example,
     *         "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
     *         <p>
     *         In each utterance, a slot name is enclosed in curly braces.
     */
    public final List<String> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * Prompts the user to confirm the intent. This question should have a yes or no answer.
     * </p>
     * <p>
     * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For
     * example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before
     * placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask
     * the user for confirmation before providing the information.
     * </p>
     * <note>
     * <p>
     * You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
     * neither.
     * </p>
     * </note>
     * 
     * @return Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
     *         <p>
     *         Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
     *         fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
     *         order is correct before placing it. For other intents, such as intents that simply respond to user
     *         questions, you might not need to ask the user for confirmation before providing the information.
     *         </p>
     *         <note>
     *         <p>
     *         You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
     *         neither.
     *         </p>
     */
    public final Prompt confirmationPrompt() {
        return confirmationPrompt;
    }

    /**
     * <p>
     * When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with
     * this statement to acknowledge that the intent was canceled.
     * </p>
     * <note>
     * <p>
     * You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.
     * </p>
     * </note>
     * 
     * @return When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex
     *         responds with this statement to acknowledge that the intent was canceled. </p> <note>
     *         <p>
     *         You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
     *         neither.
     *         </p>
     */
    public final Statement rejectionStatement() {
        return rejectionStatement;
    }

    /**
     * <p>
     * Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the
     * <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.
     * </p>
     * <p>
     * The action that Amazon Lex takes depends on the user's response, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the user says "Yes" it responds with the clarification prompt that is configured for the bot.
     * </p>
     * </li>
     * <li>
     * <p>
     * if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for the
     * intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.
     * </p>
     * </li>
     * <li>
     * <p>
     * If it doesn't recognize the utterance it repeats the follow-up prompt again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive. You
     * can specify only one.
     * </p>
     * 
     * @return Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after
     *         the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.</p>
     *         <p>
     *         The action that Amazon Lex takes depends on the user's response, as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the user says "Yes" it responds with the clarification prompt that is configured for the bot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation
     *         for the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If it doesn't recognize the utterance it repeats the follow-up prompt again.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually
     *         exclusive. You can specify only one.
     */
    public final FollowUpPrompt followUpPrompt() {
        return followUpPrompt;
    }

    /**
     * <p>
     * The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by the
     * Lambda function.
     * </p>
     * <p>
     * This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If you
     * return the intent to the client application, you can't specify this element.
     * </p>
     * <note>
     * <p>
     * The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only
     * one.
     * </p>
     * </note>
     * 
     * @return The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled
     *         by the Lambda function. </p>
     *         <p>
     *         This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>.
     *         If you return the intent to the client application, you can't specify this element.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can
     *         specify only one.
     *         </p>
     */
    public final Statement conclusionStatement() {
        return conclusionStatement;
    }

    /**
     * <p>
     * Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize
     * user interaction.
     * </p>
     * <p>
     * For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's
     * information from a backend database and prepopulate some of the values. For example, if you find that John is
     * gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You might
     * find John's phone number and set the corresponding session attribute.
     * </p>
     * 
     * @return Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to
     *         personalize user interaction. </p>
     *         <p>
     *         For example, suppose your bot determines that the user is John. Your Lambda function might retrieve
     *         John's information from a backend database and prepopulate some of the values. For example, if you find
     *         that John is gluten intolerant, you might set the corresponding intent slot,
     *         <code>GlutenIntolerant</code>, to true. You might find John's phone number and set the corresponding
     *         session attribute.
     */
    public final CodeHook dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * Required. Describes how the intent is fulfilled. For example, after a user provides all of the information for a
     * pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store.
     * </p>
     * <p>
     * You might configure Amazon Lex to return all of the intent information to the client application, or direct it to
     * invoke a Lambda function that can process the intent (for example, place an order with a pizzeria).
     * </p>
     * 
     * @return Required. Describes how the intent is fulfilled. For example, after a user provides all of the
     *         information for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with
     *         a local pizza store. </p>
     *         <p>
     *         You might configure Amazon Lex to return all of the intent information to the client application, or
     *         direct it to invoke a Lambda function that can process the intent (for example, place an order with a
     *         pizzeria).
     */
    public final FulfillmentActivity fulfillmentActivity() {
        return fulfillmentActivity;
    }

    /**
     * <p>
     * A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see <a
     * href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return A unique identifier for the built-in intent to base this intent on. To find the signature for an intent,
     *         see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     *         >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     */
    public final String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * <p>
     * Identifies a specific revision of the <code>$LATEST</code> version.
     * </p>
     * <p>
     * When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get a
     * <code>BadRequestException</code> exception.
     * </p>
     * <p>
     * When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent revision
     * of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum
     * does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.
     * </p>
     * 
     * @return Identifies a specific revision of the <code>$LATEST</code> version.</p>
     *         <p>
     *         When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you
     *         get a <code>BadRequestException</code> exception.
     *         </p>
     *         <p>
     *         When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent
     *         revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or
     *         if the checksum does not match the <code>$LATEST</code> version, you get a
     *         <code>PreconditionFailedException</code> exception.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * When set to <code>true</code> a new numbered version of the intent is created. This is the same as calling the
     * <code>CreateIntentVersion</code> operation. If you do not specify <code>createVersion</code>, the default is
     * <code>false</code>.
     * </p>
     * 
     * @return When set to <code>true</code> a new numbered version of the intent is created. This is the same as
     *         calling the <code>CreateIntentVersion</code> operation. If you do not specify <code>createVersion</code>,
     *         the default is <code>false</code>.
     */
    public final Boolean createVersion() {
        return createVersion;
    }

    /**
     * <p>
     * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an
     * Amazon Kendra index. For more information, see <a
     * href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
     * AMAZON.KendraSearchIntent</a>.
     * </p>
     * 
     * @return Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to
     *         an Amazon Kendra index. For more information, see <a
     *         href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
     *         AMAZON.KendraSearchIntent</a>.
     */
    public final KendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    /**
     * Returns true if the InputContexts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInputContexts() {
        return inputContexts != null && !(inputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
     * choose the intent in a conversation with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputContexts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex
     *         to choose the intent in a conversation with the user.
     */
    public final List<InputContext> inputContexts() {
        return inputContexts;
    }

    /**
     * Returns true if the OutputContexts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputContexts() {
        return outputContexts != null && !(outputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent
     * is fulfilled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputContexts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
     *         intent is fulfilled.
     */
    public final List<OutputContext> outputContexts() {
        return outputContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlots() ? slots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(confirmationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(followUpPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(conclusionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentActivity());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputContexts() ? inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputContexts() ? outputContexts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntentRequest)) {
            return false;
        }
        PutIntentRequest other = (PutIntentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasSlots() == other.hasSlots() && Objects.equals(slots(), other.slots())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(confirmationPrompt(), other.confirmationPrompt())
                && Objects.equals(rejectionStatement(), other.rejectionStatement())
                && Objects.equals(followUpPrompt(), other.followUpPrompt())
                && Objects.equals(conclusionStatement(), other.conclusionStatement())
                && Objects.equals(dialogCodeHook(), other.dialogCodeHook())
                && Objects.equals(fulfillmentActivity(), other.fulfillmentActivity())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && Objects.equals(checksum(), other.checksum()) && Objects.equals(createVersion(), other.createVersion())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration())
                && hasInputContexts() == other.hasInputContexts() && Objects.equals(inputContexts(), other.inputContexts())
                && hasOutputContexts() == other.hasOutputContexts() && Objects.equals(outputContexts(), other.outputContexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutIntentRequest").add("Name", name()).add("Description", description())
                .add("Slots", hasSlots() ? slots() : null)
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("ConfirmationPrompt", confirmationPrompt()).add("RejectionStatement", rejectionStatement())
                .add("FollowUpPrompt", followUpPrompt()).add("ConclusionStatement", conclusionStatement())
                .add("DialogCodeHook", dialogCodeHook()).add("FulfillmentActivity", fulfillmentActivity())
                .add("ParentIntentSignature", parentIntentSignature()).add("Checksum", checksum())
                .add("CreateVersion", createVersion()).add("KendraConfiguration", kendraConfiguration())
                .add("InputContexts", hasInputContexts() ? inputContexts() : null)
                .add("OutputContexts", hasOutputContexts() ? outputContexts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slots":
            return Optional.ofNullable(clazz.cast(slots()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "confirmationPrompt":
            return Optional.ofNullable(clazz.cast(confirmationPrompt()));
        case "rejectionStatement":
            return Optional.ofNullable(clazz.cast(rejectionStatement()));
        case "followUpPrompt":
            return Optional.ofNullable(clazz.cast(followUpPrompt()));
        case "conclusionStatement":
            return Optional.ofNullable(clazz.cast(conclusionStatement()));
        case "dialogCodeHook":
            return Optional.ofNullable(clazz.cast(dialogCodeHook()));
        case "fulfillmentActivity":
            return Optional.ofNullable(clazz.cast(fulfillmentActivity()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "createVersion":
            return Optional.ofNullable(clazz.cast(createVersion()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        case "inputContexts":
            return Optional.ofNullable(clazz.cast(inputContexts()));
        case "outputContexts":
            return Optional.ofNullable(clazz.cast(outputContexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntentRequest, T> g) {
        return obj -> g.apply((PutIntentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutIntentRequest> {
        /**
         * <p>
         * The name of the intent. The name is <i>not</i> case sensitive.
         * </p>
         * <p>
         * The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example,
         * because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a custom intent
         * called <code>HelpIntent</code>.
         * </p>
         * <p>
         * For a list of built-in intents, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param name
         *        The name of the intent. The name is <i>not</i> case sensitive. </p>
         *        <p>
         *        The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For
         *        example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a
         *        custom intent called <code>HelpIntent</code>.
         *        </p>
         *        <p>
         *        For a list of built-in intents, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         *        >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the intent.
         * </p>
         * 
         * @param description
         *        A description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts
         * defined in the slots. For more information, see <a>how-it-works</a>.
         * </p>
         * 
         * @param slots
         *        An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using
         *        prompts defined in the slots. For more information, see <a>how-it-works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<Slot> slots);

        /**
         * <p>
         * An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts
         * defined in the slots. For more information, see <a>how-it-works</a>.
         * </p>
         * 
         * @param slots
         *        An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using
         *        prompts defined in the slots. For more information, see <a>how-it-works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Slot... slots);

        /**
         * <p>
         * An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts
         * defined in the slots. For more information, see <a>how-it-works</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Slot>.Builder} avoiding the need to create
         * one manually via {@link List<Slot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Slot>.Builder#build()} is called immediately and its result
         * is passed to {@link #slots(List<Slot>)}.
         * 
         * @param slots
         *        a consumer that will call methods on {@link List<Slot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slots(List<Slot>)
         */
        Builder slots(Consumer<Slot.Builder>... slots);

        /**
         * <p>
         * An array of utterances (strings) that a user might say to signal the intent. For example,
         * "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
         * </p>
         * <p>
         * In each utterance, a slot name is enclosed in curly braces.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of utterances (strings) that a user might say to signal the intent. For example,
         *        "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
         *        <p>
         *        In each utterance, a slot name is enclosed in curly braces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<String> sampleUtterances);

        /**
         * <p>
         * An array of utterances (strings) that a user might say to signal the intent. For example,
         * "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
         * </p>
         * <p>
         * In each utterance, a slot name is enclosed in curly braces.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of utterances (strings) that a user might say to signal the intent. For example,
         *        "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
         *        <p>
         *        In each utterance, a slot name is enclosed in curly braces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(String... sampleUtterances);

        /**
         * <p>
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * </p>
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment.
         * For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct
         * before placing it. For other intents, such as intents that simply respond to user questions, you might not
         * need to ask the user for confirmation before providing the information.
         * </p>
         * <note>
         * <p>
         * You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         * neither.
         * </p>
         * </note>
         * 
         * @param confirmationPrompt
         *        Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
         *        <p>
         *        Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
         *        fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
         *        order is correct before placing it. For other intents, such as intents that simply respond to user
         *        questions, you might not need to ask the user for confirmation before providing the information.
         *        </p>
         *        <note>
         *        <p>
         *        You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>,
         *        or neither.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationPrompt(Prompt confirmationPrompt);

        /**
         * <p>
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * </p>
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment.
         * For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct
         * before placing it. For other intents, such as intents that simply respond to user questions, you might not
         * need to ask the user for confirmation before providing the information.
         * </p>
         * <note>
         * <p>
         * You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         * neither.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link Prompt.Builder} avoiding the need to
         * create one manually via {@link Prompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #confirmationPrompt(Prompt)}.
         * 
         * @param confirmationPrompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationPrompt(Prompt)
         */
        default Builder confirmationPrompt(Consumer<Prompt.Builder> confirmationPrompt) {
            return confirmationPrompt(Prompt.builder().applyMutation(confirmationPrompt).build());
        }

        /**
         * <p>
         * When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds
         * with this statement to acknowledge that the intent was canceled.
         * </p>
         * <note>
         * <p>
         * You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         * neither.
         * </p>
         * </note>
         * 
         * @param rejectionStatement
         *        When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex
         *        responds with this statement to acknowledge that the intent was canceled. </p> <note>
         *        <p>
         *        You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         *        neither.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionStatement(Statement rejectionStatement);

        /**
         * <p>
         * When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds
         * with this statement to acknowledge that the intent was canceled.
         * </p>
         * <note>
         * <p>
         * You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         * neither.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to
         * create one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #rejectionStatement(Statement)}.
         * 
         * @param rejectionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectionStatement(Statement)
         */
        default Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return rejectionStatement(Statement.builder().applyMutation(rejectionStatement).build());
        }

        /**
         * <p>
         * Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the
         * <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.
         * </p>
         * <p>
         * The action that Amazon Lex takes depends on the user's response, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the user says "Yes" it responds with the clarification prompt that is configured for the bot.
         * </p>
         * </li>
         * <li>
         * <p>
         * if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for
         * the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.
         * </p>
         * </li>
         * <li>
         * <p>
         * If it doesn't recognize the utterance it repeats the follow-up prompt again.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive.
         * You can specify only one.
         * </p>
         * 
         * @param followUpPrompt
         *        Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example,
         *        after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.</p>
         *        <p>
         *        The action that Amazon Lex takes depends on the user's response, as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the user says "Yes" it responds with the clarification prompt that is configured for the bot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        if the user says "Yes" and continues with an utterance that triggers an intent it starts a
         *        conversation for the intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the user says "No" it responds with the rejection statement configured for the the follow-up
         *        prompt.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If it doesn't recognize the utterance it repeats the follow-up prompt again.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually
         *        exclusive. You can specify only one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder followUpPrompt(FollowUpPrompt followUpPrompt);

        /**
         * <p>
         * Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the
         * <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.
         * </p>
         * <p>
         * The action that Amazon Lex takes depends on the user's response, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the user says "Yes" it responds with the clarification prompt that is configured for the bot.
         * </p>
         * </li>
         * <li>
         * <p>
         * if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for
         * the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.
         * </p>
         * </li>
         * <li>
         * <p>
         * If it doesn't recognize the utterance it repeats the follow-up prompt again.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive.
         * You can specify only one.
         * </p>
         * This is a convenience that creates an instance of the {@link FollowUpPrompt.Builder} avoiding the need to
         * create one manually via {@link FollowUpPrompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link FollowUpPrompt.Builder#build()} is called immediately and its
         * result is passed to {@link #followUpPrompt(FollowUpPrompt)}.
         * 
         * @param followUpPrompt
         *        a consumer that will call methods on {@link FollowUpPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #followUpPrompt(FollowUpPrompt)
         */
        default Builder followUpPrompt(Consumer<FollowUpPrompt.Builder> followUpPrompt) {
            return followUpPrompt(FollowUpPrompt.builder().applyMutation(followUpPrompt).build());
        }

        /**
         * <p>
         * The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by
         * the Lambda function.
         * </p>
         * <p>
         * This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If
         * you return the intent to the client application, you can't specify this element.
         * </p>
         * <note>
         * <p>
         * The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify
         * only one.
         * </p>
         * </note>
         * 
         * @param conclusionStatement
         *        The statement that you want Amazon Lex to convey to the user after the intent is successfully
         *        fulfilled by the Lambda function. </p>
         *        <p>
         *        This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>
         *        . If you return the intent to the client application, you can't specify this element.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can
         *        specify only one.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conclusionStatement(Statement conclusionStatement);

        /**
         * <p>
         * The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by
         * the Lambda function.
         * </p>
         * <p>
         * This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If
         * you return the intent to the client application, you can't specify this element.
         * </p>
         * <note>
         * <p>
         * The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify
         * only one.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to
         * create one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #conclusionStatement(Statement)}.
         * 
         * @param conclusionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conclusionStatement(Statement)
         */
        default Builder conclusionStatement(Consumer<Statement.Builder> conclusionStatement) {
            return conclusionStatement(Statement.builder().applyMutation(conclusionStatement).build());
        }

        /**
         * <p>
         * Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize
         * user interaction.
         * </p>
         * <p>
         * For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's
         * information from a backend database and prepopulate some of the values. For example, if you find that John is
         * gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You
         * might find John's phone number and set the corresponding session attribute.
         * </p>
         * 
         * @param dialogCodeHook
         *        Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to
         *        personalize user interaction. </p>
         *        <p>
         *        For example, suppose your bot determines that the user is John. Your Lambda function might retrieve
         *        John's information from a backend database and prepopulate some of the values. For example, if you
         *        find that John is gluten intolerant, you might set the corresponding intent slot,
         *        <code>GlutenIntolerant</code>, to true. You might find John's phone number and set the corresponding
         *        session attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(CodeHook dialogCodeHook);

        /**
         * <p>
         * Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize
         * user interaction.
         * </p>
         * <p>
         * For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's
         * information from a backend database and prepopulate some of the values. For example, if you find that John is
         * gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You
         * might find John's phone number and set the corresponding session attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeHook.Builder} avoiding the need to create
         * one manually via {@link CodeHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeHook.Builder#build()} is called immediately and its result is
         * passed to {@link #dialogCodeHook(CodeHook)}.
         * 
         * @param dialogCodeHook
         *        a consumer that will call methods on {@link CodeHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogCodeHook(CodeHook)
         */
        default Builder dialogCodeHook(Consumer<CodeHook.Builder> dialogCodeHook) {
            return dialogCodeHook(CodeHook.builder().applyMutation(dialogCodeHook).build());
        }

        /**
         * <p>
         * Required. Describes how the intent is fulfilled. For example, after a user provides all of the information
         * for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza
         * store.
         * </p>
         * <p>
         * You might configure Amazon Lex to return all of the intent information to the client application, or direct
         * it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria).
         * </p>
         * 
         * @param fulfillmentActivity
         *        Required. Describes how the intent is fulfilled. For example, after a user provides all of the
         *        information for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order
         *        with a local pizza store. </p>
         *        <p>
         *        You might configure Amazon Lex to return all of the intent information to the client application, or
         *        direct it to invoke a Lambda function that can process the intent (for example, place an order with a
         *        pizzeria).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity);

        /**
         * <p>
         * Required. Describes how the intent is fulfilled. For example, after a user provides all of the information
         * for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza
         * store.
         * </p>
         * <p>
         * You might configure Amazon Lex to return all of the intent information to the client application, or direct
         * it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria).
         * </p>
         * This is a convenience that creates an instance of the {@link FulfillmentActivity.Builder} avoiding the need
         * to create one manually via {@link FulfillmentActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link FulfillmentActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #fulfillmentActivity(FulfillmentActivity)}.
         * 
         * @param fulfillmentActivity
         *        a consumer that will call methods on {@link FulfillmentActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentActivity(FulfillmentActivity)
         */
        default Builder fulfillmentActivity(Consumer<FulfillmentActivity.Builder> fulfillmentActivity) {
            return fulfillmentActivity(FulfillmentActivity.builder().applyMutation(fulfillmentActivity).build());
        }

        /**
         * <p>
         * A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see
         * <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param parentIntentSignature
         *        A unique identifier for the built-in intent to base this intent on. To find the signature for an
         *        intent, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         *        >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * Identifies a specific revision of the <code>$LATEST</code> version.
         * </p>
         * <p>
         * When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get
         * a <code>BadRequestException</code> exception.
         * </p>
         * <p>
         * When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent
         * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if
         * the checksum does not match the <code>$LATEST</code> version, you get a
         * <code>PreconditionFailedException</code> exception.
         * </p>
         * 
         * @param checksum
         *        Identifies a specific revision of the <code>$LATEST</code> version.</p>
         *        <p>
         *        When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum
         *        you get a <code>BadRequestException</code> exception.
         *        </p>
         *        <p>
         *        When you want to update a intent, set the <code>checksum</code> field to the checksum of the most
         *        recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
         *        field, or if the checksum does not match the <code>$LATEST</code> version, you get a
         *        <code>PreconditionFailedException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * When set to <code>true</code> a new numbered version of the intent is created. This is the same as calling
         * the <code>CreateIntentVersion</code> operation. If you do not specify <code>createVersion</code>, the default
         * is <code>false</code>.
         * </p>
         * 
         * @param createVersion
         *        When set to <code>true</code> a new numbered version of the intent is created. This is the same as
         *        calling the <code>CreateIntentVersion</code> operation. If you do not specify
         *        <code>createVersion</code>, the default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVersion(Boolean createVersion);

        /**
         * <p>
         * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an
         * Amazon Kendra index. For more information, see <a
         * href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
         * AMAZON.KendraSearchIntent</a>.
         * </p>
         * 
         * @param kendraConfiguration
         *        Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect
         *        to an Amazon Kendra index. For more information, see <a
         *        href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
         *        AMAZON.KendraSearchIntent</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(KendraConfiguration kendraConfiguration);

        /**
         * <p>
         * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an
         * Amazon Kendra index. For more information, see <a
         * href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
         * AMAZON.KendraSearchIntent</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link KendraConfiguration.Builder} avoiding the need
         * to create one manually via {@link KendraConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link KendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(KendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link KendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(KendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(KendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }

        /**
         * <p>
         * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
         * choose the intent in a conversation with the user.
         * </p>
         * 
         * @param inputContexts
         *        An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon
         *        Lex to choose the intent in a conversation with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(Collection<InputContext> inputContexts);

        /**
         * <p>
         * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
         * choose the intent in a conversation with the user.
         * </p>
         * 
         * @param inputContexts
         *        An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon
         *        Lex to choose the intent in a conversation with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(InputContext... inputContexts);

        /**
         * <p>
         * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
         * choose the intent in a conversation with the user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InputContext>.Builder} avoiding the need to
         * create one manually via {@link List<InputContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputContext>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputContexts(List<InputContext>)}.
         * 
         * @param inputContexts
         *        a consumer that will call methods on {@link List<InputContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputContexts(List<InputContext>)
         */
        Builder inputContexts(Consumer<InputContext.Builder>... inputContexts);

        /**
         * <p>
         * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
         * intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when
         *        the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(Collection<OutputContext> outputContexts);

        /**
         * <p>
         * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
         * intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when
         *        the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(OutputContext... outputContexts);

        /**
         * <p>
         * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
         * intent is fulfilled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OutputContext>.Builder} avoiding the need
         * to create one manually via {@link List<OutputContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputContext>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputContexts(List<OutputContext>)}.
         * 
         * @param outputContexts
         *        a consumer that will call methods on {@link List<OutputContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputContexts(List<OutputContext>)
         */
        Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Slot> slots = DefaultSdkAutoConstructList.getInstance();

        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private Prompt confirmationPrompt;

        private Statement rejectionStatement;

        private FollowUpPrompt followUpPrompt;

        private Statement conclusionStatement;

        private CodeHook dialogCodeHook;

        private FulfillmentActivity fulfillmentActivity;

        private String parentIntentSignature;

        private String checksum;

        private Boolean createVersion;

        private KendraConfiguration kendraConfiguration;

        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();

        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntentRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            slots(model.slots);
            sampleUtterances(model.sampleUtterances);
            confirmationPrompt(model.confirmationPrompt);
            rejectionStatement(model.rejectionStatement);
            followUpPrompt(model.followUpPrompt);
            conclusionStatement(model.conclusionStatement);
            dialogCodeHook(model.dialogCodeHook);
            fulfillmentActivity(model.fulfillmentActivity);
            parentIntentSignature(model.parentIntentSignature);
            checksum(model.checksum);
            createVersion(model.createVersion);
            kendraConfiguration(model.kendraConfiguration);
            inputContexts(model.inputContexts);
            outputContexts(model.outputContexts);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<Slot.Builder> getSlots() {
            List<Slot.Builder> result = SlotListCopier.copyToBuilder(this.slots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<Slot.Builder>... slots) {
            slots(Stream.of(slots).map(c -> Slot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotListCopier.copyFromBuilder(slots);
        }

        public final Collection<String> getSampleUtterances() {
            if (sampleUtterances instanceof SdkAutoConstructList) {
                return null;
            }
            return sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        public final Prompt.Builder getConfirmationPrompt() {
            return confirmationPrompt != null ? confirmationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final void setConfirmationPrompt(Prompt.BuilderImpl confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt != null ? confirmationPrompt.build() : null;
        }

        public final Statement.Builder getRejectionStatement() {
            return rejectionStatement != null ? rejectionStatement.toBuilder() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        public final FollowUpPrompt.Builder getFollowUpPrompt() {
            return followUpPrompt != null ? followUpPrompt.toBuilder() : null;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final void setFollowUpPrompt(FollowUpPrompt.BuilderImpl followUpPrompt) {
            this.followUpPrompt = followUpPrompt != null ? followUpPrompt.build() : null;
        }

        public final Statement.Builder getConclusionStatement() {
            return conclusionStatement != null ? conclusionStatement.toBuilder() : null;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final void setConclusionStatement(Statement.BuilderImpl conclusionStatement) {
            this.conclusionStatement = conclusionStatement != null ? conclusionStatement.build() : null;
        }

        public final CodeHook.Builder getDialogCodeHook() {
            return dialogCodeHook != null ? dialogCodeHook.toBuilder() : null;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(CodeHook.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        public final FulfillmentActivity.Builder getFulfillmentActivity() {
            return fulfillmentActivity != null ? fulfillmentActivity.toBuilder() : null;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final void setFulfillmentActivity(FulfillmentActivity.BuilderImpl fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity != null ? fulfillmentActivity.build() : null;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Boolean getCreateVersion() {
            return createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext... inputContexts) {
            inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder>... inputContexts) {
            inputContexts(Stream.of(inputContexts).map(c -> InputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextListCopier.copyFromBuilder(inputContexts);
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext... outputContexts) {
            outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts) {
            outputContexts(Stream.of(outputContexts).map(c -> OutputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntentRequest build() {
            return new PutIntentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
