/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMigrationsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetMigrationsResponse.Builder, GetMigrationsResponse> {
    private static final SdkField<List<MigrationSummary>> MIGRATION_SUMMARIES_FIELD = SdkField
            .<List<MigrationSummary>> builder(MarshallingType.LIST)
            .memberName("migrationSummaries")
            .getter(getter(GetMigrationsResponse::migrationSummaries))
            .setter(setter(Builder::migrationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MigrationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MigrationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetMigrationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MigrationSummary> migrationSummaries;

    private final String nextToken;

    private GetMigrationsResponse(BuilderImpl builder) {
        super(builder);
        this.migrationSummaries = builder.migrationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the MigrationSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMigrationSummaries() {
        return migrationSummaries != null && !(migrationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration, use
     * the <code>migrationId</code> from the summary in a call to the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMigrationSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the
     *         migration, use the <code>migrationId</code> from the summary in a call to the operation.
     */
    public final List<MigrationSummary> migrationSummaries() {
        return migrationSummaries;
    }

    /**
     * <p>
     * If the response is truncated, it includes a pagination token that you can specify in your next request to fetch
     * the next page of migrations.
     * </p>
     * 
     * @return If the response is truncated, it includes a pagination token that you can specify in your next request to
     *         fetch the next page of migrations.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMigrationSummaries() ? migrationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMigrationsResponse)) {
            return false;
        }
        GetMigrationsResponse other = (GetMigrationsResponse) obj;
        return hasMigrationSummaries() == other.hasMigrationSummaries()
                && Objects.equals(migrationSummaries(), other.migrationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMigrationsResponse")
                .add("MigrationSummaries", hasMigrationSummaries() ? migrationSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "migrationSummaries":
            return Optional.ofNullable(clazz.cast(migrationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMigrationsResponse, T> g) {
        return obj -> g.apply((GetMigrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMigrationsResponse> {
        /**
         * <p>
         * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration,
         * use the <code>migrationId</code> from the summary in a call to the operation.
         * </p>
         * 
         * @param migrationSummaries
         *        An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the
         *        migration, use the <code>migrationId</code> from the summary in a call to the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationSummaries(Collection<MigrationSummary> migrationSummaries);

        /**
         * <p>
         * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration,
         * use the <code>migrationId</code> from the summary in a call to the operation.
         * </p>
         * 
         * @param migrationSummaries
         *        An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the
         *        migration, use the <code>migrationId</code> from the summary in a call to the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationSummaries(MigrationSummary... migrationSummaries);

        /**
         * <p>
         * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration,
         * use the <code>migrationId</code> from the summary in a call to the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MigrationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<MigrationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MigrationSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #migrationSummaries(List<MigrationSummary>)}.
         * 
         * @param migrationSummaries
         *        a consumer that will call methods on {@link List<MigrationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationSummaries(List<MigrationSummary>)
         */
        Builder migrationSummaries(Consumer<MigrationSummary.Builder>... migrationSummaries);

        /**
         * <p>
         * If the response is truncated, it includes a pagination token that you can specify in your next request to
         * fetch the next page of migrations.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, it includes a pagination token that you can specify in your next request
         *        to fetch the next page of migrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<MigrationSummary> migrationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMigrationsResponse model) {
            super(model);
            migrationSummaries(model.migrationSummaries);
            nextToken(model.nextToken);
        }

        public final List<MigrationSummary.Builder> getMigrationSummaries() {
            List<MigrationSummary.Builder> result = MigrationSummaryListCopier.copyToBuilder(this.migrationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder migrationSummaries(Collection<MigrationSummary> migrationSummaries) {
            this.migrationSummaries = MigrationSummaryListCopier.copy(migrationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationSummaries(MigrationSummary... migrationSummaries) {
            migrationSummaries(Arrays.asList(migrationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationSummaries(Consumer<MigrationSummary.Builder>... migrationSummaries) {
            migrationSummaries(Stream.of(migrationSummaries).map(c -> MigrationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMigrationSummaries(Collection<MigrationSummary.BuilderImpl> migrationSummaries) {
            this.migrationSummaries = MigrationSummaryListCopier.copyFromBuilder(migrationSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetMigrationsResponse build() {
            return new GetMigrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
