/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotVersionsCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUtterancesViewRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetUtterancesViewRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(GetUtterancesViewRequest.getter(GetUtterancesViewRequest::botName)).setter(GetUtterancesViewRequest.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botname").build()}).build();
    private static final SdkField<List<String>> BOT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botVersions").getter(GetUtterancesViewRequest.getter(GetUtterancesViewRequest::botVersions)).setter(GetUtterancesViewRequest.setter(Builder::botVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("bot_versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusType").getter(GetUtterancesViewRequest.getter(GetUtterancesViewRequest::statusTypeAsString)).setter(GetUtterancesViewRequest.setter(Builder::statusType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status_type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, BOT_VERSIONS_FIELD, STATUS_TYPE_FIELD));
    private final String botName;
    private final List<String> botVersions;
    private final String statusType;

    private GetUtterancesViewRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botVersions = builder.botVersions;
        this.statusType = builder.statusType;
    }

    public final String botName() {
        return this.botName;
    }

    public final boolean hasBotVersions() {
        return this.botVersions != null && !(this.botVersions instanceof SdkAutoConstructList);
    }

    public final List<String> botVersions() {
        return this.botVersions;
    }

    public final StatusType statusType() {
        return StatusType.fromValue(this.statusType);
    }

    public final String statusTypeAsString() {
        return this.statusType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotVersions() ? this.botVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewRequest)) {
            return false;
        }
        GetUtterancesViewRequest other = (GetUtterancesViewRequest)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && this.hasBotVersions() == other.hasBotVersions() && Objects.equals(this.botVersions(), other.botVersions()) && Objects.equals(this.statusTypeAsString(), other.statusTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetUtterancesViewRequest").add("BotName", (Object)this.botName()).add("BotVersions", this.hasBotVersions() ? this.botVersions() : null).add("StatusType", (Object)this.statusTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botVersions": {
                return Optional.ofNullable(clazz.cast(this.botVersions()));
            }
            case "statusType": {
                return Optional.ofNullable(clazz.cast(this.statusTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUtterancesViewRequest, T> g) {
        return obj -> g.apply((GetUtterancesViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String botName;
        private List<String> botVersions = DefaultSdkAutoConstructList.getInstance();
        private String statusType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewRequest model) {
            super(model);
            this.botName(model.botName);
            this.botVersions(model.botVersions);
            this.statusType(model.statusType);
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        @Transient
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final Collection<String> getBotVersions() {
            if (this.botVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.botVersions;
        }

        public final void setBotVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
        }

        @Override
        @Transient
        public final Builder botVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder botVersions(String ... botVersions) {
            this.botVersions(Arrays.asList(botVersions));
            return this;
        }

        public final String getStatusType() {
            return this.statusType;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        @Override
        @Transient
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        @Override
        @Transient
        public final Builder statusType(StatusType statusType) {
            this.statusType(statusType == null ? null : statusType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUtterancesViewRequest build() {
            return new GetUtterancesViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUtterancesViewRequest> {
        public Builder botName(String var1);

        public Builder botVersions(Collection<String> var1);

        public Builder botVersions(String ... var1);

        public Builder statusType(String var1);

        public Builder statusType(StatusType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

