/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBotResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<PutBotResponse.Builder, PutBotResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutBotResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PutBotResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Intent>> INTENTS_FIELD = SdkField
            .<List<Intent>> builder(MarshallingType.LIST)
            .memberName("intents")
            .getter(getter(PutBotResponse::intents))
            .setter(setter(Builder::intents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Intent> builder(MarshallingType.SDK_POJO)
                                            .constructor(Intent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_MODEL_IMPROVEMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableModelImprovements").getter(getter(PutBotResponse::enableModelImprovements))
            .setter(setter(Builder::enableModelImprovements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableModelImprovements").build())
            .build();

    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("nluIntentConfidenceThreshold")
            .getter(getter(PutBotResponse::nluIntentConfidenceThreshold))
            .setter(setter(Builder::nluIntentConfidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold")
                    .build()).build();

    private static final SdkField<Prompt> CLARIFICATION_PROMPT_FIELD = SdkField.<Prompt> builder(MarshallingType.SDK_POJO)
            .memberName("clarificationPrompt").getter(getter(PutBotResponse::clarificationPrompt))
            .setter(setter(Builder::clarificationPrompt)).constructor(Prompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clarificationPrompt").build())
            .build();

    private static final SdkField<Statement> ABORT_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .memberName("abortStatement").getter(getter(PutBotResponse::abortStatement)).setter(setter(Builder::abortStatement))
            .constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortStatement").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PutBotResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(PutBotResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(PutBotResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(PutBotResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(PutBotResponse::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> VOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("voiceId").getter(getter(PutBotResponse::voiceId)).setter(setter(Builder::voiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceId").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(PutBotResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(PutBotResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(PutBotResponse::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final SdkField<Boolean> CHILD_DIRECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("childDirected").getter(getter(PutBotResponse::childDirected)).setter(setter(Builder::childDirected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childDirected").build()).build();

    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createVersion").getter(getter(PutBotResponse::createVersion)).setter(setter(Builder::createVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()).build();

    private static final SdkField<Boolean> DETECT_SENTIMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("detectSentiment").getter(getter(PutBotResponse::detectSentiment))
            .setter(setter(Builder::detectSentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectSentiment").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(PutBotResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            INTENTS_FIELD, ENABLE_MODEL_IMPROVEMENTS_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, CLARIFICATION_PROMPT_FIELD,
            ABORT_STATEMENT_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD,
            IDLE_SESSION_TTL_IN_SECONDS_FIELD, VOICE_ID_FIELD, CHECKSUM_FIELD, VERSION_FIELD, LOCALE_FIELD, CHILD_DIRECTED_FIELD,
            CREATE_VERSION_FIELD, DETECT_SENTIMENT_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final List<Intent> intents;

    private final Boolean enableModelImprovements;

    private final Double nluIntentConfidenceThreshold;

    private final Prompt clarificationPrompt;

    private final Statement abortStatement;

    private final String status;

    private final String failureReason;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final Integer idleSessionTTLInSeconds;

    private final String voiceId;

    private final String checksum;

    private final String version;

    private final String locale;

    private final Boolean childDirected;

    private final Boolean createVersion;

    private final Boolean detectSentiment;

    private final List<Tag> tags;

    private PutBotResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.enableModelImprovements = builder.enableModelImprovements;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.version = builder.version;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
        this.createVersion = builder.createVersion;
        this.detectSentiment = builder.detectSentiment;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the bot.
     * </p>
     * 
     * @return The name of the bot.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot.
     * </p>
     * 
     * @return A description of the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Intents property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIntents() {
        return intents != null && !(intents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIntents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
     */
    public final List<Intent> intents() {
        return intents;
    }

    /**
     * <p>
     * Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the
     * improvements, otherwise, <code>false</code>.
     * </p>
     * 
     * @return Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using
     *         the improvements, otherwise, <code>false</code>.
     */
    public final Boolean enableModelImprovements() {
        return enableModelImprovements;
    }

    /**
     * <p>
     * The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>,
     * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
     * <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this value.
     * <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.
     * </p>
     * 
     * @return The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>,
     *         <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
     *         <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this
     *         value. <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.
     */
    public final Double nluIntentConfidenceThreshold() {
        return nluIntentConfidenceThreshold;
    }

    /**
     * <p>
     * The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
     * <a>PutBot</a>.
     * </p>
     * 
     * @return The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
     *         <a>PutBot</a>.
     */
    public final Prompt clarificationPrompt() {
        return clarificationPrompt;
    }

    /**
     * <p>
     * The message that Amazon Lex uses to cancel a conversation. For more information, see <a>PutBot</a>.
     * </p>
     * 
     * @return The message that Amazon Lex uses to cancel a conversation. For more information, see <a>PutBot</a>.
     */
    public final Statement abortStatement() {
        return abortStatement;
    }

    /**
     * <p>
     * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex
     * sets the <code>status</code> response element to <code>BUILDING</code>.
     * </p>
     * <p>
     * In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match the
     * utterances configured for the bot's intents and values in the slot types.
     * </p>
     * <p>
     * If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns
     * the reason for the failure in the <code>failureReason</code> response element.
     * </p>
     * <p>
     * When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
     * <code>NOT BUILT</code>.
     * </p>
     * <p>
     * When the bot is in the <code>READY</code> state you can test and publish the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
     *         Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>.</p>
     *         <p>
     *         In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match
     *         the utterances configured for the bot's intents and values in the slot types.
     *         </p>
     *         <p>
     *         If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex
     *         returns the reason for the failure in the <code>failureReason</code> response element.
     *         </p>
     *         <p>
     *         When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
     *         <code>NOT BUILT</code>.
     *         </p>
     *         <p>
     *         When the bot is in the <code>READY</code> state you can test and publish the bot.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex
     * sets the <code>status</code> response element to <code>BUILDING</code>.
     * </p>
     * <p>
     * In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match the
     * utterances configured for the bot's intents and values in the slot types.
     * </p>
     * <p>
     * If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns
     * the reason for the failure in the <code>failureReason</code> response element.
     * </p>
     * <p>
     * When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
     * <code>NOT BUILT</code>.
     * </p>
     * <p>
     * When the bot is in the <code>READY</code> state you can test and publish the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
     *         Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>.</p>
     *         <p>
     *         In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match
     *         the utterances configured for the bot's intents and values in the slot types.
     *         </p>
     *         <p>
     *         If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex
     *         returns the reason for the failure in the <code>failureReason</code> response element.
     *         </p>
     *         <p>
     *         When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
     *         <code>NOT BUILT</code>.
     *         </p>
     *         <p>
     *         When the bot is in the <code>READY</code> state you can test and publish the bot.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.
     * </p>
     * 
     * @return If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the
     *         bot.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date that the bot was updated. When you create a resource, the creation date and last updated date are the
     * same.
     * </p>
     * 
     * @return The date that the bot was updated. When you create a resource, the creation date and last updated date
     *         are the same.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the bot was created.
     * </p>
     * 
     * @return The date that the bot was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more information, see
     * <a>PutBot</a>.
     * </p>
     * 
     * @return The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more
     *         information, see <a>PutBot</a>.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see
     * <a>PutBot</a>.
     * </p>
     * 
     * @return The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information,
     *         see <a>PutBot</a>.
     */
    public final String voiceId() {
        return voiceId;
    }

    /**
     * <p>
     * Checksum of the bot that you created.
     * </p>
     * 
     * @return Checksum of the bot that you created.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
     * </p>
     * 
     * @return The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The target locale for the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The target locale for the bot.
     * @see Locale
     */
    public final Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * The target locale for the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The target locale for the bot.
     * @see Locale
     */
    public final String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of
     * Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in
     * part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying
     * <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code>
     * in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website,
     * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
     * subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
     * use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted,
     * in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the
     * <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a
     * website, program, or other application that is directed or targeted, in whole or in part, to children under age
     * 13 and subject to COPPA.
     * </p>
     * <p>
     * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
     * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
     * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are
     * directed or targeted, in whole or in part, to children under age 13, see the <a
     * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     * </p>
     * 
     * @return For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your
     *         use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in
     *         whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act
     *         (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By
     *         specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon
     *         Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole
     *         or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the
     *         <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a
     *         website, program, or other application that is directed or targeted, in whole or in part, to children
     *         under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code>
     *         field that does not accurately reflect whether your use of Amazon Lex is related to a website, program,
     *         or other application that is directed or targeted, in whole or in part, to children under age 13 and
     *         subject to COPPA.</p>
     *         <p>
     *         If your use of Amazon Lex relates to a website, program, or other application that is directed in whole
     *         or in part, to children under age 13, you must obtain any required verifiable parental consent under
     *         COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other
     *         applications that are directed or targeted, in whole or in part, to children under age 13, see the <a
     *         href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     */
    public final Boolean childDirected() {
        return childDirected;
    }

    /**
     * <p>
     * <code>True</code> if a new version of the bot was created. If the <code>createVersion</code> field was not
     * specified in the request, the <code>createVersion</code> field is set to false in the response.
     * </p>
     * 
     * @return <code>True</code> if a new version of the bot was created. If the <code>createVersion</code> field was
     *         not specified in the request, the <code>createVersion</code> field is set to false in the response.
     */
    public final Boolean createVersion() {
        return createVersion;
    }

    /**
     * <p>
     * <code>true</code> if the bot is configured to send user utterances to Amazon Comprehend for sentiment analysis.
     * If the <code>detectSentiment</code> field was not specified in the request, the <code>detectSentiment</code>
     * field is <code>false</code> in the response.
     * </p>
     * 
     * @return <code>true</code> if the bot is configured to send user utterances to Amazon Comprehend for sentiment
     *         analysis. If the <code>detectSentiment</code> field was not specified in the request, the
     *         <code>detectSentiment</code> field is <code>false</code> in the response.
     */
    public final Boolean detectSentiment() {
        return detectSentiment;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags associated with the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags associated with the bot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasIntents() ? intents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableModelImprovements());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(clarificationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(abortStatement());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(childDirected());
        hashCode = 31 * hashCode + Objects.hashCode(createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(detectSentiment());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotResponse)) {
            return false;
        }
        PutBotResponse other = (PutBotResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasIntents() == other.hasIntents() && Objects.equals(intents(), other.intents())
                && Objects.equals(enableModelImprovements(), other.enableModelImprovements())
                && Objects.equals(nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold())
                && Objects.equals(clarificationPrompt(), other.clarificationPrompt())
                && Objects.equals(abortStatement(), other.abortStatement())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(voiceId(), other.voiceId()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(version(), other.version()) && Objects.equals(localeAsString(), other.localeAsString())
                && Objects.equals(childDirected(), other.childDirected())
                && Objects.equals(createVersion(), other.createVersion())
                && Objects.equals(detectSentiment(), other.detectSentiment()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutBotResponse").add("Name", name()).add("Description", description())
                .add("Intents", hasIntents() ? intents() : null).add("EnableModelImprovements", enableModelImprovements())
                .add("NluIntentConfidenceThreshold", nluIntentConfidenceThreshold())
                .add("ClarificationPrompt", clarificationPrompt()).add("AbortStatement", abortStatement())
                .add("Status", statusAsString()).add("FailureReason", failureReason()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("VoiceId", voiceId()).add("Checksum", checksum()).add("Version", version()).add("Locale", localeAsString())
                .add("ChildDirected", childDirected()).add("CreateVersion", createVersion())
                .add("DetectSentiment", detectSentiment()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "intents":
            return Optional.ofNullable(clazz.cast(intents()));
        case "enableModelImprovements":
            return Optional.ofNullable(clazz.cast(enableModelImprovements()));
        case "nluIntentConfidenceThreshold":
            return Optional.ofNullable(clazz.cast(nluIntentConfidenceThreshold()));
        case "clarificationPrompt":
            return Optional.ofNullable(clazz.cast(clarificationPrompt()));
        case "abortStatement":
            return Optional.ofNullable(clazz.cast(abortStatement()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "voiceId":
            return Optional.ofNullable(clazz.cast(voiceId()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "childDirected":
            return Optional.ofNullable(clazz.cast(childDirected()));
        case "createVersion":
            return Optional.ofNullable(clazz.cast(createVersion()));
        case "detectSentiment":
            return Optional.ofNullable(clazz.cast(detectSentiment()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBotResponse, T> g) {
        return obj -> g.apply((PutBotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutBotResponse> {
        /**
         * <p>
         * The name of the bot.
         * </p>
         * 
         * @param name
         *        The name of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot.
         * </p>
         * 
         * @param description
         *        A description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Collection<Intent> intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Intent... intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Intent>.Builder} avoiding the need to
         * create one manually via {@link List<Intent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Intent>.Builder#build()} is called immediately and its
         * result is passed to {@link #intents(List<Intent>)}.
         * 
         * @param intents
         *        a consumer that will call methods on {@link List<Intent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intents(List<Intent>)
         */
        Builder intents(Consumer<Intent.Builder>... intents);

        /**
         * <p>
         * Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the
         * improvements, otherwise, <code>false</code>.
         * </p>
         * 
         * @param enableModelImprovements
         *        Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is
         *        using the improvements, otherwise, <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableModelImprovements(Boolean enableModelImprovements);

        /**
         * <p>
         * The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>,
         * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
         * <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this value.
         * <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.
         * </p>
         * 
         * @param nluIntentConfidenceThreshold
         *        The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>,
         *        <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
         *        <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this
         *        value. <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold);

        /**
         * <p>
         * The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
         * <a>PutBot</a>.
         * </p>
         * 
         * @param clarificationPrompt
         *        The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information,
         *        see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clarificationPrompt(Prompt clarificationPrompt);

        /**
         * <p>
         * The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
         * <a>PutBot</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Prompt.Builder} avoiding the need to create one
         * manually via {@link Prompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #clarificationPrompt(Prompt)}.
         * 
         * @param clarificationPrompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clarificationPrompt(Prompt)
         */
        default Builder clarificationPrompt(Consumer<Prompt.Builder> clarificationPrompt) {
            return clarificationPrompt(Prompt.builder().applyMutation(clarificationPrompt).build());
        }

        /**
         * <p>
         * The message that Amazon Lex uses to cancel a conversation. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param abortStatement
         *        The message that Amazon Lex uses to cancel a conversation. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortStatement(Statement abortStatement);

        /**
         * <p>
         * The message that Amazon Lex uses to cancel a conversation. For more information, see <a>PutBot</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #abortStatement(Statement)}.
         * 
         * @param abortStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortStatement(Statement)
         */
        default Builder abortStatement(Consumer<Statement.Builder> abortStatement) {
            return abortStatement(Statement.builder().applyMutation(abortStatement).build());
        }

        /**
         * <p>
         * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon
         * Lex sets the <code>status</code> response element to <code>BUILDING</code>.
         * </p>
         * <p>
         * In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match the
         * utterances configured for the bot's intents and values in the slot types.
         * </p>
         * <p>
         * If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex
         * returns the reason for the failure in the <code>failureReason</code> response element.
         * </p>
         * <p>
         * When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
         * <code>NOT BUILT</code>.
         * </p>
         * <p>
         * When the bot is in the <code>READY</code> state you can test and publish the bot.
         * </p>
         * 
         * @param status
         *        When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
         *        Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>.</p>
         *        <p>
         *        In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match
         *        the utterances configured for the bot's intents and values in the slot types.
         *        </p>
         *        <p>
         *        If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon
         *        Lex returns the reason for the failure in the <code>failureReason</code> response element.
         *        </p>
         *        <p>
         *        When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
         *        <code>NOT BUILT</code>.
         *        </p>
         *        <p>
         *        When the bot is in the <code>READY</code> state you can test and publish the bot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon
         * Lex sets the <code>status</code> response element to <code>BUILDING</code>.
         * </p>
         * <p>
         * In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match the
         * utterances configured for the bot's intents and values in the slot types.
         * </p>
         * <p>
         * If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex
         * returns the reason for the failure in the <code>failureReason</code> response element.
         * </p>
         * <p>
         * When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
         * <code>NOT BUILT</code>.
         * </p>
         * <p>
         * When the bot is in the <code>READY</code> state you can test and publish the bot.
         * </p>
         * 
         * @param status
         *        When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
         *        Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>.</p>
         *        <p>
         *        In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match
         *        the utterances configured for the bot's intents and values in the slot types.
         *        </p>
         *        <p>
         *        If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon
         *        Lex returns the reason for the failure in the <code>failureReason</code> response element.
         *        </p>
         *        <p>
         *        When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to
         *        <code>NOT BUILT</code>.
         *        </p>
         *        <p>
         *        When the bot is in the <code>READY</code> state you can test and publish the bot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the
         * bot.
         * </p>
         * 
         * @param failureReason
         *        If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build
         *        the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date that the bot was updated. When you create a resource, the creation date and last updated date are
         * the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the bot was updated. When you create a resource, the creation date and last updated date
         *        are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the bot was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the bot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more information,
         * see <a>PutBot</a>.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more
         *        information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see
         * <a>PutBot</a>.
         * </p>
         * 
         * @param voiceId
         *        The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more
         *        information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceId(String voiceId);

        /**
         * <p>
         * Checksum of the bot that you created.
         * </p>
         * 
         * @param checksum
         *        Checksum of the bot that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
         * </p>
         * 
         * @param version
         *        The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The target locale for the bot.
         * </p>
         * 
         * @param locale
         *        The target locale for the bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * The target locale for the bot.
         * </p>
         * 
         * @param locale
         *        The target locale for the bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use
         * of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole
         * or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by
         * specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying
         * <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b>
         * related to a website, program, or other application that is directed or targeted, in whole or in part, to
         * children under age 13 and subject to COPPA. By specifying <code>false</code> in the
         * <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website,
         * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
         * subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not
         * accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that
         * is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.
         * </p>
         * <p>
         * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
         * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
         * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that
         * are directed or targeted, in whole or in part, to children under age 13, see the <a
         * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * </p>
         * 
         * @param childDirected
         *        For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether
         *        your use of Amazon Lex is related to a website, program, or other application that is directed or
         *        targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy
         *        Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the
         *        <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code>
         *        field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other
         *        application that is directed or targeted, in whole or in part, to children under age 13 and subject to
         *        COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
         *        use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed
         *        or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a
         *        default value for the <code>childDirected</code> field that does not accurately reflect whether your
         *        use of Amazon Lex is related to a website, program, or other application that is directed or targeted,
         *        in whole or in part, to children under age 13 and subject to COPPA.</p>
         *        <p>
         *        If your use of Amazon Lex relates to a website, program, or other application that is directed in
         *        whole or in part, to children under age 13, you must obtain any required verifiable parental consent
         *        under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or
         *        other applications that are directed or targeted, in whole or in part, to children under age 13, see
         *        the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childDirected(Boolean childDirected);

        /**
         * <p>
         * <code>True</code> if a new version of the bot was created. If the <code>createVersion</code> field was not
         * specified in the request, the <code>createVersion</code> field is set to false in the response.
         * </p>
         * 
         * @param createVersion
         *        <code>True</code> if a new version of the bot was created. If the <code>createVersion</code> field was
         *        not specified in the request, the <code>createVersion</code> field is set to false in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVersion(Boolean createVersion);

        /**
         * <p>
         * <code>true</code> if the bot is configured to send user utterances to Amazon Comprehend for sentiment
         * analysis. If the <code>detectSentiment</code> field was not specified in the request, the
         * <code>detectSentiment</code> field is <code>false</code> in the response.
         * </p>
         * 
         * @param detectSentiment
         *        <code>true</code> if the bot is configured to send user utterances to Amazon Comprehend for sentiment
         *        analysis. If the <code>detectSentiment</code> field was not specified in the request, the
         *        <code>detectSentiment</code> field is <code>false</code> in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectSentiment(Boolean detectSentiment);

        /**
         * <p>
         * A list of tags associated with the bot.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with the bot.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags associated with the bot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Intent> intents = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableModelImprovements;

        private Double nluIntentConfidenceThreshold;

        private Prompt clarificationPrompt;

        private Statement abortStatement;

        private String status;

        private String failureReason;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private Integer idleSessionTTLInSeconds;

        private String voiceId;

        private String checksum;

        private String version;

        private String locale;

        private Boolean childDirected;

        private Boolean createVersion;

        private Boolean detectSentiment;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            intents(model.intents);
            enableModelImprovements(model.enableModelImprovements);
            nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            clarificationPrompt(model.clarificationPrompt);
            abortStatement(model.abortStatement);
            status(model.status);
            failureReason(model.failureReason);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            voiceId(model.voiceId);
            checksum(model.checksum);
            version(model.version);
            locale(model.locale);
            childDirected(model.childDirected);
            createVersion(model.createVersion);
            detectSentiment(model.detectSentiment);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Intent.Builder> getIntents() {
            List<Intent.Builder> result = IntentListCopier.copyToBuilder(this.intents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntents(Collection<Intent.BuilderImpl> intents) {
            this.intents = IntentListCopier.copyFromBuilder(intents);
        }

        @Override
        @Transient
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder intents(Intent... intents) {
            intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder intents(Consumer<Intent.Builder>... intents) {
            intents(Stream.of(intents).map(c -> Intent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableModelImprovements() {
            return enableModelImprovements;
        }

        public final void setEnableModelImprovements(Boolean enableModelImprovements) {
            this.enableModelImprovements = enableModelImprovements;
        }

        @Override
        @Transient
        public final Builder enableModelImprovements(Boolean enableModelImprovements) {
            this.enableModelImprovements = enableModelImprovements;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        @Transient
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final Prompt.Builder getClarificationPrompt() {
            return clarificationPrompt != null ? clarificationPrompt.toBuilder() : null;
        }

        public final void setClarificationPrompt(Prompt.BuilderImpl clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt != null ? clarificationPrompt.build() : null;
        }

        @Override
        @Transient
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final Statement.Builder getAbortStatement() {
            return abortStatement != null ? abortStatement.toBuilder() : null;
        }

        public final void setAbortStatement(Statement.BuilderImpl abortStatement) {
            this.abortStatement = abortStatement != null ? abortStatement.build() : null;
        }

        @Override
        @Transient
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        @Transient
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        @Transient
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        @Transient
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        @Transient
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        @Transient
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        @Transient
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final Boolean getChildDirected() {
            return childDirected;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        @Override
        @Transient
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final Boolean getCreateVersion() {
            return createVersion;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        @Transient
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final Boolean getDetectSentiment() {
            return detectSentiment;
        }

        public final void setDetectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
        }

        @Override
        @Transient
        public final Builder detectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutBotResponse build() {
            return new PutBotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
