/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.Intent;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.ProcessBehavior;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.services.lexmodelbuilding.model.Tag;
import software.amazon.awssdk.services.lexmodelbuilding.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutBotRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, PutBotRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PutBotRequest.getter(PutBotRequest::name)).setter(PutBotRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PutBotRequest.getter(PutBotRequest::description)).setter(PutBotRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Intent>> INTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("intents").getter(PutBotRequest.getter(PutBotRequest::intents)).setter(PutBotRequest.setter(Builder::intents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Intent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_MODEL_IMPROVEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableModelImprovements").getter(PutBotRequest.getter(PutBotRequest::enableModelImprovements)).setter(PutBotRequest.setter(Builder::enableModelImprovements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableModelImprovements").build()}).build();
    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("nluIntentConfidenceThreshold").getter(PutBotRequest.getter(PutBotRequest::nluIntentConfidenceThreshold)).setter(PutBotRequest.setter(Builder::nluIntentConfidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold").build()}).build();
    private static final SdkField<Prompt> CLARIFICATION_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clarificationPrompt").getter(PutBotRequest.getter(PutBotRequest::clarificationPrompt)).setter(PutBotRequest.setter(Builder::clarificationPrompt)).constructor(Prompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clarificationPrompt").build()}).build();
    private static final SdkField<Statement> ABORT_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("abortStatement").getter(PutBotRequest.getter(PutBotRequest::abortStatement)).setter(PutBotRequest.setter(Builder::abortStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortStatement").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(PutBotRequest.getter(PutBotRequest::idleSessionTTLInSeconds)).setter(PutBotRequest.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("voiceId").getter(PutBotRequest.getter(PutBotRequest::voiceId)).setter(PutBotRequest.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceId").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checksum").getter(PutBotRequest.getter(PutBotRequest::checksum)).setter(PutBotRequest.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<String> PROCESS_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processBehavior").getter(PutBotRequest.getter(PutBotRequest::processBehaviorAsString)).setter(PutBotRequest.setter(Builder::processBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processBehavior").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(PutBotRequest.getter(PutBotRequest::localeAsString)).setter(PutBotRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<Boolean> CHILD_DIRECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("childDirected").getter(PutBotRequest.getter(PutBotRequest::childDirected)).setter(PutBotRequest.setter(Builder::childDirected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childDirected").build()}).build();
    private static final SdkField<Boolean> DETECT_SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("detectSentiment").getter(PutBotRequest.getter(PutBotRequest::detectSentiment)).setter(PutBotRequest.setter(Builder::detectSentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectSentiment").build()}).build();
    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createVersion").getter(PutBotRequest.getter(PutBotRequest::createVersion)).setter(PutBotRequest.setter(Builder::createVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(PutBotRequest.getter(PutBotRequest::tags)).setter(PutBotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, INTENTS_FIELD, ENABLE_MODEL_IMPROVEMENTS_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, CLARIFICATION_PROMPT_FIELD, ABORT_STATEMENT_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, VOICE_ID_FIELD, CHECKSUM_FIELD, PROCESS_BEHAVIOR_FIELD, LOCALE_FIELD, CHILD_DIRECTED_FIELD, DETECT_SENTIMENT_FIELD, CREATE_VERSION_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final List<Intent> intents;
    private final Boolean enableModelImprovements;
    private final Double nluIntentConfidenceThreshold;
    private final Prompt clarificationPrompt;
    private final Statement abortStatement;
    private final Integer idleSessionTTLInSeconds;
    private final String voiceId;
    private final String checksum;
    private final String processBehavior;
    private final String locale;
    private final Boolean childDirected;
    private final Boolean detectSentiment;
    private final Boolean createVersion;
    private final List<Tag> tags;

    private PutBotRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.enableModelImprovements = builder.enableModelImprovements;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.processBehavior = builder.processBehavior;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
        this.detectSentiment = builder.detectSentiment;
        this.createVersion = builder.createVersion;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasIntents() {
        return this.intents != null && !(this.intents instanceof SdkAutoConstructList);
    }

    public final List<Intent> intents() {
        return this.intents;
    }

    public final Boolean enableModelImprovements() {
        return this.enableModelImprovements;
    }

    public final Double nluIntentConfidenceThreshold() {
        return this.nluIntentConfidenceThreshold;
    }

    public final Prompt clarificationPrompt() {
        return this.clarificationPrompt;
    }

    public final Statement abortStatement() {
        return this.abortStatement;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final String voiceId() {
        return this.voiceId;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final ProcessBehavior processBehavior() {
        return ProcessBehavior.fromValue(this.processBehavior);
    }

    public final String processBehaviorAsString() {
        return this.processBehavior;
    }

    public final Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    public final Boolean childDirected() {
        return this.childDirected;
    }

    public final Boolean detectSentiment() {
        return this.detectSentiment;
    }

    public final Boolean createVersion() {
        return this.createVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntents() ? this.intents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableModelImprovements());
        hashCode = 31 * hashCode + Objects.hashCode(this.nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.clarificationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.processBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.childDirected());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectSentiment());
        hashCode = 31 * hashCode + Objects.hashCode(this.createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotRequest)) {
            return false;
        }
        PutBotRequest other = (PutBotRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasIntents() == other.hasIntents() && Objects.equals(this.intents(), other.intents()) && Objects.equals(this.enableModelImprovements(), other.enableModelImprovements()) && Objects.equals(this.nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold()) && Objects.equals(this.clarificationPrompt(), other.clarificationPrompt()) && Objects.equals(this.abortStatement(), other.abortStatement()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.voiceId(), other.voiceId()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.processBehaviorAsString(), other.processBehaviorAsString()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.childDirected(), other.childDirected()) && Objects.equals(this.detectSentiment(), other.detectSentiment()) && Objects.equals(this.createVersion(), other.createVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutBotRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Intents", this.hasIntents() ? this.intents() : null).add("EnableModelImprovements", (Object)this.enableModelImprovements()).add("NluIntentConfidenceThreshold", (Object)this.nluIntentConfidenceThreshold()).add("ClarificationPrompt", (Object)this.clarificationPrompt()).add("AbortStatement", (Object)this.abortStatement()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("VoiceId", (Object)this.voiceId()).add("Checksum", (Object)this.checksum()).add("ProcessBehavior", (Object)this.processBehaviorAsString()).add("Locale", (Object)this.localeAsString()).add("ChildDirected", (Object)this.childDirected()).add("DetectSentiment", (Object)this.detectSentiment()).add("CreateVersion", (Object)this.createVersion()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "intents": {
                return Optional.ofNullable(clazz.cast(this.intents()));
            }
            case "enableModelImprovements": {
                return Optional.ofNullable(clazz.cast(this.enableModelImprovements()));
            }
            case "nluIntentConfidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.nluIntentConfidenceThreshold()));
            }
            case "clarificationPrompt": {
                return Optional.ofNullable(clazz.cast(this.clarificationPrompt()));
            }
            case "abortStatement": {
                return Optional.ofNullable(clazz.cast(this.abortStatement()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "voiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceId()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "processBehavior": {
                return Optional.ofNullable(clazz.cast(this.processBehaviorAsString()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "childDirected": {
                return Optional.ofNullable(clazz.cast(this.childDirected()));
            }
            case "detectSentiment": {
                return Optional.ofNullable(clazz.cast(this.detectSentiment()));
            }
            case "createVersion": {
                return Optional.ofNullable(clazz.cast(this.createVersion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBotRequest, T> g) {
        return obj -> g.apply((PutBotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Intent> intents = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableModelImprovements;
        private Double nluIntentConfidenceThreshold;
        private Prompt clarificationPrompt;
        private Statement abortStatement;
        private Integer idleSessionTTLInSeconds;
        private String voiceId;
        private String checksum;
        private String processBehavior;
        private String locale;
        private Boolean childDirected;
        private Boolean detectSentiment;
        private Boolean createVersion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.intents(model.intents);
            this.enableModelImprovements(model.enableModelImprovements);
            this.nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            this.clarificationPrompt(model.clarificationPrompt);
            this.abortStatement(model.abortStatement);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.voiceId(model.voiceId);
            this.checksum(model.checksum);
            this.processBehavior(model.processBehavior);
            this.locale(model.locale);
            this.childDirected(model.childDirected);
            this.detectSentiment(model.detectSentiment);
            this.createVersion(model.createVersion);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Intent.Builder> getIntents() {
            List<Intent.Builder> result = IntentListCopier.copyToBuilder(this.intents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntents(Collection<Intent.BuilderImpl> intents) {
            this.intents = IntentListCopier.copyFromBuilder(intents);
        }

        @Override
        @Transient
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder intents(Intent ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder intents(Consumer<Intent.Builder> ... intents) {
            this.intents(Stream.of(intents).map(c -> (Intent)((Intent.Builder)Intent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableModelImprovements() {
            return this.enableModelImprovements;
        }

        public final void setEnableModelImprovements(Boolean enableModelImprovements) {
            this.enableModelImprovements = enableModelImprovements;
        }

        @Override
        @Transient
        public final Builder enableModelImprovements(Boolean enableModelImprovements) {
            this.enableModelImprovements = enableModelImprovements;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return this.nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        @Transient
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final Prompt.Builder getClarificationPrompt() {
            return this.clarificationPrompt != null ? this.clarificationPrompt.toBuilder() : null;
        }

        public final void setClarificationPrompt(Prompt.BuilderImpl clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt != null ? clarificationPrompt.build() : null;
        }

        @Override
        @Transient
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final Statement.Builder getAbortStatement() {
            return this.abortStatement != null ? this.abortStatement.toBuilder() : null;
        }

        public final void setAbortStatement(Statement.BuilderImpl abortStatement) {
            this.abortStatement = abortStatement != null ? abortStatement.build() : null;
        }

        @Override
        @Transient
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        @Transient
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        @Transient
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        @Transient
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getProcessBehavior() {
            return this.processBehavior;
        }

        public final void setProcessBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
        }

        @Override
        @Transient
        public final Builder processBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder processBehavior(ProcessBehavior processBehavior) {
            this.processBehavior(processBehavior == null ? null : processBehavior.toString());
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        @Transient
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        @Transient
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final Boolean getChildDirected() {
            return this.childDirected;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        @Override
        @Transient
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final Boolean getDetectSentiment() {
            return this.detectSentiment;
        }

        public final void setDetectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
        }

        @Override
        @Transient
        public final Builder detectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
            return this;
        }

        public final Boolean getCreateVersion() {
            return this.createVersion;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        @Transient
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBotRequest build() {
            return new PutBotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutBotRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder intents(Collection<Intent> var1);

        public Builder intents(Intent ... var1);

        public Builder intents(Consumer<Intent.Builder> ... var1);

        public Builder enableModelImprovements(Boolean var1);

        public Builder nluIntentConfidenceThreshold(Double var1);

        public Builder clarificationPrompt(Prompt var1);

        default public Builder clarificationPrompt(Consumer<Prompt.Builder> clarificationPrompt) {
            return this.clarificationPrompt((Prompt)((Prompt.Builder)Prompt.builder().applyMutation(clarificationPrompt)).build());
        }

        public Builder abortStatement(Statement var1);

        default public Builder abortStatement(Consumer<Statement.Builder> abortStatement) {
            return this.abortStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(abortStatement)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder voiceId(String var1);

        public Builder checksum(String var1);

        public Builder processBehavior(String var1);

        public Builder processBehavior(ProcessBehavior var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder childDirected(Boolean var1);

        public Builder detectSentiment(Boolean var1);

        public Builder createVersion(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

