/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specification of an output context that is set when an intent is fulfilled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputContext implements SdkPojo, Serializable, ToCopyableBuilder<OutputContext.Builder, OutputContext> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(OutputContext::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeToLiveInSeconds").getter(getter(OutputContext::timeToLiveInSeconds))
            .setter(setter(Builder::timeToLiveInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeToLiveInSeconds").build())
            .build();

    private static final SdkField<Integer> TURNS_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("turnsToLive").getter(getter(OutputContext::turnsToLive)).setter(setter(Builder::turnsToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("turnsToLive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TIME_TO_LIVE_IN_SECONDS_FIELD, TURNS_TO_LIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer timeToLiveInSeconds;

    private final Integer turnsToLive;

    private OutputContext(BuilderImpl builder) {
        this.name = builder.name;
        this.timeToLiveInSeconds = builder.timeToLiveInSeconds;
        this.turnsToLive = builder.turnsToLive;
    }

    /**
     * <p>
     * The name of the context.
     * </p>
     * 
     * @return The name of the context.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of seconds that the context should be active after it is first sent in a <code>PostContent</code> or
     * <code>PostText</code> response. You can set the value between 5 and 86,400 seconds (24 hours).
     * </p>
     * 
     * @return The number of seconds that the context should be active after it is first sent in a
     *         <code>PostContent</code> or <code>PostText</code> response. You can set the value between 5 and 86,400
     *         seconds (24 hours).
     */
    public final Integer timeToLiveInSeconds() {
        return timeToLiveInSeconds;
    }

    /**
     * <p>
     * The number of conversation turns that the context should be active. A conversation turn is one
     * <code>PostContent</code> or <code>PostText</code> request and the corresponding response from Amazon Lex.
     * </p>
     * 
     * @return The number of conversation turns that the context should be active. A conversation turn is one
     *         <code>PostContent</code> or <code>PostText</code> request and the corresponding response from Amazon Lex.
     */
    public final Integer turnsToLive() {
        return turnsToLive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(turnsToLive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputContext)) {
            return false;
        }
        OutputContext other = (OutputContext) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(timeToLiveInSeconds(), other.timeToLiveInSeconds())
                && Objects.equals(turnsToLive(), other.turnsToLive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputContext").add("Name", name()).add("TimeToLiveInSeconds", timeToLiveInSeconds())
                .add("TurnsToLive", turnsToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "timeToLiveInSeconds":
            return Optional.ofNullable(clazz.cast(timeToLiveInSeconds()));
        case "turnsToLive":
            return Optional.ofNullable(clazz.cast(turnsToLive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputContext, T> g) {
        return obj -> g.apply((OutputContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputContext> {
        /**
         * <p>
         * The name of the context.
         * </p>
         * 
         * @param name
         *        The name of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of seconds that the context should be active after it is first sent in a <code>PostContent</code>
         * or <code>PostText</code> response. You can set the value between 5 and 86,400 seconds (24 hours).
         * </p>
         * 
         * @param timeToLiveInSeconds
         *        The number of seconds that the context should be active after it is first sent in a
         *        <code>PostContent</code> or <code>PostText</code> response. You can set the value between 5 and 86,400
         *        seconds (24 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveInSeconds(Integer timeToLiveInSeconds);

        /**
         * <p>
         * The number of conversation turns that the context should be active. A conversation turn is one
         * <code>PostContent</code> or <code>PostText</code> request and the corresponding response from Amazon Lex.
         * </p>
         * 
         * @param turnsToLive
         *        The number of conversation turns that the context should be active. A conversation turn is one
         *        <code>PostContent</code> or <code>PostText</code> request and the corresponding response from Amazon
         *        Lex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnsToLive(Integer turnsToLive);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer timeToLiveInSeconds;

        private Integer turnsToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputContext model) {
            name(model.name);
            timeToLiveInSeconds(model.timeToLiveInSeconds);
            turnsToLive(model.turnsToLive);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getTimeToLiveInSeconds() {
            return timeToLiveInSeconds;
        }

        public final void setTimeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
        }

        @Override
        @Transient
        public final Builder timeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
            return this;
        }

        public final Integer getTurnsToLive() {
            return turnsToLive;
        }

        public final void setTurnsToLive(Integer turnsToLive) {
            this.turnsToLive = turnsToLive;
        }

        @Override
        @Transient
        public final Builder turnsToLive(Integer turnsToLive) {
            this.turnsToLive = turnsToLive;
            return this;
        }

        @Override
        public OutputContext build() {
            return new OutputContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
