/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class InputContextListCopier {
    static List<InputContext> copy(Collection<? extends InputContext> inputContextListParam) {
        List<InputContext> list;
        if (inputContextListParam == null || inputContextListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InputContext> modifiableList = new ArrayList<>();
            inputContextListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InputContext> copyFromBuilder(Collection<? extends InputContext.Builder> inputContextListParam) {
        List<InputContext> list;
        if (inputContextListParam == null || inputContextListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InputContext> modifiableList = new ArrayList<>();
            inputContextListParam.forEach(entry -> {
                InputContext member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InputContext.Builder> copyToBuilder(Collection<? extends InputContext> inputContextListParam) {
        List<InputContext.Builder> list;
        if (inputContextListParam == null || inputContextListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InputContext.Builder> modifiableList = new ArrayList<>();
            inputContextListParam.forEach(entry -> {
                InputContext.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
