/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for conversation logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogSettingsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<LogSettingsResponse.Builder, LogSettingsResponse> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logType").getter(getter(LogSettingsResponse::logTypeAsString)).setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logType").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(LogSettingsResponse::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(LogSettingsResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(LogSettingsResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> RESOURCE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourcePrefix").getter(getter(LogSettingsResponse::resourcePrefix))
            .setter(setter(Builder::resourcePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD,
            DESTINATION_FIELD, KMS_KEY_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logType;

    private final String destination;

    private final String kmsKeyArn;

    private final String resourceArn;

    private final String resourcePrefix;

    private LogSettingsResponse(BuilderImpl builder) {
        this.logType = builder.logType;
        this.destination = builder.destination;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.resourceArn = builder.resourceArn;
        this.resourcePrefix = builder.resourcePrefix;
    }

    /**
     * <p>
     * The type of logging that is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return The type of logging that is enabled.
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * The type of logging that is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return The type of logging that is enabled.
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * The destination where logs are delivered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link Destination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The destination where logs are delivered.
     * @see Destination
     */
    public final Destination destination() {
        return Destination.fromValue(destination);
    }

    /**
     * <p>
     * The destination where logs are delivered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link Destination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The destination where logs are delivered.
     * @see Destination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are delivered.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are
     *         delivered.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The resource prefix is the first part of the S3 object key within the S3 bucket that you specified to contain
     * audio logs. For CloudWatch Logs it is the prefix of the log stream name within the log group that you specified.
     * </p>
     * 
     * @return The resource prefix is the first part of the S3 object key within the S3 bucket that you specified to
     *         contain audio logs. For CloudWatch Logs it is the prefix of the log stream name within the log group that
     *         you specified.
     */
    public final String resourcePrefix() {
        return resourcePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSettingsResponse)) {
            return false;
        }
        LogSettingsResponse other = (LogSettingsResponse) obj;
        return Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourcePrefix(), other.resourcePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogSettingsResponse").add("LogType", logTypeAsString())
                .add("Destination", destinationAsString()).add("KmsKeyArn", kmsKeyArn()).add("ResourceArn", resourceArn())
                .add("ResourcePrefix", resourcePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "resourcePrefix":
            return Optional.ofNullable(clazz.cast(resourcePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogSettingsResponse, T> g) {
        return obj -> g.apply((LogSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogSettingsResponse> {
        /**
         * <p>
         * The type of logging that is enabled.
         * </p>
         * 
         * @param logType
         *        The type of logging that is enabled.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * The type of logging that is enabled.
         * </p>
         * 
         * @param logType
         *        The type of logging that is enabled.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * The destination where logs are delivered.
         * </p>
         * 
         * @param destination
         *        The destination where logs are delivered.
         * @see Destination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Destination
         */
        Builder destination(String destination);

        /**
         * <p>
         * The destination where logs are delivered.
         * </p>
         * 
         * @param destination
         *        The destination where logs are delivered.
         * @see Destination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Destination
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are delivered.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are
         *        delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The resource prefix is the first part of the S3 object key within the S3 bucket that you specified to contain
         * audio logs. For CloudWatch Logs it is the prefix of the log stream name within the log group that you
         * specified.
         * </p>
         * 
         * @param resourcePrefix
         *        The resource prefix is the first part of the S3 object key within the S3 bucket that you specified to
         *        contain audio logs. For CloudWatch Logs it is the prefix of the log stream name within the log group
         *        that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePrefix(String resourcePrefix);
    }

    static final class BuilderImpl implements Builder {
        private String logType;

        private String destination;

        private String kmsKeyArn;

        private String resourceArn;

        private String resourcePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(LogSettingsResponse model) {
            logType(model.logType);
            destination(model.destination);
            kmsKeyArn(model.kmsKeyArn);
            resourceArn(model.resourceArn);
            resourcePrefix(model.resourcePrefix);
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        @Transient
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        @Transient
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        @Transient
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        @Transient
        public final Builder destination(Destination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourcePrefix() {
            return resourcePrefix;
        }

        public final void setResourcePrefix(String resourcePrefix) {
            this.resourcePrefix = resourcePrefix;
        }

        @Override
        @Transient
        public final Builder resourcePrefix(String resourcePrefix) {
            this.resourcePrefix = resourcePrefix;
            return this;
        }

        @Override
        public LogSettingsResponse build() {
            return new LogSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
