/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMigrationRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<StartMigrationRequest.Builder, StartMigrationRequest> {
    private static final SdkField<String> V1_BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotName").getter(getter(StartMigrationRequest::v1BotName)).setter(setter(Builder::v1BotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotName").build()).build();

    private static final SdkField<String> V1_BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotVersion").getter(getter(StartMigrationRequest::v1BotVersion)).setter(setter(Builder::v1BotVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotVersion").build()).build();

    private static final SdkField<String> V2_BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v2BotName").getter(getter(StartMigrationRequest::v2BotName)).setter(setter(Builder::v2BotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotName").build()).build();

    private static final SdkField<String> V2_BOT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v2BotRole").getter(getter(StartMigrationRequest::v2BotRole)).setter(setter(Builder::v2BotRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotRole").build()).build();

    private static final SdkField<String> MIGRATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("migrationStrategy").getter(getter(StartMigrationRequest::migrationStrategyAsString))
            .setter(setter(Builder::migrationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V1_BOT_NAME_FIELD,
            V1_BOT_VERSION_FIELD, V2_BOT_NAME_FIELD, V2_BOT_ROLE_FIELD, MIGRATION_STRATEGY_FIELD));

    private final String v1BotName;

    private final String v1BotVersion;

    private final String v2BotName;

    private final String v2BotRole;

    private final String migrationStrategy;

    private StartMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.v1BotName = builder.v1BotName;
        this.v1BotVersion = builder.v1BotVersion;
        this.v2BotName = builder.v2BotName;
        this.v2BotRole = builder.v2BotRole;
        this.migrationStrategy = builder.migrationStrategy;
    }

    /**
     * <p>
     * The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
     * </p>
     * 
     * @return The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
     */
    public final String v1BotName() {
        return v1BotName;
    }

    /**
     * <p>
     * The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version as well as
     * any numbered version.
     * </p>
     * 
     * @return The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version as
     *         well as any numbered version.
     */
    public final String v1BotVersion() {
        return v1BotVersion;
    }

    /**
     * <p>
     * The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the Amazon Lex V2 bot doesn't exist, you must use the <code>CREATE_NEW</code> migration strategy.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to change the
     * contents of the Amazon Lex V2 bot.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the Amazon Lex V2 bot doesn't exist, you must use the <code>CREATE_NEW</code> migration strategy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to
     *         change the contents of the Amazon Lex V2 bot.
     *         </p>
     *         </li>
     */
    public final String v2BotName() {
        return v2BotName;
    }

    /**
     * <p>
     * The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
     * </p>
     * 
     * @return The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
     */
    public final String v2BotRole() {
        return v2BotRole;
    }

    /**
     * <p>
     * The strategy used to conduct the migration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated.
     * It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is
     * created in the Amazon Lex V2 bot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStrategy}
     * will return {@link MigrationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to conduct the migration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new
     *         bot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
     *         migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
     *         new locale is created in the Amazon Lex V2 bot.
     *         </p>
     *         </li>
     * @see MigrationStrategy
     */
    public final MigrationStrategy migrationStrategy() {
        return MigrationStrategy.fromValue(migrationStrategy);
    }

    /**
     * <p>
     * The strategy used to conduct the migration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated.
     * It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is
     * created in the Amazon Lex V2 bot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStrategy}
     * will return {@link MigrationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to conduct the migration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new
     *         bot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
     *         migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
     *         new locale is created in the Amazon Lex V2 bot.
     *         </p>
     *         </li>
     * @see MigrationStrategy
     */
    public final String migrationStrategyAsString() {
        return migrationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(v1BotName());
        hashCode = 31 * hashCode + Objects.hashCode(v1BotVersion());
        hashCode = 31 * hashCode + Objects.hashCode(v2BotName());
        hashCode = 31 * hashCode + Objects.hashCode(v2BotRole());
        hashCode = 31 * hashCode + Objects.hashCode(migrationStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMigrationRequest)) {
            return false;
        }
        StartMigrationRequest other = (StartMigrationRequest) obj;
        return Objects.equals(v1BotName(), other.v1BotName()) && Objects.equals(v1BotVersion(), other.v1BotVersion())
                && Objects.equals(v2BotName(), other.v2BotName()) && Objects.equals(v2BotRole(), other.v2BotRole())
                && Objects.equals(migrationStrategyAsString(), other.migrationStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMigrationRequest").add("V1BotName", v1BotName()).add("V1BotVersion", v1BotVersion())
                .add("V2BotName", v2BotName()).add("V2BotRole", v2BotRole())
                .add("MigrationStrategy", migrationStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "v1BotName":
            return Optional.ofNullable(clazz.cast(v1BotName()));
        case "v1BotVersion":
            return Optional.ofNullable(clazz.cast(v1BotVersion()));
        case "v2BotName":
            return Optional.ofNullable(clazz.cast(v2BotName()));
        case "v2BotRole":
            return Optional.ofNullable(clazz.cast(v2BotRole()));
        case "migrationStrategy":
            return Optional.ofNullable(clazz.cast(migrationStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMigrationRequest, T> g) {
        return obj -> g.apply((StartMigrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMigrationRequest> {
        /**
         * <p>
         * The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
         * </p>
         * 
         * @param v1BotName
         *        The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1BotName(String v1BotName);

        /**
         * <p>
         * The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version as well
         * as any numbered version.
         * </p>
         * 
         * @param v1BotVersion
         *        The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version
         *        as well as any numbered version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1BotVersion(String v1BotVersion);

        /**
         * <p>
         * The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the Amazon Lex V2 bot doesn't exist, you must use the <code>CREATE_NEW</code> migration strategy.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to change
         * the contents of the Amazon Lex V2 bot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param v2BotName
         *        The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the Amazon Lex V2 bot doesn't exist, you must use the <code>CREATE_NEW</code> migration strategy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to
         *        change the contents of the Amazon Lex V2 bot.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v2BotName(String v2BotName);

        /**
         * <p>
         * The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
         * </p>
         * 
         * @param v2BotRole
         *        The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v2BotRole(String v2BotRole);

        /**
         * <p>
         * The strategy used to conduct the migration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         * migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new
         * locale is created in the Amazon Lex V2 bot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param migrationStrategy
         *        The strategy used to conduct the migration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the
         *        new bot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         *        migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
         *        new locale is created in the Amazon Lex V2 bot.
         *        </p>
         *        </li>
         * @see MigrationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStrategy
         */
        Builder migrationStrategy(String migrationStrategy);

        /**
         * <p>
         * The strategy used to conduct the migration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         * migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new
         * locale is created in the Amazon Lex V2 bot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param migrationStrategy
         *        The strategy used to conduct the migration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the
         *        new bot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         *        migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
         *        new locale is created in the Amazon Lex V2 bot.
         *        </p>
         *        </li>
         * @see MigrationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStrategy
         */
        Builder migrationStrategy(MigrationStrategy migrationStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String v1BotName;

        private String v1BotVersion;

        private String v2BotName;

        private String v2BotRole;

        private String migrationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMigrationRequest model) {
            super(model);
            v1BotName(model.v1BotName);
            v1BotVersion(model.v1BotVersion);
            v2BotName(model.v2BotName);
            v2BotRole(model.v2BotRole);
            migrationStrategy(model.migrationStrategy);
        }

        public final String getV1BotName() {
            return v1BotName;
        }

        public final void setV1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
        }

        @Override
        @Transient
        public final Builder v1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
            return this;
        }

        public final String getV1BotVersion() {
            return v1BotVersion;
        }

        public final void setV1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
        }

        @Override
        @Transient
        public final Builder v1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
            return this;
        }

        public final String getV2BotName() {
            return v2BotName;
        }

        public final void setV2BotName(String v2BotName) {
            this.v2BotName = v2BotName;
        }

        @Override
        @Transient
        public final Builder v2BotName(String v2BotName) {
            this.v2BotName = v2BotName;
            return this;
        }

        public final String getV2BotRole() {
            return v2BotRole;
        }

        public final void setV2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
        }

        @Override
        @Transient
        public final Builder v2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
            return this;
        }

        public final String getMigrationStrategy() {
            return migrationStrategy;
        }

        public final void setMigrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
        }

        @Override
        @Transient
        public final Builder migrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder migrationStrategy(MigrationStrategy migrationStrategy) {
            this.migrationStrategy(migrationStrategy == null ? null : migrationStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMigrationRequest build() {
            return new StartMigrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
