/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBotVersionsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotVersionsResponse.Builder, GetBotVersionsResponse> {
    private static final SdkField<List<BotMetadata>> BOTS_FIELD = SdkField
            .<List<BotMetadata>> builder(MarshallingType.LIST)
            .memberName("bots")
            .getter(getter(GetBotVersionsResponse::bots))
            .setter(setter(Builder::bots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetBotVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<BotMetadata> bots;

    private final String nextToken;

    private GetBotVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Bots property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasBots() {
        return bots != null && !(bots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
     * <code>$LATEST</code> version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBots} method.
     * </p>
     * 
     * @return An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
     *         <code>$LATEST</code> version.
     */
    public final List<BotMetadata> bots() {
        return bots;
    }

    /**
     * <p>
     * A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon
     * Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token
     * in the next request.
     * </p>
     * 
     * @return A pagination token for fetching the next page of bot versions. If the response to this call is truncated,
     *         Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the
     *         pagination token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBots() ? bots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotVersionsResponse)) {
            return false;
        }
        GetBotVersionsResponse other = (GetBotVersionsResponse) obj;
        return hasBots() == other.hasBots() && Objects.equals(bots(), other.bots())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBotVersionsResponse").add("Bots", hasBots() ? bots() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bots":
            return Optional.ofNullable(clazz.cast(bots()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotVersionsResponse, T> g) {
        return obj -> g.apply((GetBotVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBotVersionsResponse> {
        /**
         * <p>
         * An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
         * <code>$LATEST</code> version.
         * </p>
         * 
         * @param bots
         *        An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for
         *        the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(Collection<BotMetadata> bots);

        /**
         * <p>
         * An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
         * <code>$LATEST</code> version.
         * </p>
         * 
         * @param bots
         *        An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for
         *        the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(BotMetadata... bots);

        /**
         * <p>
         * An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
         * <code>$LATEST</code> version.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BotMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<BotMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotMetadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #bots(List<BotMetadata>)}.
         * 
         * @param bots
         *        a consumer that will call methods on {@link List<BotMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bots(List<BotMetadata>)
         */
        Builder bots(Consumer<BotMetadata.Builder>... bots);

        /**
         * <p>
         * A pagination token for fetching the next page of bot versions. If the response to this call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching the next page of bot versions. If the response to this call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<BotMetadata> bots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotVersionsResponse model) {
            super(model);
            bots(model.bots);
            nextToken(model.nextToken);
        }

        public final List<BotMetadata.Builder> getBots() {
            List<BotMetadata.Builder> result = BotMetadataListCopier.copyToBuilder(this.bots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBots(Collection<BotMetadata.BuilderImpl> bots) {
            this.bots = BotMetadataListCopier.copyFromBuilder(bots);
        }

        @Override
        @Transient
        public final Builder bots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bots(BotMetadata... bots) {
            bots(Arrays.asList(bots));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bots(Consumer<BotMetadata.Builder>... bots) {
            bots(Stream.of(bots).map(c -> BotMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetBotVersionsResponse build() {
            return new GetBotVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
