/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBotChannelAssociationsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotChannelAssociationsResponse.Builder, GetBotChannelAssociationsResponse> {
    private static final SdkField<List<BotChannelAssociation>> BOT_CHANNEL_ASSOCIATIONS_FIELD = SdkField
            .<List<BotChannelAssociation>> builder(MarshallingType.LIST)
            .memberName("botChannelAssociations")
            .getter(getter(GetBotChannelAssociationsResponse::botChannelAssociations))
            .setter(setter(Builder::botChannelAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botChannelAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotChannelAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotChannelAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetBotChannelAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BOT_CHANNEL_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<BotChannelAssociation> botChannelAssociations;

    private final String nextToken;

    private GetBotChannelAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.botChannelAssociations = builder.botChannelAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BotChannelAssociations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBotChannelAssociations() {
        return botChannelAssociations != null && !(botChannelAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each association, that provides information about the Amazon Lex bot and its
     * association with the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBotChannelAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each association, that provides information about the Amazon Lex bot and its
     *         association with the channel.
     */
    public final List<BotChannelAssociation> botChannelAssociations() {
        return botChannelAssociations;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of associations. If the response to this call is truncated, Amazon
     * Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination
     * token in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of associations. If the response to this call is truncated,
     *         Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify
     *         the pagination token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBotChannelAssociations() ? botChannelAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationsResponse)) {
            return false;
        }
        GetBotChannelAssociationsResponse other = (GetBotChannelAssociationsResponse) obj;
        return hasBotChannelAssociations() == other.hasBotChannelAssociations()
                && Objects.equals(botChannelAssociations(), other.botChannelAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBotChannelAssociationsResponse")
                .add("BotChannelAssociations", hasBotChannelAssociations() ? botChannelAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botChannelAssociations":
            return Optional.ofNullable(clazz.cast(botChannelAssociations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotChannelAssociationsResponse, T> g) {
        return obj -> g.apply((GetBotChannelAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBotChannelAssociationsResponse> {
        /**
         * <p>
         * An array of objects, one for each association, that provides information about the Amazon Lex bot and its
         * association with the channel.
         * </p>
         * 
         * @param botChannelAssociations
         *        An array of objects, one for each association, that provides information about the Amazon Lex bot and
         *        its association with the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botChannelAssociations(Collection<BotChannelAssociation> botChannelAssociations);

        /**
         * <p>
         * An array of objects, one for each association, that provides information about the Amazon Lex bot and its
         * association with the channel.
         * </p>
         * 
         * @param botChannelAssociations
         *        An array of objects, one for each association, that provides information about the Amazon Lex bot and
         *        its association with the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botChannelAssociations(BotChannelAssociation... botChannelAssociations);

        /**
         * <p>
         * An array of objects, one for each association, that provides information about the Amazon Lex bot and its
         * association with the channel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotChannelAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<BotChannelAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotChannelAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #botChannelAssociations(List<BotChannelAssociation>)}.
         * 
         * @param botChannelAssociations
         *        a consumer that will call methods on {@link List<BotChannelAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botChannelAssociations(List<BotChannelAssociation>)
         */
        Builder botChannelAssociations(Consumer<BotChannelAssociation.Builder>... botChannelAssociations);

        /**
         * <p>
         * A pagination token that fetches the next page of associations. If the response to this call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of associations. If the response to this call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of
         *        associations, specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<BotChannelAssociation> botChannelAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationsResponse model) {
            super(model);
            botChannelAssociations(model.botChannelAssociations);
            nextToken(model.nextToken);
        }

        public final List<BotChannelAssociation.Builder> getBotChannelAssociations() {
            List<BotChannelAssociation.Builder> result = BotChannelAssociationListCopier
                    .copyToBuilder(this.botChannelAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotChannelAssociations(Collection<BotChannelAssociation.BuilderImpl> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copyFromBuilder(botChannelAssociations);
        }

        @Override
        @Transient
        public final Builder botChannelAssociations(Collection<BotChannelAssociation> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copy(botChannelAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder botChannelAssociations(BotChannelAssociation... botChannelAssociations) {
            botChannelAssociations(Arrays.asList(botChannelAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder botChannelAssociations(Consumer<BotChannelAssociation.Builder>... botChannelAssociations) {
            botChannelAssociations(Stream.of(botChannelAssociations)
                    .map(c -> BotChannelAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetBotChannelAssociationsResponse build() {
            return new GetBotChannelAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
