/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Obtains information from the user. To define a prompt, provide one or more messages and specify the number of
 * attempts to get information from the user. If you provide more than one message, Amazon Lex chooses one of the
 * messages to use to prompt the user. For more information, see <a>how-it-works</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Prompt implements SdkPojo, Serializable, ToCopyableBuilder<Prompt.Builder, Prompt> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(Prompt::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxAttempts").getter(getter(Prompt::maxAttempts)).setter(setter(Builder::maxAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAttempts").build()).build();

    private static final SdkField<String> RESPONSE_CARD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseCard").getter(getter(Prompt::responseCard)).setter(setter(Builder::responseCard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseCard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD,
            MAX_ATTEMPTS_FIELD, RESPONSE_CARD_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Message> messages;

    private final Integer maxAttempts;

    private final String responseCard;

    private Prompt(BuilderImpl builder) {
        this.messages = builder.messages;
        this.maxAttempts = builder.maxAttempts;
        this.responseCard = builder.responseCard;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which provides a message string and its type. You can specify the message string in
     * plain text or in Speech Synthesis Markup Language (SSML).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return An array of objects, each of which provides a message string and its type. You can specify the message
     *         string in plain text or in Speech Synthesis Markup Language (SSML).
     */
    public final List<Message> messages() {
        return messages;
    }

    /**
     * <p>
     * The number of times to prompt the user for information.
     * </p>
     * 
     * @return The number of times to prompt the user for information.
     */
    public final Integer maxAttempts() {
        return maxAttempts;
    }

    /**
     * <p>
     * A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
     * substitutes session attributes and slot values for placeholders in the response card. For more information, see
     * <a>ex-resp-card</a>.
     * </p>
     * 
     * @return A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
     *         substitutes session attributes and slot values for placeholders in the response card. For more
     *         information, see <a>ex-resp-card</a>.
     */
    public final String responseCard() {
        return responseCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(responseCard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt other = (Prompt) obj;
        return hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && Objects.equals(maxAttempts(), other.maxAttempts()) && Objects.equals(responseCard(), other.responseCard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Prompt").add("Messages", hasMessages() ? messages() : null).add("MaxAttempts", maxAttempts())
                .add("ResponseCard", responseCard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "maxAttempts":
            return Optional.ofNullable(clazz.cast(maxAttempts()));
        case "responseCard":
            return Optional.ofNullable(clazz.cast(responseCard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Prompt, T> g) {
        return obj -> g.apply((Prompt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Prompt> {
        /**
         * <p>
         * An array of objects, each of which provides a message string and its type. You can specify the message string
         * in plain text or in Speech Synthesis Markup Language (SSML).
         * </p>
         * 
         * @param messages
         *        An array of objects, each of which provides a message string and its type. You can specify the message
         *        string in plain text or in Speech Synthesis Markup Language (SSML).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * An array of objects, each of which provides a message string and its type. You can specify the message string
         * in plain text or in Speech Synthesis Markup Language (SSML).
         * </p>
         * 
         * @param messages
         *        An array of objects, each of which provides a message string and its type. You can specify the message
         *        string in plain text or in Speech Synthesis Markup Language (SSML).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * An array of objects, each of which provides a message string and its type. You can specify the message string
         * in plain text or in Speech Synthesis Markup Language (SSML).
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Message>.Builder} avoiding the need
         * to create one manually via {@link List<Message>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Message>.Builder#build()} is called immediately and its
         * result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link List<Message>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(List<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        /**
         * <p>
         * The number of times to prompt the user for information.
         * </p>
         * 
         * @param maxAttempts
         *        The number of times to prompt the user for information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAttempts(Integer maxAttempts);

        /**
         * <p>
         * A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
         * substitutes session attributes and slot values for placeholders in the response card. For more information,
         * see <a>ex-resp-card</a>.
         * </p>
         * 
         * @param responseCard
         *        A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
         *        substitutes session attributes and slot values for placeholders in the response card. For more
         *        information, see <a>ex-resp-card</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCard(String responseCard);
    }

    static final class BuilderImpl implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private Integer maxAttempts;

        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Prompt model) {
            messages(model.messages);
            maxAttempts(model.maxAttempts);
            responseCard(model.responseCard);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessageListCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessageListCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxAttempts() {
            return maxAttempts;
        }

        public final void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        public final Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public final String getResponseCard() {
            return responseCard;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        @Override
        public Prompt build() {
            return new Prompt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
