/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMigrationResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetMigrationResponse.Builder, GetMigrationResponse> {
    private static final SdkField<String> MIGRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("migrationId").getter(getter(GetMigrationResponse::migrationId)).setter(setter(Builder::migrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationId").build()).build();

    private static final SdkField<String> V1_BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotName").getter(getter(GetMigrationResponse::v1BotName)).setter(setter(Builder::v1BotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotName").build()).build();

    private static final SdkField<String> V1_BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotVersion").getter(getter(GetMigrationResponse::v1BotVersion)).setter(setter(Builder::v1BotVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotVersion").build()).build();

    private static final SdkField<String> V1_BOT_LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotLocale").getter(getter(GetMigrationResponse::v1BotLocaleAsString))
            .setter(setter(Builder::v1BotLocale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotLocale").build()).build();

    private static final SdkField<String> V2_BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v2BotId").getter(getter(GetMigrationResponse::v2BotId)).setter(setter(Builder::v2BotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotId").build()).build();

    private static final SdkField<String> V2_BOT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v2BotRole").getter(getter(GetMigrationResponse::v2BotRole)).setter(setter(Builder::v2BotRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotRole").build()).build();

    private static final SdkField<String> MIGRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("migrationStatus").getter(getter(GetMigrationResponse::migrationStatusAsString))
            .setter(setter(Builder::migrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationStatus").build()).build();

    private static final SdkField<String> MIGRATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("migrationStrategy").getter(getter(GetMigrationResponse::migrationStrategyAsString))
            .setter(setter(Builder::migrationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationStrategy").build()).build();

    private static final SdkField<Instant> MIGRATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("migrationTimestamp").getter(getter(GetMigrationResponse::migrationTimestamp))
            .setter(setter(Builder::migrationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationTimestamp").build())
            .build();

    private static final SdkField<List<MigrationAlert>> ALERTS_FIELD = SdkField
            .<List<MigrationAlert>> builder(MarshallingType.LIST)
            .memberName("alerts")
            .getter(getter(GetMigrationResponse::alerts))
            .setter(setter(Builder::alerts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alerts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MigrationAlert> builder(MarshallingType.SDK_POJO)
                                            .constructor(MigrationAlert::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_ID_FIELD,
            V1_BOT_NAME_FIELD, V1_BOT_VERSION_FIELD, V1_BOT_LOCALE_FIELD, V2_BOT_ID_FIELD, V2_BOT_ROLE_FIELD,
            MIGRATION_STATUS_FIELD, MIGRATION_STRATEGY_FIELD, MIGRATION_TIMESTAMP_FIELD, ALERTS_FIELD));

    private final String migrationId;

    private final String v1BotName;

    private final String v1BotVersion;

    private final String v1BotLocale;

    private final String v2BotId;

    private final String v2BotRole;

    private final String migrationStatus;

    private final String migrationStrategy;

    private final Instant migrationTimestamp;

    private final List<MigrationAlert> alerts;

    private GetMigrationResponse(BuilderImpl builder) {
        super(builder);
        this.migrationId = builder.migrationId;
        this.v1BotName = builder.v1BotName;
        this.v1BotVersion = builder.v1BotVersion;
        this.v1BotLocale = builder.v1BotLocale;
        this.v2BotId = builder.v2BotId;
        this.v2BotRole = builder.v2BotRole;
        this.migrationStatus = builder.migrationStatus;
        this.migrationStrategy = builder.migrationStrategy;
        this.migrationTimestamp = builder.migrationTimestamp;
        this.alerts = builder.alerts;
    }

    /**
     * <p>
     * The unique identifier of the migration. This is the same as the identifier used when calling the
     * <code>GetMigration</code> operation.
     * </p>
     * 
     * @return The unique identifier of the migration. This is the same as the identifier used when calling the
     *         <code>GetMigration</code> operation.
     */
    public final String migrationId() {
        return migrationId;
    }

    /**
     * <p>
     * The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     * </p>
     * 
     * @return The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     */
    public final String v1BotName() {
        return v1BotName;
    }

    /**
     * <p>
     * The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     * </p>
     * 
     * @return The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     */
    public final String v1BotVersion() {
        return v1BotVersion;
    }

    /**
     * <p>
     * The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #v1BotLocale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #v1BotLocaleAsString}.
     * </p>
     * 
     * @return The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     * @see Locale
     */
    public final Locale v1BotLocale() {
        return Locale.fromValue(v1BotLocale);
    }

    /**
     * <p>
     * The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #v1BotLocale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #v1BotLocaleAsString}.
     * </p>
     * 
     * @return The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
     * @see Locale
     */
    public final String v1BotLocaleAsString() {
        return v1BotLocale;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being migrated to.
     * </p>
     * 
     * @return The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being migrated to.
     */
    public final String v2BotId() {
        return v2BotId;
    }

    /**
     * <p>
     * The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
     * </p>
     * 
     * @return The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
     */
    public final String v2BotRole() {
        return v2BotRole;
    }

    /**
     * <p>
     * Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished and the
     * bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to complete the
     * migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStatus}
     * will return {@link MigrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished
     *         and the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to
     *         complete the migration.
     * @see MigrationStatus
     */
    public final MigrationStatus migrationStatus() {
        return MigrationStatus.fromValue(migrationStatus);
    }

    /**
     * <p>
     * Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished and the
     * bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to complete the
     * migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStatus}
     * will return {@link MigrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished
     *         and the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to
     *         complete the migration.
     * @see MigrationStatus
     */
    public final String migrationStatusAsString() {
        return migrationStatus;
    }

    /**
     * <p>
     * The strategy used to conduct the migration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated.
     * It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is
     * created in the Amazon Lex V2 bot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStrategy}
     * will return {@link MigrationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to conduct the migration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new
     *         bot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
     *         migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
     *         new locale is created in the Amazon Lex V2 bot.
     *         </p>
     *         </li>
     * @see MigrationStrategy
     */
    public final MigrationStrategy migrationStrategy() {
        return MigrationStrategy.fromValue(migrationStrategy);
    }

    /**
     * <p>
     * The strategy used to conduct the migration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated.
     * It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is
     * created in the Amazon Lex V2 bot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStrategy}
     * will return {@link MigrationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to conduct the migration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new
     *         bot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
     *         migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
     *         new locale is created in the Amazon Lex V2 bot.
     *         </p>
     *         </li>
     * @see MigrationStrategy
     */
    public final String migrationStrategyAsString() {
        return migrationStrategy;
    }

    /**
     * <p>
     * The date and time that the migration started.
     * </p>
     * 
     * @return The date and time that the migration started.
     */
    public final Instant migrationTimestamp() {
        return migrationTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Alerts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlerts() {
        return alerts != null && !(alerts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to Amazon Lex V2.
     * You receive a warning when an Amazon Lex V1 feature has a different implementation if Amazon Lex V2.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a bot</a>
     * in the <i>Amazon Lex V2 developer guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlerts} method.
     * </p>
     * 
     * @return A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to Amazon
     *         Lex V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if Amazon Lex
     *         V2.</p>
     *         <p>
     *         For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a
     *         bot</a> in the <i>Amazon Lex V2 developer guide</i>.
     */
    public final List<MigrationAlert> alerts() {
        return alerts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(migrationId());
        hashCode = 31 * hashCode + Objects.hashCode(v1BotName());
        hashCode = 31 * hashCode + Objects.hashCode(v1BotVersion());
        hashCode = 31 * hashCode + Objects.hashCode(v1BotLocaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(v2BotId());
        hashCode = 31 * hashCode + Objects.hashCode(v2BotRole());
        hashCode = 31 * hashCode + Objects.hashCode(migrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(migrationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlerts() ? alerts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMigrationResponse)) {
            return false;
        }
        GetMigrationResponse other = (GetMigrationResponse) obj;
        return Objects.equals(migrationId(), other.migrationId()) && Objects.equals(v1BotName(), other.v1BotName())
                && Objects.equals(v1BotVersion(), other.v1BotVersion())
                && Objects.equals(v1BotLocaleAsString(), other.v1BotLocaleAsString())
                && Objects.equals(v2BotId(), other.v2BotId()) && Objects.equals(v2BotRole(), other.v2BotRole())
                && Objects.equals(migrationStatusAsString(), other.migrationStatusAsString())
                && Objects.equals(migrationStrategyAsString(), other.migrationStrategyAsString())
                && Objects.equals(migrationTimestamp(), other.migrationTimestamp()) && hasAlerts() == other.hasAlerts()
                && Objects.equals(alerts(), other.alerts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMigrationResponse").add("MigrationId", migrationId()).add("V1BotName", v1BotName())
                .add("V1BotVersion", v1BotVersion()).add("V1BotLocale", v1BotLocaleAsString()).add("V2BotId", v2BotId())
                .add("V2BotRole", v2BotRole()).add("MigrationStatus", migrationStatusAsString())
                .add("MigrationStrategy", migrationStrategyAsString()).add("MigrationTimestamp", migrationTimestamp())
                .add("Alerts", hasAlerts() ? alerts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "migrationId":
            return Optional.ofNullable(clazz.cast(migrationId()));
        case "v1BotName":
            return Optional.ofNullable(clazz.cast(v1BotName()));
        case "v1BotVersion":
            return Optional.ofNullable(clazz.cast(v1BotVersion()));
        case "v1BotLocale":
            return Optional.ofNullable(clazz.cast(v1BotLocaleAsString()));
        case "v2BotId":
            return Optional.ofNullable(clazz.cast(v2BotId()));
        case "v2BotRole":
            return Optional.ofNullable(clazz.cast(v2BotRole()));
        case "migrationStatus":
            return Optional.ofNullable(clazz.cast(migrationStatusAsString()));
        case "migrationStrategy":
            return Optional.ofNullable(clazz.cast(migrationStrategyAsString()));
        case "migrationTimestamp":
            return Optional.ofNullable(clazz.cast(migrationTimestamp()));
        case "alerts":
            return Optional.ofNullable(clazz.cast(alerts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMigrationResponse, T> g) {
        return obj -> g.apply((GetMigrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMigrationResponse> {
        /**
         * <p>
         * The unique identifier of the migration. This is the same as the identifier used when calling the
         * <code>GetMigration</code> operation.
         * </p>
         * 
         * @param migrationId
         *        The unique identifier of the migration. This is the same as the identifier used when calling the
         *        <code>GetMigration</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationId(String migrationId);

        /**
         * <p>
         * The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * </p>
         * 
         * @param v1BotName
         *        The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1BotName(String v1BotName);

        /**
         * <p>
         * The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * </p>
         * 
         * @param v1BotVersion
         *        The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1BotVersion(String v1BotVersion);

        /**
         * <p>
         * The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * </p>
         * 
         * @param v1BotLocale
         *        The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder v1BotLocale(String v1BotLocale);

        /**
         * <p>
         * The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * </p>
         * 
         * @param v1BotLocale
         *        The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder v1BotLocale(Locale v1BotLocale);

        /**
         * <p>
         * The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being migrated to.
         * </p>
         * 
         * @param v2BotId
         *        The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being migrated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v2BotId(String v2BotId);

        /**
         * <p>
         * The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
         * </p>
         * 
         * @param v2BotRole
         *        The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v2BotRole(String v2BotRole);

        /**
         * <p>
         * Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished and
         * the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to complete
         * the migration.
         * </p>
         * 
         * @param migrationStatus
         *        Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is
         *        finished and the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be
         *        resolved to complete the migration.
         * @see MigrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStatus
         */
        Builder migrationStatus(String migrationStatus);

        /**
         * <p>
         * Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished and
         * the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to complete
         * the migration.
         * </p>
         * 
         * @param migrationStatus
         *        Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is
         *        finished and the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be
         *        resolved to complete the migration.
         * @see MigrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStatus
         */
        Builder migrationStatus(MigrationStatus migrationStatus);

        /**
         * <p>
         * The strategy used to conduct the migration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         * migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new
         * locale is created in the Amazon Lex V2 bot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param migrationStrategy
         *        The strategy used to conduct the migration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the
         *        new bot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         *        migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
         *        new locale is created in the Amazon Lex V2 bot.
         *        </p>
         *        </li>
         * @see MigrationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStrategy
         */
        Builder migrationStrategy(String migrationStrategy);

        /**
         * <p>
         * The strategy used to conduct the migration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         * migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new
         * locale is created in the Amazon Lex V2 bot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param migrationStrategy
         *        The strategy used to conduct the migration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the
         *        new bot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
         *        migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a
         *        new locale is created in the Amazon Lex V2 bot.
         *        </p>
         *        </li>
         * @see MigrationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStrategy
         */
        Builder migrationStrategy(MigrationStrategy migrationStrategy);

        /**
         * <p>
         * The date and time that the migration started.
         * </p>
         * 
         * @param migrationTimestamp
         *        The date and time that the migration started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTimestamp(Instant migrationTimestamp);

        /**
         * <p>
         * A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to Amazon Lex
         * V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if Amazon Lex V2.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a
         * bot</a> in the <i>Amazon Lex V2 developer guide</i>.
         * </p>
         * 
         * @param alerts
         *        A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to
         *        Amazon Lex V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if
         *        Amazon Lex V2.</p>
         *        <p>
         *        For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating
         *        a bot</a> in the <i>Amazon Lex V2 developer guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alerts(Collection<MigrationAlert> alerts);

        /**
         * <p>
         * A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to Amazon Lex
         * V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if Amazon Lex V2.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a
         * bot</a> in the <i>Amazon Lex V2 developer guide</i>.
         * </p>
         * 
         * @param alerts
         *        A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to
         *        Amazon Lex V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if
         *        Amazon Lex V2.</p>
         *        <p>
         *        For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating
         *        a bot</a> in the <i>Amazon Lex V2 developer guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alerts(MigrationAlert... alerts);

        /**
         * <p>
         * A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to Amazon Lex
         * V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if Amazon Lex V2.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a
         * bot</a> in the <i>Amazon Lex V2 developer guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MigrationAlert>.Builder} avoiding
         * the need to create one manually via {@link List<MigrationAlert>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MigrationAlert>.Builder#build()} is called immediately and
         * its result is passed to {@link #alerts(List<MigrationAlert>)}.
         * 
         * @param alerts
         *        a consumer that will call methods on {@link List<MigrationAlert>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alerts(List<MigrationAlert>)
         */
        Builder alerts(Consumer<MigrationAlert.Builder>... alerts);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String migrationId;

        private String v1BotName;

        private String v1BotVersion;

        private String v1BotLocale;

        private String v2BotId;

        private String v2BotRole;

        private String migrationStatus;

        private String migrationStrategy;

        private Instant migrationTimestamp;

        private List<MigrationAlert> alerts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMigrationResponse model) {
            super(model);
            migrationId(model.migrationId);
            v1BotName(model.v1BotName);
            v1BotVersion(model.v1BotVersion);
            v1BotLocale(model.v1BotLocale);
            v2BotId(model.v2BotId);
            v2BotRole(model.v2BotRole);
            migrationStatus(model.migrationStatus);
            migrationStrategy(model.migrationStrategy);
            migrationTimestamp(model.migrationTimestamp);
            alerts(model.alerts);
        }

        public final String getMigrationId() {
            return migrationId;
        }

        public final void setMigrationId(String migrationId) {
            this.migrationId = migrationId;
        }

        @Override
        public final Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public final String getV1BotName() {
            return v1BotName;
        }

        public final void setV1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
        }

        @Override
        public final Builder v1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
            return this;
        }

        public final String getV1BotVersion() {
            return v1BotVersion;
        }

        public final void setV1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
        }

        @Override
        public final Builder v1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
            return this;
        }

        public final String getV1BotLocale() {
            return v1BotLocale;
        }

        public final void setV1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
        }

        @Override
        public final Builder v1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
            return this;
        }

        @Override
        public final Builder v1BotLocale(Locale v1BotLocale) {
            this.v1BotLocale(v1BotLocale == null ? null : v1BotLocale.toString());
            return this;
        }

        public final String getV2BotId() {
            return v2BotId;
        }

        public final void setV2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
        }

        @Override
        public final Builder v2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
            return this;
        }

        public final String getV2BotRole() {
            return v2BotRole;
        }

        public final void setV2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
        }

        @Override
        public final Builder v2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
            return this;
        }

        public final String getMigrationStatus() {
            return migrationStatus;
        }

        public final void setMigrationStatus(String migrationStatus) {
            this.migrationStatus = migrationStatus;
        }

        @Override
        public final Builder migrationStatus(String migrationStatus) {
            this.migrationStatus = migrationStatus;
            return this;
        }

        @Override
        public final Builder migrationStatus(MigrationStatus migrationStatus) {
            this.migrationStatus(migrationStatus == null ? null : migrationStatus.toString());
            return this;
        }

        public final String getMigrationStrategy() {
            return migrationStrategy;
        }

        public final void setMigrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
        }

        @Override
        public final Builder migrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
            return this;
        }

        @Override
        public final Builder migrationStrategy(MigrationStrategy migrationStrategy) {
            this.migrationStrategy(migrationStrategy == null ? null : migrationStrategy.toString());
            return this;
        }

        public final Instant getMigrationTimestamp() {
            return migrationTimestamp;
        }

        public final void setMigrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
        }

        @Override
        public final Builder migrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
            return this;
        }

        public final List<MigrationAlert.Builder> getAlerts() {
            List<MigrationAlert.Builder> result = MigrationAlertsCopier.copyToBuilder(this.alerts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlerts(Collection<MigrationAlert.BuilderImpl> alerts) {
            this.alerts = MigrationAlertsCopier.copyFromBuilder(alerts);
        }

        @Override
        public final Builder alerts(Collection<MigrationAlert> alerts) {
            this.alerts = MigrationAlertsCopier.copy(alerts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alerts(MigrationAlert... alerts) {
            alerts(Arrays.asList(alerts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alerts(Consumer<MigrationAlert.Builder>... alerts) {
            alerts(Stream.of(alerts).map(c -> MigrationAlert.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMigrationResponse build() {
            return new GetMigrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
