/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the settings needed for conversation logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLogsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationLogsRequest.Builder, ConversationLogsRequest> {
    private static final SdkField<List<LogSettingsRequest>> LOG_SETTINGS_FIELD = SdkField
            .<List<LogSettingsRequest>> builder(MarshallingType.LIST)
            .memberName("logSettings")
            .getter(getter(ConversationLogsRequest::logSettings))
            .setter(setter(Builder::logSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogSettingsRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogSettingsRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(ConversationLogsRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_SETTINGS_FIELD,
            IAM_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LogSettingsRequest> logSettings;

    private final String iamRoleArn;

    private ConversationLogsRequest(BuilderImpl builder) {
        this.logSettings = builder.logSettings;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogSettings() {
        return logSettings != null && !(logSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings for your conversation logs. You can log the conversation text, conversation audio, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogSettings} method.
     * </p>
     * 
     * @return The settings for your conversation logs. You can log the conversation text, conversation audio, or both.
     */
    public final List<LogSettingsRequest> logSettings() {
        return logSettings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to write to your CloudWatch Logs for text logs and
     * your S3 bucket for audio logs. If audio encryption is enabled, this role also provides access permission for the
     * AWS KMS key used for encrypting audio logs. For more information, see <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an IAM Role and
     * Policy for Conversation Logs</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to write to your CloudWatch Logs for text
     *         logs and your S3 bucket for audio logs. If audio encryption is enabled, this role also provides access
     *         permission for the AWS KMS key used for encrypting audio logs. For more information, see <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an IAM
     *         Role and Policy for Conversation Logs</a>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogSettings() ? logSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLogsRequest)) {
            return false;
        }
        ConversationLogsRequest other = (ConversationLogsRequest) obj;
        return hasLogSettings() == other.hasLogSettings() && Objects.equals(logSettings(), other.logSettings())
                && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLogsRequest").add("LogSettings", hasLogSettings() ? logSettings() : null)
                .add("IamRoleArn", iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logSettings":
            return Optional.ofNullable(clazz.cast(logSettings()));
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLogsRequest, T> g) {
        return obj -> g.apply((ConversationLogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLogsRequest> {
        /**
         * <p>
         * The settings for your conversation logs. You can log the conversation text, conversation audio, or both.
         * </p>
         * 
         * @param logSettings
         *        The settings for your conversation logs. You can log the conversation text, conversation audio, or
         *        both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(Collection<LogSettingsRequest> logSettings);

        /**
         * <p>
         * The settings for your conversation logs. You can log the conversation text, conversation audio, or both.
         * </p>
         * 
         * @param logSettings
         *        The settings for your conversation logs. You can log the conversation text, conversation audio, or
         *        both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(LogSettingsRequest... logSettings);

        /**
         * <p>
         * The settings for your conversation logs. You can log the conversation text, conversation audio, or both.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LogSettingsRequest>.Builder}
         * avoiding the need to create one manually via {@link List<LogSettingsRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogSettingsRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #logSettings(List<LogSettingsRequest>)}.
         * 
         * @param logSettings
         *        a consumer that will call methods on {@link List<LogSettingsRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logSettings(List<LogSettingsRequest>)
         */
        Builder logSettings(Consumer<LogSettingsRequest.Builder>... logSettings);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to write to your CloudWatch Logs for text logs
         * and your S3 bucket for audio logs. If audio encryption is enabled, this role also provides access permission
         * for the AWS KMS key used for encrypting audio logs. For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an IAM Role
         * and Policy for Conversation Logs</a>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to write to your CloudWatch Logs for
         *        text logs and your S3 bucket for audio logs. If audio encryption is enabled, this role also provides
         *        access permission for the AWS KMS key used for encrypting audio logs. For more information, see <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an
         *        IAM Role and Policy for Conversation Logs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<LogSettingsRequest> logSettings = DefaultSdkAutoConstructList.getInstance();

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLogsRequest model) {
            logSettings(model.logSettings);
            iamRoleArn(model.iamRoleArn);
        }

        public final List<LogSettingsRequest.Builder> getLogSettings() {
            List<LogSettingsRequest.Builder> result = LogSettingsRequestListCopier.copyToBuilder(this.logSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogSettings(Collection<LogSettingsRequest.BuilderImpl> logSettings) {
            this.logSettings = LogSettingsRequestListCopier.copyFromBuilder(logSettings);
        }

        @Override
        public final Builder logSettings(Collection<LogSettingsRequest> logSettings) {
            this.logSettings = LogSettingsRequestListCopier.copy(logSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSettings(LogSettingsRequest... logSettings) {
            logSettings(Arrays.asList(logSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSettings(Consumer<LogSettingsRequest.Builder>... logSettings) {
            logSettings(Stream.of(logSettings).map(c -> LogSettingsRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        @Override
        public ConversationLogsRequest build() {
            return new ConversationLogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
