/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.ExportType;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExportRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetExportRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetExportRequest.getter(GetExportRequest::name)).setter(GetExportRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(GetExportRequest.getter(GetExportRequest::version)).setter(GetExportRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(GetExportRequest.getter(GetExportRequest::resourceTypeAsString)).setter(GetExportRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<String> EXPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportType").getter(GetExportRequest.getter(GetExportRequest::exportTypeAsString)).setter(GetExportRequest.setter(Builder::exportType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("exportType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, RESOURCE_TYPE_FIELD, EXPORT_TYPE_FIELD));
    private final String name;
    private final String version;
    private final String resourceType;
    private final String exportType;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
        this.exportType = builder.exportType;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final ExportType exportType() {
        return ExportType.fromValue(this.exportType);
    }

    public final String exportTypeAsString() {
        return this.exportType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.exportTypeAsString(), other.exportTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetExportRequest").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ExportType", (Object)this.exportTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "exportType": {
                return Optional.ofNullable(clazz.cast(this.exportTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportRequest, T> g) {
        return obj -> g.apply((GetExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String resourceType;
        private String exportType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            super(model);
            this.name(model.name);
            this.version(model.version);
            this.resourceType(model.resourceType);
            this.exportType(model.exportType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getExportType() {
            return this.exportType;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        @Override
        @Transient
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        @Transient
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType == null ? null : exportType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExportRequest> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder exportType(String var1);

        public Builder exportType(ExportType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

