/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationAlertDetailsCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationAlertReferenceURLsCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationAlertType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrationAlert
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MigrationAlert> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(MigrationAlert.getter(MigrationAlert::typeAsString)).setter(MigrationAlert.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(MigrationAlert.getter(MigrationAlert::message)).setter(MigrationAlert.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<String>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("details").getter(MigrationAlert.getter(MigrationAlert::details)).setter(MigrationAlert.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REFERENCE_UR_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referenceURLs").getter(MigrationAlert.getter(MigrationAlert::referenceURLs)).setter(MigrationAlert.setter(Builder::referenceURLs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceURLs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MESSAGE_FIELD, DETAILS_FIELD, REFERENCE_UR_LS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String message;
    private final List<String> details;
    private final List<String> referenceURLs;

    private MigrationAlert(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
        this.details = builder.details;
        this.referenceURLs = builder.referenceURLs;
    }

    public final MigrationAlertType type() {
        return MigrationAlertType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public final List<String> details() {
        return this.details;
    }

    public final boolean hasReferenceURLs() {
        return this.referenceURLs != null && !(this.referenceURLs instanceof SdkAutoConstructList);
    }

    public final List<String> referenceURLs() {
        return this.referenceURLs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceURLs() ? this.referenceURLs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationAlert)) {
            return false;
        }
        MigrationAlert other = (MigrationAlert)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.message(), other.message()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details()) && this.hasReferenceURLs() == other.hasReferenceURLs() && Objects.equals(this.referenceURLs(), other.referenceURLs());
    }

    public final String toString() {
        return ToString.builder((String)"MigrationAlert").add("Type", (Object)this.typeAsString()).add("Message", (Object)this.message()).add("Details", this.hasDetails() ? this.details() : null).add("ReferenceURLs", this.hasReferenceURLs() ? this.referenceURLs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "referenceURLs": {
                return Optional.ofNullable(clazz.cast(this.referenceURLs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrationAlert, T> g) {
        return obj -> g.apply((MigrationAlert)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String message;
        private List<String> details = DefaultSdkAutoConstructList.getInstance();
        private List<String> referenceURLs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationAlert model) {
            this.type(model.type);
            this.message(model.message);
            this.details(model.details);
            this.referenceURLs(model.referenceURLs);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MigrationAlertType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<String> getDetails() {
            if (this.details instanceof SdkAutoConstructList) {
                return null;
            }
            return this.details;
        }

        @Override
        public final Builder details(Collection<String> details) {
            this.details = MigrationAlertDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(String ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<String> details) {
            this.details = MigrationAlertDetailsCopier.copy(details);
        }

        public final Collection<String> getReferenceURLs() {
            if (this.referenceURLs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceURLs;
        }

        @Override
        public final Builder referenceURLs(Collection<String> referenceURLs) {
            this.referenceURLs = MigrationAlertReferenceURLsCopier.copy(referenceURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceURLs(String ... referenceURLs) {
            this.referenceURLs(Arrays.asList(referenceURLs));
            return this;
        }

        public final void setReferenceURLs(Collection<String> referenceURLs) {
            this.referenceURLs = MigrationAlertReferenceURLsCopier.copy(referenceURLs);
        }

        public MigrationAlert build() {
            return new MigrationAlert(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MigrationAlert> {
        public Builder type(String var1);

        public Builder type(MigrationAlertType var1);

        public Builder message(String var1);

        public Builder details(Collection<String> var1);

        public Builder details(String ... var1);

        public Builder referenceURLs(Collection<String> var1);

        public Builder referenceURLs(String ... var1);
    }
}

