/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationStatus;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MigrationSummary> {
    private static final SdkField<String> MIGRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("migrationId").getter(MigrationSummary.getter(MigrationSummary::migrationId)).setter(MigrationSummary.setter(Builder::migrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationId").build()}).build();
    private static final SdkField<String> V1_BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v1BotName").getter(MigrationSummary.getter(MigrationSummary::v1BotName)).setter(MigrationSummary.setter(Builder::v1BotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotName").build()}).build();
    private static final SdkField<String> V1_BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v1BotVersion").getter(MigrationSummary.getter(MigrationSummary::v1BotVersion)).setter(MigrationSummary.setter(Builder::v1BotVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotVersion").build()}).build();
    private static final SdkField<String> V1_BOT_LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v1BotLocale").getter(MigrationSummary.getter(MigrationSummary::v1BotLocaleAsString)).setter(MigrationSummary.setter(Builder::v1BotLocale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotLocale").build()}).build();
    private static final SdkField<String> V2_BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v2BotId").getter(MigrationSummary.getter(MigrationSummary::v2BotId)).setter(MigrationSummary.setter(Builder::v2BotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotId").build()}).build();
    private static final SdkField<String> V2_BOT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v2BotRole").getter(MigrationSummary.getter(MigrationSummary::v2BotRole)).setter(MigrationSummary.setter(Builder::v2BotRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotRole").build()}).build();
    private static final SdkField<String> MIGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("migrationStatus").getter(MigrationSummary.getter(MigrationSummary::migrationStatusAsString)).setter(MigrationSummary.setter(Builder::migrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationStatus").build()}).build();
    private static final SdkField<String> MIGRATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("migrationStrategy").getter(MigrationSummary.getter(MigrationSummary::migrationStrategyAsString)).setter(MigrationSummary.setter(Builder::migrationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationStrategy").build()}).build();
    private static final SdkField<Instant> MIGRATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("migrationTimestamp").getter(MigrationSummary.getter(MigrationSummary::migrationTimestamp)).setter(MigrationSummary.setter(Builder::migrationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_ID_FIELD, V1_BOT_NAME_FIELD, V1_BOT_VERSION_FIELD, V1_BOT_LOCALE_FIELD, V2_BOT_ID_FIELD, V2_BOT_ROLE_FIELD, MIGRATION_STATUS_FIELD, MIGRATION_STRATEGY_FIELD, MIGRATION_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String migrationId;
    private final String v1BotName;
    private final String v1BotVersion;
    private final String v1BotLocale;
    private final String v2BotId;
    private final String v2BotRole;
    private final String migrationStatus;
    private final String migrationStrategy;
    private final Instant migrationTimestamp;

    private MigrationSummary(BuilderImpl builder) {
        this.migrationId = builder.migrationId;
        this.v1BotName = builder.v1BotName;
        this.v1BotVersion = builder.v1BotVersion;
        this.v1BotLocale = builder.v1BotLocale;
        this.v2BotId = builder.v2BotId;
        this.v2BotRole = builder.v2BotRole;
        this.migrationStatus = builder.migrationStatus;
        this.migrationStrategy = builder.migrationStrategy;
        this.migrationTimestamp = builder.migrationTimestamp;
    }

    public final String migrationId() {
        return this.migrationId;
    }

    public final String v1BotName() {
        return this.v1BotName;
    }

    public final String v1BotVersion() {
        return this.v1BotVersion;
    }

    public final Locale v1BotLocale() {
        return Locale.fromValue(this.v1BotLocale);
    }

    public final String v1BotLocaleAsString() {
        return this.v1BotLocale;
    }

    public final String v2BotId() {
        return this.v2BotId;
    }

    public final String v2BotRole() {
        return this.v2BotRole;
    }

    public final MigrationStatus migrationStatus() {
        return MigrationStatus.fromValue(this.migrationStatus);
    }

    public final String migrationStatusAsString() {
        return this.migrationStatus;
    }

    public final MigrationStrategy migrationStrategy() {
        return MigrationStrategy.fromValue(this.migrationStrategy);
    }

    public final String migrationStrategyAsString() {
        return this.migrationStrategy;
    }

    public final Instant migrationTimestamp() {
        return this.migrationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.v1BotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.v1BotVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.v1BotLocaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.v2BotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.v2BotRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationSummary)) {
            return false;
        }
        MigrationSummary other = (MigrationSummary)obj;
        return Objects.equals(this.migrationId(), other.migrationId()) && Objects.equals(this.v1BotName(), other.v1BotName()) && Objects.equals(this.v1BotVersion(), other.v1BotVersion()) && Objects.equals(this.v1BotLocaleAsString(), other.v1BotLocaleAsString()) && Objects.equals(this.v2BotId(), other.v2BotId()) && Objects.equals(this.v2BotRole(), other.v2BotRole()) && Objects.equals(this.migrationStatusAsString(), other.migrationStatusAsString()) && Objects.equals(this.migrationStrategyAsString(), other.migrationStrategyAsString()) && Objects.equals(this.migrationTimestamp(), other.migrationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"MigrationSummary").add("MigrationId", (Object)this.migrationId()).add("V1BotName", (Object)this.v1BotName()).add("V1BotVersion", (Object)this.v1BotVersion()).add("V1BotLocale", (Object)this.v1BotLocaleAsString()).add("V2BotId", (Object)this.v2BotId()).add("V2BotRole", (Object)this.v2BotRole()).add("MigrationStatus", (Object)this.migrationStatusAsString()).add("MigrationStrategy", (Object)this.migrationStrategyAsString()).add("MigrationTimestamp", (Object)this.migrationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "migrationId": {
                return Optional.ofNullable(clazz.cast(this.migrationId()));
            }
            case "v1BotName": {
                return Optional.ofNullable(clazz.cast(this.v1BotName()));
            }
            case "v1BotVersion": {
                return Optional.ofNullable(clazz.cast(this.v1BotVersion()));
            }
            case "v1BotLocale": {
                return Optional.ofNullable(clazz.cast(this.v1BotLocaleAsString()));
            }
            case "v2BotId": {
                return Optional.ofNullable(clazz.cast(this.v2BotId()));
            }
            case "v2BotRole": {
                return Optional.ofNullable(clazz.cast(this.v2BotRole()));
            }
            case "migrationStatus": {
                return Optional.ofNullable(clazz.cast(this.migrationStatusAsString()));
            }
            case "migrationStrategy": {
                return Optional.ofNullable(clazz.cast(this.migrationStrategyAsString()));
            }
            case "migrationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.migrationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrationSummary, T> g) {
        return obj -> g.apply((MigrationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String migrationId;
        private String v1BotName;
        private String v1BotVersion;
        private String v1BotLocale;
        private String v2BotId;
        private String v2BotRole;
        private String migrationStatus;
        private String migrationStrategy;
        private Instant migrationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationSummary model) {
            this.migrationId(model.migrationId);
            this.v1BotName(model.v1BotName);
            this.v1BotVersion(model.v1BotVersion);
            this.v1BotLocale(model.v1BotLocale);
            this.v2BotId(model.v2BotId);
            this.v2BotRole(model.v2BotRole);
            this.migrationStatus(model.migrationStatus);
            this.migrationStrategy(model.migrationStrategy);
            this.migrationTimestamp(model.migrationTimestamp);
        }

        public final String getMigrationId() {
            return this.migrationId;
        }

        @Override
        public final Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public final void setMigrationId(String migrationId) {
            this.migrationId = migrationId;
        }

        public final String getV1BotName() {
            return this.v1BotName;
        }

        @Override
        public final Builder v1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
            return this;
        }

        public final void setV1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
        }

        public final String getV1BotVersion() {
            return this.v1BotVersion;
        }

        @Override
        public final Builder v1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
            return this;
        }

        public final void setV1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
        }

        public final String getV1BotLocale() {
            return this.v1BotLocale;
        }

        @Override
        public final Builder v1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
            return this;
        }

        @Override
        public final Builder v1BotLocale(Locale v1BotLocale) {
            this.v1BotLocale(v1BotLocale == null ? null : v1BotLocale.toString());
            return this;
        }

        public final void setV1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
        }

        public final String getV2BotId() {
            return this.v2BotId;
        }

        @Override
        public final Builder v2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
            return this;
        }

        public final void setV2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
        }

        public final String getV2BotRole() {
            return this.v2BotRole;
        }

        @Override
        public final Builder v2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
            return this;
        }

        public final void setV2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
        }

        public final String getMigrationStatus() {
            return this.migrationStatus;
        }

        @Override
        public final Builder migrationStatus(String migrationStatus) {
            this.migrationStatus = migrationStatus;
            return this;
        }

        @Override
        public final Builder migrationStatus(MigrationStatus migrationStatus) {
            this.migrationStatus(migrationStatus == null ? null : migrationStatus.toString());
            return this;
        }

        public final void setMigrationStatus(String migrationStatus) {
            this.migrationStatus = migrationStatus;
        }

        public final String getMigrationStrategy() {
            return this.migrationStrategy;
        }

        @Override
        public final Builder migrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
            return this;
        }

        @Override
        public final Builder migrationStrategy(MigrationStrategy migrationStrategy) {
            this.migrationStrategy(migrationStrategy == null ? null : migrationStrategy.toString());
            return this;
        }

        public final void setMigrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
        }

        public final Instant getMigrationTimestamp() {
            return this.migrationTimestamp;
        }

        @Override
        public final Builder migrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
            return this;
        }

        public final void setMigrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
        }

        public MigrationSummary build() {
            return new MigrationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MigrationSummary> {
        public Builder migrationId(String var1);

        public Builder v1BotName(String var1);

        public Builder v1BotVersion(String var1);

        public Builder v1BotLocale(String var1);

        public Builder v1BotLocale(Locale var1);

        public Builder v2BotId(String var1);

        public Builder v2BotRole(String var1);

        public Builder migrationStatus(String var1);

        public Builder migrationStatus(MigrationStatus var1);

        public Builder migrationStrategy(String var1);

        public Builder migrationStrategy(MigrationStrategy var1);

        public Builder migrationTimestamp(Instant var1);
    }
}

