/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The message object that provides the message text and its type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(Message::contentTypeAsString)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(Message::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<Integer> GROUP_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("groupNumber").getter(getter(Message::groupNumber)).setter(setter(Builder::groupNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_FIELD, GROUP_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentType;

    private final String content;

    private final Integer groupNumber;

    private Message(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.content = builder.content;
        this.groupNumber = builder.groupNumber;
    }

    /**
     * <p>
     * The content type of the message string.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the message string.
     * @see ContentType
     */
    public final ContentType contentType() {
        return ContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The content type of the message string.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the message string.
     * @see ContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * The text of the message.
     * </p>
     * 
     * @return The text of the message.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * Identifies the message group that the message belongs to. When a group is assigned to a message, Amazon Lex
     * returns one message from each group in the response.
     * </p>
     * 
     * @return Identifies the message group that the message belongs to. When a group is assigned to a message, Amazon
     *         Lex returns one message from each group in the response.
     */
    public final Integer groupNumber() {
        return groupNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(groupNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(content(), other.content())
                && Objects.equals(groupNumber(), other.groupNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Message").add("ContentType", contentTypeAsString()).add("Content", content())
                .add("GroupNumber", groupNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "groupNumber":
            return Optional.ofNullable(clazz.cast(groupNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The content type of the message string.
         * </p>
         * 
         * @param contentType
         *        The content type of the message string.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content type of the message string.
         * </p>
         * 
         * @param contentType
         *        The content type of the message string.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(ContentType contentType);

        /**
         * <p>
         * The text of the message.
         * </p>
         * 
         * @param content
         *        The text of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Identifies the message group that the message belongs to. When a group is assigned to a message, Amazon Lex
         * returns one message from each group in the response.
         * </p>
         * 
         * @param groupNumber
         *        Identifies the message group that the message belongs to. When a group is assigned to a message,
         *        Amazon Lex returns one message from each group in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNumber(Integer groupNumber);
    }

    static final class BuilderImpl implements Builder {
        private String contentType;

        private String content;

        private Integer groupNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            contentType(model.contentType);
            content(model.content);
            groupNumber(model.groupNumber);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Integer getGroupNumber() {
            return groupNumber;
        }

        public final void setGroupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
        }

        @Override
        @Transient
        public final Builder groupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
