/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how the intent is fulfilled after the user provides all of the information required for the intent. You can
 * provide a Lambda function to process the intent, or you can return the intent information to the client application.
 * We recommend that you use a Lambda function so that the relevant logic lives in the Cloud and limit the client-side
 * code primarily to presentation. If you need to update the logic, you only update the Lambda function; you don't need
 * to upgrade your client application.
 * </p>
 * <p>
 * Consider the following examples:
 * </p>
 * <ul>
 * <li>
 * <p>
 * In a pizza ordering application, after the user provides all of the information for placing an order, you use a
 * Lambda function to place an order with a pizzeria.
 * </p>
 * </li>
 * <li>
 * <p>
 * In a gaming application, when a user says "pick up a rock," this information must go back to the client application
 * so that it can perform the operation and update the graphics. In this case, you want Amazon Lex to return the intent
 * data to the client.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FulfillmentActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<FulfillmentActivity.Builder, FulfillmentActivity> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FulfillmentActivity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<CodeHook> CODE_HOOK_FIELD = SdkField.<CodeHook> builder(MarshallingType.SDK_POJO)
            .memberName("codeHook").getter(getter(FulfillmentActivity::codeHook)).setter(setter(Builder::codeHook))
            .constructor(CodeHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHook").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CODE_HOOK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final CodeHook codeHook;

    private FulfillmentActivity(BuilderImpl builder) {
        this.type = builder.type;
        this.codeHook = builder.codeHook;
    }

    /**
     * <p>
     * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
     * client application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FulfillmentActivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to
     *         the client application.
     * @see FulfillmentActivityType
     */
    public final FulfillmentActivityType type() {
        return FulfillmentActivityType.fromValue(type);
    }

    /**
     * <p>
     * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
     * client application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FulfillmentActivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to
     *         the client application.
     * @see FulfillmentActivityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A description of the Lambda function that is run to fulfill the intent.
     * </p>
     * 
     * @return A description of the Lambda function that is run to fulfill the intent.
     */
    public final CodeHook codeHook() {
        return codeHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codeHook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentActivity)) {
            return false;
        }
        FulfillmentActivity other = (FulfillmentActivity) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(codeHook(), other.codeHook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FulfillmentActivity").add("Type", typeAsString()).add("CodeHook", codeHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "codeHook":
            return Optional.ofNullable(clazz.cast(codeHook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentActivity, T> g) {
        return obj -> g.apply((FulfillmentActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FulfillmentActivity> {
        /**
         * <p>
         * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
         * client application.
         * </p>
         * 
         * @param type
         *        How the intent should be fulfilled, either by running a Lambda function or by returning the slot data
         *        to the client application.
         * @see FulfillmentActivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FulfillmentActivityType
         */
        Builder type(String type);

        /**
         * <p>
         * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
         * client application.
         * </p>
         * 
         * @param type
         *        How the intent should be fulfilled, either by running a Lambda function or by returning the slot data
         *        to the client application.
         * @see FulfillmentActivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FulfillmentActivityType
         */
        Builder type(FulfillmentActivityType type);

        /**
         * <p>
         * A description of the Lambda function that is run to fulfill the intent.
         * </p>
         * 
         * @param codeHook
         *        A description of the Lambda function that is run to fulfill the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHook(CodeHook codeHook);

        /**
         * <p>
         * A description of the Lambda function that is run to fulfill the intent.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeHook.Builder} avoiding the need to create
         * one manually via {@link CodeHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeHook.Builder#build()} is called immediately and its result is
         * passed to {@link #codeHook(CodeHook)}.
         * 
         * @param codeHook
         *        a consumer that will call methods on {@link CodeHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeHook(CodeHook)
         */
        default Builder codeHook(Consumer<CodeHook.Builder> codeHook) {
            return codeHook(CodeHook.builder().applyMutation(codeHook).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private CodeHook codeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentActivity model) {
            type(model.type);
            codeHook(model.codeHook);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(FulfillmentActivityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CodeHook.Builder getCodeHook() {
            return codeHook != null ? codeHook.toBuilder() : null;
        }

        public final void setCodeHook(CodeHook.BuilderImpl codeHook) {
            this.codeHook = codeHook != null ? codeHook.build() : null;
        }

        @Override
        @Transient
        public final Builder codeHook(CodeHook codeHook) {
            this.codeHook = codeHook;
            return this;
        }

        @Override
        public FulfillmentActivity build() {
            return new FulfillmentActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
