/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMigrationResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<StartMigrationResponse.Builder, StartMigrationResponse> {
    private static final SdkField<String> V1_BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotName").getter(getter(StartMigrationResponse::v1BotName)).setter(setter(Builder::v1BotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotName").build()).build();

    private static final SdkField<String> V1_BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotVersion").getter(getter(StartMigrationResponse::v1BotVersion))
            .setter(setter(Builder::v1BotVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotVersion").build()).build();

    private static final SdkField<String> V1_BOT_LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotLocale").getter(getter(StartMigrationResponse::v1BotLocaleAsString))
            .setter(setter(Builder::v1BotLocale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1BotLocale").build()).build();

    private static final SdkField<String> V2_BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v2BotId").getter(getter(StartMigrationResponse::v2BotId)).setter(setter(Builder::v2BotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotId").build()).build();

    private static final SdkField<String> V2_BOT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v2BotRole").getter(getter(StartMigrationResponse::v2BotRole)).setter(setter(Builder::v2BotRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v2BotRole").build()).build();

    private static final SdkField<String> MIGRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("migrationId").getter(getter(StartMigrationResponse::migrationId)).setter(setter(Builder::migrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationId").build()).build();

    private static final SdkField<String> MIGRATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("migrationStrategy").getter(getter(StartMigrationResponse::migrationStrategyAsString))
            .setter(setter(Builder::migrationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationStrategy").build()).build();

    private static final SdkField<Instant> MIGRATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("migrationTimestamp").getter(getter(StartMigrationResponse::migrationTimestamp))
            .setter(setter(Builder::migrationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V1_BOT_NAME_FIELD,
            V1_BOT_VERSION_FIELD, V1_BOT_LOCALE_FIELD, V2_BOT_ID_FIELD, V2_BOT_ROLE_FIELD, MIGRATION_ID_FIELD,
            MIGRATION_STRATEGY_FIELD, MIGRATION_TIMESTAMP_FIELD));

    private final String v1BotName;

    private final String v1BotVersion;

    private final String v1BotLocale;

    private final String v2BotId;

    private final String v2BotRole;

    private final String migrationId;

    private final String migrationStrategy;

    private final Instant migrationTimestamp;

    private StartMigrationResponse(BuilderImpl builder) {
        super(builder);
        this.v1BotName = builder.v1BotName;
        this.v1BotVersion = builder.v1BotVersion;
        this.v1BotLocale = builder.v1BotLocale;
        this.v2BotId = builder.v2BotId;
        this.v2BotRole = builder.v2BotRole;
        this.migrationId = builder.migrationId;
        this.migrationStrategy = builder.migrationStrategy;
        this.migrationTimestamp = builder.migrationTimestamp;
    }

    /**
     * <p>
     * The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
     * </p>
     * 
     * @return The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
     */
    public final String v1BotName() {
        return v1BotName;
    }

    /**
     * <p>
     * The version of the bot to migrate to Amazon Lex V2.
     * </p>
     * 
     * @return The version of the bot to migrate to Amazon Lex V2.
     */
    public final String v1BotVersion() {
        return v1BotVersion;
    }

    /**
     * <p>
     * The locale used for the Amazon Lex V1 bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #v1BotLocale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #v1BotLocaleAsString}.
     * </p>
     * 
     * @return The locale used for the Amazon Lex V1 bot.
     * @see Locale
     */
    public final Locale v1BotLocale() {
        return Locale.fromValue(v1BotLocale);
    }

    /**
     * <p>
     * The locale used for the Amazon Lex V1 bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #v1BotLocale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #v1BotLocaleAsString}.
     * </p>
     * 
     * @return The locale used for the Amazon Lex V1 bot.
     * @see Locale
     */
    public final String v1BotLocaleAsString() {
        return v1BotLocale;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Lex V2 bot.
     * </p>
     * 
     * @return The unique identifier for the Amazon Lex V2 bot.
     */
    public final String v2BotId() {
        return v2BotId;
    }

    /**
     * <p>
     * The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
     * </p>
     * 
     * @return The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
     */
    public final String v2BotRole() {
        return v2BotRole;
    }

    /**
     * <p>
     * The unique identifier that Amazon Lex assigned to the migration.
     * </p>
     * 
     * @return The unique identifier that Amazon Lex assigned to the migration.
     */
    public final String migrationId() {
        return migrationId;
    }

    /**
     * <p>
     * The strategy used to conduct the migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStrategy}
     * will return {@link MigrationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to conduct the migration.
     * @see MigrationStrategy
     */
    public final MigrationStrategy migrationStrategy() {
        return MigrationStrategy.fromValue(migrationStrategy);
    }

    /**
     * <p>
     * The strategy used to conduct the migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationStrategy}
     * will return {@link MigrationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to conduct the migration.
     * @see MigrationStrategy
     */
    public final String migrationStrategyAsString() {
        return migrationStrategy;
    }

    /**
     * <p>
     * The date and time that the migration started.
     * </p>
     * 
     * @return The date and time that the migration started.
     */
    public final Instant migrationTimestamp() {
        return migrationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(v1BotName());
        hashCode = 31 * hashCode + Objects.hashCode(v1BotVersion());
        hashCode = 31 * hashCode + Objects.hashCode(v1BotLocaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(v2BotId());
        hashCode = 31 * hashCode + Objects.hashCode(v2BotRole());
        hashCode = 31 * hashCode + Objects.hashCode(migrationId());
        hashCode = 31 * hashCode + Objects.hashCode(migrationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMigrationResponse)) {
            return false;
        }
        StartMigrationResponse other = (StartMigrationResponse) obj;
        return Objects.equals(v1BotName(), other.v1BotName()) && Objects.equals(v1BotVersion(), other.v1BotVersion())
                && Objects.equals(v1BotLocaleAsString(), other.v1BotLocaleAsString())
                && Objects.equals(v2BotId(), other.v2BotId()) && Objects.equals(v2BotRole(), other.v2BotRole())
                && Objects.equals(migrationId(), other.migrationId())
                && Objects.equals(migrationStrategyAsString(), other.migrationStrategyAsString())
                && Objects.equals(migrationTimestamp(), other.migrationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMigrationResponse").add("V1BotName", v1BotName()).add("V1BotVersion", v1BotVersion())
                .add("V1BotLocale", v1BotLocaleAsString()).add("V2BotId", v2BotId()).add("V2BotRole", v2BotRole())
                .add("MigrationId", migrationId()).add("MigrationStrategy", migrationStrategyAsString())
                .add("MigrationTimestamp", migrationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "v1BotName":
            return Optional.ofNullable(clazz.cast(v1BotName()));
        case "v1BotVersion":
            return Optional.ofNullable(clazz.cast(v1BotVersion()));
        case "v1BotLocale":
            return Optional.ofNullable(clazz.cast(v1BotLocaleAsString()));
        case "v2BotId":
            return Optional.ofNullable(clazz.cast(v2BotId()));
        case "v2BotRole":
            return Optional.ofNullable(clazz.cast(v2BotRole()));
        case "migrationId":
            return Optional.ofNullable(clazz.cast(migrationId()));
        case "migrationStrategy":
            return Optional.ofNullable(clazz.cast(migrationStrategyAsString()));
        case "migrationTimestamp":
            return Optional.ofNullable(clazz.cast(migrationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMigrationResponse, T> g) {
        return obj -> g.apply((StartMigrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartMigrationResponse> {
        /**
         * <p>
         * The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
         * </p>
         * 
         * @param v1BotName
         *        The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1BotName(String v1BotName);

        /**
         * <p>
         * The version of the bot to migrate to Amazon Lex V2.
         * </p>
         * 
         * @param v1BotVersion
         *        The version of the bot to migrate to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1BotVersion(String v1BotVersion);

        /**
         * <p>
         * The locale used for the Amazon Lex V1 bot.
         * </p>
         * 
         * @param v1BotLocale
         *        The locale used for the Amazon Lex V1 bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder v1BotLocale(String v1BotLocale);

        /**
         * <p>
         * The locale used for the Amazon Lex V1 bot.
         * </p>
         * 
         * @param v1BotLocale
         *        The locale used for the Amazon Lex V1 bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder v1BotLocale(Locale v1BotLocale);

        /**
         * <p>
         * The unique identifier for the Amazon Lex V2 bot.
         * </p>
         * 
         * @param v2BotId
         *        The unique identifier for the Amazon Lex V2 bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v2BotId(String v2BotId);

        /**
         * <p>
         * The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
         * </p>
         * 
         * @param v2BotRole
         *        The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v2BotRole(String v2BotRole);

        /**
         * <p>
         * The unique identifier that Amazon Lex assigned to the migration.
         * </p>
         * 
         * @param migrationId
         *        The unique identifier that Amazon Lex assigned to the migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationId(String migrationId);

        /**
         * <p>
         * The strategy used to conduct the migration.
         * </p>
         * 
         * @param migrationStrategy
         *        The strategy used to conduct the migration.
         * @see MigrationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStrategy
         */
        Builder migrationStrategy(String migrationStrategy);

        /**
         * <p>
         * The strategy used to conduct the migration.
         * </p>
         * 
         * @param migrationStrategy
         *        The strategy used to conduct the migration.
         * @see MigrationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStrategy
         */
        Builder migrationStrategy(MigrationStrategy migrationStrategy);

        /**
         * <p>
         * The date and time that the migration started.
         * </p>
         * 
         * @param migrationTimestamp
         *        The date and time that the migration started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTimestamp(Instant migrationTimestamp);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String v1BotName;

        private String v1BotVersion;

        private String v1BotLocale;

        private String v2BotId;

        private String v2BotRole;

        private String migrationId;

        private String migrationStrategy;

        private Instant migrationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMigrationResponse model) {
            super(model);
            v1BotName(model.v1BotName);
            v1BotVersion(model.v1BotVersion);
            v1BotLocale(model.v1BotLocale);
            v2BotId(model.v2BotId);
            v2BotRole(model.v2BotRole);
            migrationId(model.migrationId);
            migrationStrategy(model.migrationStrategy);
            migrationTimestamp(model.migrationTimestamp);
        }

        public final String getV1BotName() {
            return v1BotName;
        }

        public final void setV1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
        }

        @Override
        @Transient
        public final Builder v1BotName(String v1BotName) {
            this.v1BotName = v1BotName;
            return this;
        }

        public final String getV1BotVersion() {
            return v1BotVersion;
        }

        public final void setV1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
        }

        @Override
        @Transient
        public final Builder v1BotVersion(String v1BotVersion) {
            this.v1BotVersion = v1BotVersion;
            return this;
        }

        public final String getV1BotLocale() {
            return v1BotLocale;
        }

        public final void setV1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
        }

        @Override
        @Transient
        public final Builder v1BotLocale(String v1BotLocale) {
            this.v1BotLocale = v1BotLocale;
            return this;
        }

        @Override
        @Transient
        public final Builder v1BotLocale(Locale v1BotLocale) {
            this.v1BotLocale(v1BotLocale == null ? null : v1BotLocale.toString());
            return this;
        }

        public final String getV2BotId() {
            return v2BotId;
        }

        public final void setV2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
        }

        @Override
        @Transient
        public final Builder v2BotId(String v2BotId) {
            this.v2BotId = v2BotId;
            return this;
        }

        public final String getV2BotRole() {
            return v2BotRole;
        }

        public final void setV2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
        }

        @Override
        @Transient
        public final Builder v2BotRole(String v2BotRole) {
            this.v2BotRole = v2BotRole;
            return this;
        }

        public final String getMigrationId() {
            return migrationId;
        }

        public final void setMigrationId(String migrationId) {
            this.migrationId = migrationId;
        }

        @Override
        @Transient
        public final Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public final String getMigrationStrategy() {
            return migrationStrategy;
        }

        public final void setMigrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
        }

        @Override
        @Transient
        public final Builder migrationStrategy(String migrationStrategy) {
            this.migrationStrategy = migrationStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder migrationStrategy(MigrationStrategy migrationStrategy) {
            this.migrationStrategy(migrationStrategy == null ? null : migrationStrategy.toString());
            return this;
        }

        public final Instant getMigrationTimestamp() {
            return migrationTimestamp;
        }

        public final void setMigrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
        }

        @Override
        @Transient
        public final Builder migrationTimestamp(Instant migrationTimestamp) {
            this.migrationTimestamp = migrationTimestamp;
            return this;
        }

        @Override
        public StartMigrationResponse build() {
            return new StartMigrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
