/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUtterancesViewResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetUtterancesViewResponse.Builder, GetUtterancesViewResponse> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(GetUtterancesViewResponse::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<List<UtteranceList>> UTTERANCES_FIELD = SdkField
            .<List<UtteranceList>> builder(MarshallingType.LIST)
            .memberName("utterances")
            .getter(getter(GetUtterancesViewResponse::utterances))
            .setter(setter(Builder::utterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UtteranceList> builder(MarshallingType.SDK_POJO)
                                            .constructor(UtteranceList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            UTTERANCES_FIELD));

    private final String botName;

    private final List<UtteranceList> utterances;

    private GetUtterancesViewResponse(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.utterances = builder.utterances;
    }

    /**
     * <p>
     * The name of the bot for which utterance information was returned.
     * </p>
     * 
     * @return The name of the bot for which utterance information was returned.
     */
    public final String botName() {
        return botName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Utterances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUtterances() {
        return utterances != null && !(utterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects describing the
     * utterances that were processed by your bot. The response contains a maximum of 100 <code>UtteranceData</code>
     * objects for each version. Amazon Lex returns the most frequent utterances received by the bot in the last 15
     * days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUtterances} method.
     * </p>
     * 
     * @return An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects
     *         describing the utterances that were processed by your bot. The response contains a maximum of 100
     *         <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances
     *         received by the bot in the last 15 days.
     */
    public final List<UtteranceList> utterances() {
        return utterances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUtterances() ? utterances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewResponse)) {
            return false;
        }
        GetUtterancesViewResponse other = (GetUtterancesViewResponse) obj;
        return Objects.equals(botName(), other.botName()) && hasUtterances() == other.hasUtterances()
                && Objects.equals(utterances(), other.utterances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUtterancesViewResponse").add("BotName", botName())
                .add("Utterances", hasUtterances() ? utterances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "utterances":
            return Optional.ofNullable(clazz.cast(utterances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUtterancesViewResponse, T> g) {
        return obj -> g.apply((GetUtterancesViewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUtterancesViewResponse> {
        /**
         * <p>
         * The name of the bot for which utterance information was returned.
         * </p>
         * 
         * @param botName
         *        The name of the bot for which utterance information was returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects describing
         * the utterances that were processed by your bot. The response contains a maximum of 100
         * <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances received
         * by the bot in the last 15 days.
         * </p>
         * 
         * @param utterances
         *        An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects
         *        describing the utterances that were processed by your bot. The response contains a maximum of 100
         *        <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances
         *        received by the bot in the last 15 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(Collection<UtteranceList> utterances);

        /**
         * <p>
         * An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects describing
         * the utterances that were processed by your bot. The response contains a maximum of 100
         * <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances received
         * by the bot in the last 15 days.
         * </p>
         * 
         * @param utterances
         *        An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects
         *        describing the utterances that were processed by your bot. The response contains a maximum of 100
         *        <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances
         *        received by the bot in the last 15 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(UtteranceList... utterances);

        /**
         * <p>
         * An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects describing
         * the utterances that were processed by your bot. The response contains a maximum of 100
         * <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances received
         * by the bot in the last 15 days.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UtteranceList>.Builder} avoiding the need
         * to create one manually via {@link List<UtteranceList>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UtteranceList>.Builder#build()} is called immediately and
         * its result is passed to {@link #utterances(List<UtteranceList>)}.
         * 
         * @param utterances
         *        a consumer that will call methods on {@link List<UtteranceList>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utterances(List<UtteranceList>)
         */
        Builder utterances(Consumer<UtteranceList.Builder>... utterances);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String botName;

        private List<UtteranceList> utterances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewResponse model) {
            super(model);
            botName(model.botName);
            utterances(model.utterances);
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        @Transient
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final List<UtteranceList.Builder> getUtterances() {
            List<UtteranceList.Builder> result = ListsOfUtterancesCopier.copyToBuilder(this.utterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtterances(Collection<UtteranceList.BuilderImpl> utterances) {
            this.utterances = ListsOfUtterancesCopier.copyFromBuilder(utterances);
        }

        @Override
        @Transient
        public final Builder utterances(Collection<UtteranceList> utterances) {
            this.utterances = ListsOfUtterancesCopier.copy(utterances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder utterances(UtteranceList... utterances) {
            utterances(Arrays.asList(utterances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder utterances(Consumer<UtteranceList.Builder>... utterances) {
            utterances(Stream.of(utterances).map(c -> UtteranceList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetUtterancesViewResponse build() {
            return new GetUtterancesViewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
