/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationSortAttribute;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationStatus;
import software.amazon.awssdk.services.lexmodelbuilding.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMigrationsRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetMigrationsRequest> {
    private static final SdkField<String> SORT_BY_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortByAttribute").getter(GetMigrationsRequest.getter(GetMigrationsRequest::sortByAttributeAsString)).setter(GetMigrationsRequest.setter(Builder::sortByAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortByAttribute").build()}).build();
    private static final SdkField<String> SORT_BY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortByOrder").getter(GetMigrationsRequest.getter(GetMigrationsRequest::sortByOrderAsString)).setter(GetMigrationsRequest.setter(Builder::sortByOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortByOrder").build()}).build();
    private static final SdkField<String> V1_BOT_NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("v1BotNameContains").getter(GetMigrationsRequest.getter(GetMigrationsRequest::v1BotNameContains)).setter(GetMigrationsRequest.setter(Builder::v1BotNameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("v1BotNameContains").build()}).build();
    private static final SdkField<String> MIGRATION_STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("migrationStatusEquals").getter(GetMigrationsRequest.getter(GetMigrationsRequest::migrationStatusEqualsAsString)).setter(GetMigrationsRequest.setter(Builder::migrationStatusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("migrationStatusEquals").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetMigrationsRequest.getter(GetMigrationsRequest::maxResults)).setter(GetMigrationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetMigrationsRequest.getter(GetMigrationsRequest::nextToken)).setter(GetMigrationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_ATTRIBUTE_FIELD, SORT_BY_ORDER_FIELD, V1_BOT_NAME_CONTAINS_FIELD, MIGRATION_STATUS_EQUALS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String sortByAttribute;
    private final String sortByOrder;
    private final String v1BotNameContains;
    private final String migrationStatusEquals;
    private final Integer maxResults;
    private final String nextToken;

    private GetMigrationsRequest(BuilderImpl builder) {
        super(builder);
        this.sortByAttribute = builder.sortByAttribute;
        this.sortByOrder = builder.sortByOrder;
        this.v1BotNameContains = builder.v1BotNameContains;
        this.migrationStatusEquals = builder.migrationStatusEquals;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final MigrationSortAttribute sortByAttribute() {
        return MigrationSortAttribute.fromValue(this.sortByAttribute);
    }

    public final String sortByAttributeAsString() {
        return this.sortByAttribute;
    }

    public final SortOrder sortByOrder() {
        return SortOrder.fromValue(this.sortByOrder);
    }

    public final String sortByOrderAsString() {
        return this.sortByOrder;
    }

    public final String v1BotNameContains() {
        return this.v1BotNameContains;
    }

    public final MigrationStatus migrationStatusEquals() {
        return MigrationStatus.fromValue(this.migrationStatusEquals);
    }

    public final String migrationStatusEqualsAsString() {
        return this.migrationStatusEquals;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.v1BotNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationStatusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMigrationsRequest)) {
            return false;
        }
        GetMigrationsRequest other = (GetMigrationsRequest)((Object)obj);
        return Objects.equals(this.sortByAttributeAsString(), other.sortByAttributeAsString()) && Objects.equals(this.sortByOrderAsString(), other.sortByOrderAsString()) && Objects.equals(this.v1BotNameContains(), other.v1BotNameContains()) && Objects.equals(this.migrationStatusEqualsAsString(), other.migrationStatusEqualsAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetMigrationsRequest").add("SortByAttribute", (Object)this.sortByAttributeAsString()).add("SortByOrder", (Object)this.sortByOrderAsString()).add("V1BotNameContains", (Object)this.v1BotNameContains()).add("MigrationStatusEquals", (Object)this.migrationStatusEqualsAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sortByAttribute": {
                return Optional.ofNullable(clazz.cast(this.sortByAttributeAsString()));
            }
            case "sortByOrder": {
                return Optional.ofNullable(clazz.cast(this.sortByOrderAsString()));
            }
            case "v1BotNameContains": {
                return Optional.ofNullable(clazz.cast(this.v1BotNameContains()));
            }
            case "migrationStatusEquals": {
                return Optional.ofNullable(clazz.cast(this.migrationStatusEqualsAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMigrationsRequest, T> g) {
        return obj -> g.apply((GetMigrationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String sortByAttribute;
        private String sortByOrder;
        private String v1BotNameContains;
        private String migrationStatusEquals;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMigrationsRequest model) {
            super(model);
            this.sortByAttribute(model.sortByAttribute);
            this.sortByOrder(model.sortByOrder);
            this.v1BotNameContains(model.v1BotNameContains);
            this.migrationStatusEquals(model.migrationStatusEquals);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getSortByAttribute() {
            return this.sortByAttribute;
        }

        public final void setSortByAttribute(String sortByAttribute) {
            this.sortByAttribute = sortByAttribute;
        }

        @Override
        @Transient
        public final Builder sortByAttribute(String sortByAttribute) {
            this.sortByAttribute = sortByAttribute;
            return this;
        }

        @Override
        @Transient
        public final Builder sortByAttribute(MigrationSortAttribute sortByAttribute) {
            this.sortByAttribute(sortByAttribute == null ? null : sortByAttribute.toString());
            return this;
        }

        public final String getSortByOrder() {
            return this.sortByOrder;
        }

        public final void setSortByOrder(String sortByOrder) {
            this.sortByOrder = sortByOrder;
        }

        @Override
        @Transient
        public final Builder sortByOrder(String sortByOrder) {
            this.sortByOrder = sortByOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder sortByOrder(SortOrder sortByOrder) {
            this.sortByOrder(sortByOrder == null ? null : sortByOrder.toString());
            return this;
        }

        public final String getV1BotNameContains() {
            return this.v1BotNameContains;
        }

        public final void setV1BotNameContains(String v1BotNameContains) {
            this.v1BotNameContains = v1BotNameContains;
        }

        @Override
        @Transient
        public final Builder v1BotNameContains(String v1BotNameContains) {
            this.v1BotNameContains = v1BotNameContains;
            return this;
        }

        public final String getMigrationStatusEquals() {
            return this.migrationStatusEquals;
        }

        public final void setMigrationStatusEquals(String migrationStatusEquals) {
            this.migrationStatusEquals = migrationStatusEquals;
        }

        @Override
        @Transient
        public final Builder migrationStatusEquals(String migrationStatusEquals) {
            this.migrationStatusEquals = migrationStatusEquals;
            return this;
        }

        @Override
        @Transient
        public final Builder migrationStatusEquals(MigrationStatus migrationStatusEquals) {
            this.migrationStatusEquals(migrationStatusEquals == null ? null : migrationStatusEquals.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMigrationsRequest build() {
            return new GetMigrationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMigrationsRequest> {
        public Builder sortByAttribute(String var1);

        public Builder sortByAttribute(MigrationSortAttribute var1);

        public Builder sortByOrder(String var1);

        public Builder sortByOrder(SortOrder var1);

        public Builder v1BotNameContains(String var1);

        public Builder migrationStatusEquals(String var1);

        public Builder migrationStatusEquals(MigrationStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

