/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse;

public class GetBotVersionsIterable
implements SdkIterable<GetBotVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBotVersionsIterable(LexModelBuildingClient client, GetBotVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetBotVersionsResponseFetcher();
    }

    public Iterator<GetBotVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetBotVersionsResponseFetcher
    implements SyncPageFetcher<GetBotVersionsResponse> {
        private GetBotVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBotVersionsResponse nextPage(GetBotVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetBotVersionsIterable.this.client.getBotVersions(GetBotVersionsIterable.this.firstRequest);
            }
            return GetBotVersionsIterable.this.client.getBotVersions((GetBotVersionsRequest)((Object)GetBotVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

