/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.internal.LexModelBuildingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lexmodelbuilding.model.AccessDeniedException;
import software.amazon.awssdk.services.lexmodelbuilding.model.BadRequestException;
import software.amazon.awssdk.services.lexmodelbuilding.model.ConflictException;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateIntentVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateIntentVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateSlotTypeVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateSlotTypeVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotChannelAssociationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotChannelAssociationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteUtterancesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteUtterancesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetExportRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetExportResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetImportRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetImportResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetUtterancesViewRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetUtterancesViewResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.InternalFailureException;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingException;
import software.amazon.awssdk.services.lexmodelbuilding.model.LimitExceededException;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.NotFoundException;
import software.amazon.awssdk.services.lexmodelbuilding.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceInUseException;
import software.amazon.awssdk.services.lexmodelbuilding.model.StartImportRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.StartImportResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.StartMigrationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.StartMigrationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateIntentVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateSlotTypeVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotChannelAssociationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteUtterancesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetMigrationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetMigrationsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetUtterancesViewRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.StartMigrationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link LexModelBuildingAsyncClient}.
 *
 * @see LexModelBuildingAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLexModelBuildingAsyncClient implements LexModelBuildingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLexModelBuildingAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLexModelBuildingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>&#36LATEST</code> version. If the <code>&#36LATEST</code>
     * version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new
     * version. It returns the last created version.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of the bot. You can't update the numbered versions that
     * you create with the <code>CreateBotVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * For more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:CreateBotVersion</code> action.
     * </p>
     *
     * @param createBotVersionRequest
     * @return A Java Future containing the result of the CreateBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBotVersionResponse> createBotVersion(CreateBotVersionRequest createBotVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBotVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBotVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBotVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBotVersionRequest, CreateBotVersionResponse>()
                            .withOperationName("CreateBotVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBotVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBotVersionRequest));
            CompletableFuture<CreateBotVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of an intent based on the <code>&#36LATEST</code> version of the intent. If the
     * <code>&#36LATEST</code> version of this intent hasn't changed since you last updated it, Amazon Lex doesn't
     * create a new version. It returns the last version you created.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of the intent. You can't update the numbered versions
     * that you create with the <code>CreateIntentVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create a version of an intent, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For
     * more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lex:CreateIntentVersion</code> action.
     * </p>
     *
     * @param createIntentVersionRequest
     * @return A Java Future containing the result of the CreateIntentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.CreateIntentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateIntentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIntentVersionResponse> createIntentVersion(
            CreateIntentVersionRequest createIntentVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIntentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIntentVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIntentVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIntentVersionRequest, CreateIntentVersionResponse>()
                            .withOperationName("CreateIntentVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIntentVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIntentVersionRequest));
            CompletableFuture<CreateIntentVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of a slot type based on the <code>&#36LATEST</code> version of the specified slot type. If
     * the <code>&#36LATEST</code> version of this resource has not changed since the last version that you created,
     * Amazon Lex doesn't create a new version. It returns the last version that you created.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of a slot type. You can't update the numbered versions
     * that you create with the <code>CreateSlotTypeVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create a version of a slot type, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * For more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:CreateSlotTypeVersion</code> action.
     * </p>
     *
     * @param createSlotTypeVersionRequest
     * @return A Java Future containing the result of the CreateSlotTypeVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.CreateSlotTypeVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateSlotTypeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSlotTypeVersionResponse> createSlotTypeVersion(
            CreateSlotTypeVersionRequest createSlotTypeVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSlotTypeVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSlotTypeVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlotTypeVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSlotTypeVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSlotTypeVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSlotTypeVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSlotTypeVersionRequest, CreateSlotTypeVersionResponse>()
                            .withOperationName("CreateSlotTypeVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSlotTypeVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSlotTypeVersionRequest));
            CompletableFuture<CreateSlotTypeVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all versions of the bot, including the <code>&#36LATEST</code> version. To delete a specific version of
     * the bot, use the <a>DeleteBotVersion</a> operation. The <code>DeleteBot</code> operation doesn't immediately
     * remove the bot schema. Instead, it is marked for deletion and removed later.
     * </p>
     * <p>
     * Amazon Lex stores utterances indefinitely for improving the ability of your bot to respond to user inputs. These
     * utterances are not removed when the bot is deleted. To remove the utterances, use the <a>DeleteUtterances</a>
     * operation.
     * </p>
     * <p>
     * If a bot has an alias, you can't delete it. Instead, the <code>DeleteBot</code> operation returns a
     * <code>ResourceInUseException</code> exception that includes a reference to the alias that refers to the bot. To
     * remove the reference to the bot, delete the alias. If you get the same exception again, delete the referring
     * alias until the <code>DeleteBot</code> operation is successful.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteBot</code> action.
     * </p>
     *
     * @param deleteBotRequest
     * @return A Java Future containing the result of the DeleteBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotResponse> deleteBot(DeleteBotRequest deleteBotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotRequest, DeleteBotResponse>().withOperationName("DeleteBot")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBotRequest));
            CompletableFuture<DeleteBotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an alias for the specified bot.
     * </p>
     * <p>
     * You can't delete an alias that is used in the association between a bot and a messaging channel. If an alias is
     * used in a channel association, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception that includes a reference to the channel association that refers to the bot. You can remove the
     * reference to the alias by deleting the channel association. If you get the same exception again, delete the
     * referring association until the <code>DeleteBotAlias</code> operation is successful.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return A Java Future containing the result of the DeleteBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotAliasResponse> deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBotAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotAliasRequest, DeleteBotAliasResponse>()
                            .withOperationName("DeleteBotAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBotAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBotAliasRequest));
            CompletableFuture<DeleteBotAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the association between an Amazon Lex bot and a messaging platform.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:DeleteBotChannelAssociation</code> action.
     * </p>
     *
     * @param deleteBotChannelAssociationRequest
     * @return A Java Future containing the result of the DeleteBotChannelAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBotChannelAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotChannelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotChannelAssociationResponse> deleteBotChannelAssociation(
            DeleteBotChannelAssociationRequest deleteBotChannelAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotChannelAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotChannelAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotChannelAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotChannelAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBotChannelAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotChannelAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotChannelAssociationRequest, DeleteBotChannelAssociationResponse>()
                            .withOperationName("DeleteBotChannelAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBotChannelAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBotChannelAssociationRequest));
            CompletableFuture<DeleteBotChannelAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteBotVersion</code> action.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return A Java Future containing the result of the DeleteBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotVersionResponse> deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBotVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBotVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotVersionRequest, DeleteBotVersionResponse>()
                            .withOperationName("DeleteBotVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBotVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBotVersionRequest));
            CompletableFuture<DeleteBotVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all versions of the intent, including the <code>&#36LATEST</code> version. To delete a specific version
     * of the intent, use the <a>DeleteIntentVersion</a> operation.
     * </p>
     * <p>
     * You can delete a version of an intent only if it is not referenced. To delete an intent that is referred to in
     * one or more bots (see <a>how-it-works</a>), you must remove those references first.
     * </p>
     * <note>
     * <p>
     * If you get the <code>ResourceInUseException</code> exception, it provides an example reference that shows where
     * the intent is referenced. To remove the reference to the intent, either update the bot or delete it. If you get
     * the same exception when you attempt to delete the intent again, repeat until the intent has no references and the
     * call to <code>DeleteIntent</code> is successful.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code>lex:DeleteIntent</code> action.
     * </p>
     *
     * @param deleteIntentRequest
     * @return A Java Future containing the result of the DeleteIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIntentResponse> deleteIntent(DeleteIntentRequest deleteIntentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntentRequest, DeleteIntentResponse>()
                            .withOperationName("DeleteIntent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIntentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIntentRequest));
            CompletableFuture<DeleteIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific version of an intent. To delete all versions of a intent, use the <a>DeleteIntent</a>
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteIntentVersion</code> action.
     * </p>
     *
     * @param deleteIntentVersionRequest
     * @return A Java Future containing the result of the DeleteIntentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteIntentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIntentVersionResponse> deleteIntentVersion(
            DeleteIntentVersionRequest deleteIntentVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIntentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIntentVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIntentVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntentVersionRequest, DeleteIntentVersionResponse>()
                            .withOperationName("DeleteIntentVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIntentVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIntentVersionRequest));
            CompletableFuture<DeleteIntentVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all versions of the slot type, including the <code>&#36LATEST</code> version. To delete a specific
     * version of the slot type, use the <a>DeleteSlotTypeVersion</a> operation.
     * </p>
     * <p>
     * You can delete a version of a slot type only if it is not referenced. To delete a slot type that is referred to
     * in one or more intents, you must remove those references first.
     * </p>
     * <note>
     * <p>
     * If you get the <code>ResourceInUseException</code> exception, the exception provides an example reference that
     * shows the intent where the slot type is referenced. To remove the reference to the slot type, either update the
     * intent or delete it. If you get the same exception when you attempt to delete the slot type again, repeat until
     * the slot type has no references and the <code>DeleteSlotType</code> call is successful.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code>lex:DeleteSlotType</code> action.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return A Java Future containing the result of the DeleteSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSlotTypeResponse> deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSlotTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlotType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSlotTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSlotTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSlotTypeRequest, DeleteSlotTypeResponse>()
                            .withOperationName("DeleteSlotType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSlotTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSlotTypeRequest));
            CompletableFuture<DeleteSlotTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific version of a slot type. To delete all versions of a slot type, use the <a>DeleteSlotType</a>
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteSlotTypeVersion</code> action.
     * </p>
     *
     * @param deleteSlotTypeVersionRequest
     * @return A Java Future containing the result of the DeleteSlotTypeVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteSlotTypeVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotTypeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSlotTypeVersionResponse> deleteSlotTypeVersion(
            DeleteSlotTypeVersionRequest deleteSlotTypeVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSlotTypeVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotTypeVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlotTypeVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSlotTypeVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSlotTypeVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSlotTypeVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSlotTypeVersionRequest, DeleteSlotTypeVersionResponse>()
                            .withOperationName("DeleteSlotTypeVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSlotTypeVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSlotTypeVersionRequest));
            CompletableFuture<DeleteSlotTypeVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the
     * <a>GetUtterancesView</a> operation, and then stored indefinitely for use in improving the ability of your bot to
     * respond to user input.
     * </p>
     * <p>
     * Use the <code>DeleteUtterances</code> operation to manually delete stored utterances for a specific user. When
     * you use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to
     * respond to user input are deleted immediately. Utterances stored for use with the <code>GetUtterancesView</code>
     * operation are deleted after 15 days.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteUtterances</code> action.
     * </p>
     *
     * @param deleteUtterancesRequest
     * @return A Java Future containing the result of the DeleteUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUtterancesResponse> deleteUtterances(DeleteUtterancesRequest deleteUtterancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUtterancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUtterancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUtterances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUtterancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUtterancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUtterancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUtterancesRequest, DeleteUtterancesResponse>()
                            .withOperationName("DeleteUtterances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUtterancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUtterancesRequest));
            CompletableFuture<DeleteUtterancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata information for a specific bot. You must provide the bot name and the bot version or alias.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBot</code> action.
     * </p>
     *
     * @param getBotRequest
     * @return A Java Future containing the result of the GetBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotResponse> getBot(GetBotRequest getBotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBotRequest, GetBotResponse>().withOperationName("GetBot")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetBotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBotRequest));
            CompletableFuture<GetBotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an Amazon Lex bot alias. For more information about aliases, see
     * <a>versioning-aliases</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotAlias</code> action.
     * </p>
     *
     * @param getBotAliasRequest
     * @return A Java Future containing the result of the GetBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotAliasResponse> getBotAlias(GetBotAliasRequest getBotAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBotAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBotAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBotAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBotAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBotAliasRequest, GetBotAliasResponse>()
                            .withOperationName("GetBotAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBotAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBotAliasRequest));
            CompletableFuture<GetBotAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of aliases for a specified Amazon Lex bot.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotAliases</code> action.
     * </p>
     *
     * @param getBotAliasesRequest
     * @return A Java Future containing the result of the GetBotAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotAliasesResponse> getBotAliases(GetBotAliasesRequest getBotAliasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBotAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBotAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBotAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBotAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBotAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBotAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBotAliasesRequest, GetBotAliasesResponse>()
                            .withOperationName("GetBotAliases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBotAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBotAliasesRequest));
            CompletableFuture<GetBotAliasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the association between an Amazon Lex bot and a messaging platform.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotChannelAssociation</code> action.
     * </p>
     *
     * @param getBotChannelAssociationRequest
     * @return A Java Future containing the result of the GetBotChannelAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotChannelAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotChannelAssociationResponse> getBotChannelAssociation(
            GetBotChannelAssociationRequest getBotChannelAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBotChannelAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBotChannelAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBotChannelAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBotChannelAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBotChannelAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBotChannelAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBotChannelAssociationRequest, GetBotChannelAssociationResponse>()
                            .withOperationName("GetBotChannelAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBotChannelAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBotChannelAssociationRequest));
            CompletableFuture<GetBotChannelAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all of the channels associated with the specified bot.
     * </p>
     * <p>
     * The <code>GetBotChannelAssociations</code> operation requires permissions for the
     * <code>lex:GetBotChannelAssociations</code> action.
     * </p>
     *
     * @param getBotChannelAssociationsRequest
     * @return A Java Future containing the result of the GetBotChannelAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotChannelAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotChannelAssociationsResponse> getBotChannelAssociations(
            GetBotChannelAssociationsRequest getBotChannelAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBotChannelAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBotChannelAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBotChannelAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBotChannelAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBotChannelAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBotChannelAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBotChannelAssociationsRequest, GetBotChannelAssociationsResponse>()
                            .withOperationName("GetBotChannelAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBotChannelAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBotChannelAssociationsRequest));
            CompletableFuture<GetBotChannelAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation returns a <code>BotMetadata</code> object for each version of a bot.
     * For example, if a bot has three numbered versions, the <code>GetBotVersions</code> operation returns four
     * <code>BotMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotVersions</code> action.
     * </p>
     *
     * @param getBotVersionsRequest
     * @return A Java Future containing the result of the GetBotVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotVersionsResponse> getBotVersions(GetBotVersionsRequest getBotVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBotVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBotVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBotVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBotVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBotVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBotVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBotVersionsRequest, GetBotVersionsResponse>()
                            .withOperationName("GetBotVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBotVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBotVersionsRequest));
            CompletableFuture<GetBotVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns bot information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you provide the <code>nameContains</code> field, the response includes information for the
     * <code>&#36LATEST</code> version of all bots whose name contains the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, the operation returns information about the
     * <code>&#36LATEST</code> version of all of your bots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires permission for the <code>lex:GetBots</code> action.
     * </p>
     *
     * @param getBotsRequest
     * @return A Java Future containing the result of the GetBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotsResponse> getBots(GetBotsRequest getBotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBotsRequest, GetBotsResponse>().withOperationName("GetBots")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetBotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBotsRequest));
            CompletableFuture<GetBotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a built-in intent.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltinIntent</code> action.
     * </p>
     *
     * @param getBuiltinIntentRequest
     * @return A Java Future containing the result of the GetBuiltinIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBuiltinIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBuiltinIntentResponse> getBuiltinIntent(GetBuiltinIntentRequest getBuiltinIntentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBuiltinIntentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBuiltinIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBuiltinIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBuiltinIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBuiltinIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBuiltinIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBuiltinIntentRequest, GetBuiltinIntentResponse>()
                            .withOperationName("GetBuiltinIntent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBuiltinIntentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBuiltinIntentRequest));
            CompletableFuture<GetBuiltinIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of built-in intents that meet the specified criteria.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltinIntents</code> action.
     * </p>
     *
     * @param getBuiltinIntentsRequest
     * @return A Java Future containing the result of the GetBuiltinIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBuiltinIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBuiltinIntentsResponse> getBuiltinIntents(GetBuiltinIntentsRequest getBuiltinIntentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBuiltinIntentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBuiltinIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBuiltinIntents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBuiltinIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBuiltinIntentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBuiltinIntentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBuiltinIntentsRequest, GetBuiltinIntentsResponse>()
                            .withOperationName("GetBuiltinIntents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBuiltinIntentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBuiltinIntentsRequest));
            CompletableFuture<GetBuiltinIntentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <p>
     * For a list of built-in slot types, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltInSlotTypes</code> action.
     * </p>
     *
     * @param getBuiltinSlotTypesRequest
     * @return A Java Future containing the result of the GetBuiltinSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBuiltinSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBuiltinSlotTypesResponse> getBuiltinSlotTypes(
            GetBuiltinSlotTypesRequest getBuiltinSlotTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBuiltinSlotTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBuiltinSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBuiltinSlotTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBuiltinSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBuiltinSlotTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBuiltinSlotTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBuiltinSlotTypesRequest, GetBuiltinSlotTypesResponse>()
                            .withOperationName("GetBuiltinSlotTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBuiltinSlotTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBuiltinSlotTypesRequest));
            CompletableFuture<GetBuiltinSlotTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Exports the contents of a Amazon Lex resource in a specified format.
     * </p>
     *
     * @param getExportRequest
     * @return A Java Future containing the result of the GetExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetExport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportResponse> getExport(GetExportRequest getExportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportRequest, GetExportResponse>().withOperationName("GetExport")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetExportRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getExportRequest));
            CompletableFuture<GetExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an import job started with the <code>StartImport</code> operation.
     * </p>
     *
     * @param getImportRequest
     * @return A Java Future containing the result of the GetImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportResponse> getImport(GetImportRequest getImportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportRequest, GetImportResponse>().withOperationName("GetImport")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImportRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImportRequest));
            CompletableFuture<GetImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an intent. In addition to the intent name, you must specify the intent version.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lex:GetIntent</code> action.
     * </p>
     *
     * @param getIntentRequest
     * @return A Java Future containing the result of the GetIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetIntentResponse> getIntent(GetIntentRequest getIntentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIntentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIntentRequest, GetIntentResponse>().withOperationName("GetIntent")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIntentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getIntentRequest));
            CompletableFuture<GetIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about all of the versions of an intent.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation returns an <code>IntentMetadata</code> object for each version of an
     * intent. For example, if an intent has three numbered versions, the <code>GetIntentVersions</code> operation
     * returns four <code>IntentMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetIntentVersions</code> action.
     * </p>
     *
     * @param getIntentVersionsRequest
     * @return A Java Future containing the result of the GetIntentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetIntentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIntentVersionsResponse> getIntentVersions(GetIntentVersionsRequest getIntentVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIntentVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIntentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIntentVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIntentVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIntentVersionsRequest, GetIntentVersionsResponse>()
                            .withOperationName("GetIntentVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIntentVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIntentVersionsRequest));
            CompletableFuture<GetIntentVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns intent information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all intents
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all intents.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetIntents</code> action.
     * </p>
     *
     * @param getIntentsRequest
     * @return A Java Future containing the result of the GetIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetIntentsResponse> getIntents(GetIntentsRequest getIntentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIntentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIntentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetIntentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIntentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIntentsRequest, GetIntentsResponse>().withOperationName("GetIntents")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIntentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIntentsRequest));
            CompletableFuture<GetIntentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides details about an ongoing or complete migration from an Amazon Lex V1 bot to an Amazon Lex V2 bot. Use
     * this operation to view the migration alerts and warnings related to the migration.
     * </p>
     *
     * @param getMigrationRequest
     * @return A Java Future containing the result of the GetMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetMigration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMigrationResponse> getMigration(GetMigrationRequest getMigrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMigrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMigration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMigrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMigrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMigrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMigrationRequest, GetMigrationResponse>()
                            .withOperationName("GetMigration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMigrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMigrationRequest));
            CompletableFuture<GetMigrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of migrations between Amazon Lex V1 and Amazon Lex V2.
     * </p>
     *
     * @param getMigrationsRequest
     * @return A Java Future containing the result of the GetMigrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetMigrations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMigrationsResponse> getMigrations(GetMigrationsRequest getMigrationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMigrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMigrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMigrations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMigrationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMigrationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMigrationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMigrationsRequest, GetMigrationsResponse>()
                            .withOperationName("GetMigrations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMigrationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMigrationsRequest));
            CompletableFuture<GetMigrationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific version of a slot type. In addition to specifying the slot type name, you
     * must specify the slot type version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetSlotType</code> action.
     * </p>
     *
     * @param getSlotTypeRequest
     * @return A Java Future containing the result of the GetSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSlotTypeResponse> getSlotType(GetSlotTypeRequest getSlotTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSlotTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSlotType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSlotTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSlotTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSlotTypeRequest, GetSlotTypeResponse>()
                            .withOperationName("GetSlotType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSlotTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSlotTypeRequest));
            CompletableFuture<GetSlotTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about all versions of a slot type.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation returns a <code>SlotTypeMetadata</code> object for each version of
     * a slot type. For example, if a slot type has three numbered versions, the <code>GetSlotTypeVersions</code>
     * operation returns four <code>SlotTypeMetadata</code> objects in the response, one for each numbered version and
     * one for the <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetSlotTypeVersions</code> action.
     * </p>
     *
     * @param getSlotTypeVersionsRequest
     * @return A Java Future containing the result of the GetSlotTypeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetSlotTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSlotTypeVersionsResponse> getSlotTypeVersions(
            GetSlotTypeVersionsRequest getSlotTypeVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSlotTypeVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSlotTypeVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSlotTypeVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSlotTypeVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSlotTypeVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSlotTypeVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSlotTypeVersionsRequest, GetSlotTypeVersionsResponse>()
                            .withOperationName("GetSlotTypeVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSlotTypeVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSlotTypeVersionsRequest));
            CompletableFuture<GetSlotTypeVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns slot type information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all slot types
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetSlotTypes</code> action.
     * </p>
     *
     * @param getSlotTypesRequest
     * @return A Java Future containing the result of the GetSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSlotTypesResponse> getSlotTypes(GetSlotTypesRequest getSlotTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSlotTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSlotTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSlotTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSlotTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSlotTypesRequest, GetSlotTypesResponse>()
                            .withOperationName("GetSlotTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSlotTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSlotTypesRequest));
            CompletableFuture<GetSlotTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>GetUtterancesView</code> operation to get information about the utterances that your users have
     * made to your bot. You can use this list to tune the utterances that your bot responds to.
     * </p>
     * <p>
     * For example, say that you have created a bot to order flowers. After your users have used your bot for a while,
     * use the <code>GetUtterancesView</code> operation to see the requests that they have made and whether they have
     * been successful. You might find that the utterance "I want flowers" is not being recognized. You could add this
     * utterance to the <code>OrderFlowers</code> intent so that your bot recognizes that utterance.
     * </p>
     * <p>
     * After you publish a new version of a bot, you can get information about the old version and the new so that you
     * can compare the performance across the two versions.
     * </p>
     * <p>
     * Utterance statistics are generated once a day. Data is available for the last 15 days. You can request
     * information for up to 5 versions of your bot in each request. Amazon Lex returns the most frequent utterances
     * received by the bot in the last 15 days. The response contains information about a maximum of 100 utterances for
     * each version.
     * </p>
     * <p>
     * If you set <code>childDirected</code> field to true when you created your bot, if you are using slot obfuscation
     * with one or more slots, or if you opted out of participating in improving Amazon Lex, utterances are not
     * available.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetUtterancesView</code> action.
     * </p>
     *
     * @param getUtterancesViewRequest
     * @return A Java Future containing the result of the GetUtterancesView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetUtterancesView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesView" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUtterancesViewResponse> getUtterancesView(GetUtterancesViewRequest getUtterancesViewRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUtterancesViewRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUtterancesViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUtterancesView");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUtterancesViewResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUtterancesViewResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUtterancesViewResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUtterancesViewRequest, GetUtterancesViewResponse>()
                            .withOperationName("GetUtterancesView").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUtterancesViewRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUtterancesViewRequest));
            CompletableFuture<GetUtterancesViewResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of tags associated with the specified resource. Only bots, bot aliases, and bot channels can have
     * tags associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or update a bot you are
     * only required to specify a name, a locale, and whether the bot is directed toward children under age 13. You can
     * use this to add intents later, or to remove intents from an existing bot. When you create a bot with the minimum
     * information, the bot is created or updated but Amazon Lex returns the <code/> response <code>FAILED</code>. You
     * can build the bot after you add one or more intents. For more information about Amazon Lex bots, see
     * <a>how-it-works</a>.
     * </p>
     * <p>
     * If you specify the name of an existing bot, the fields in the request replace the existing values in the
     * <code>&#36LATEST</code> version of the bot. Amazon Lex removes any fields that you don't provide values for in
     * the request, except for the <code>idleTTLInSeconds</code> and <code>privacySettings</code> fields, which are set
     * to their default values. If you don't specify values for required fields, Amazon Lex throws an exception.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutBot</code> action. For more information, see
     * <a>security-iam</a>.
     * </p>
     *
     * @param putBotRequest
     * @return A Java Future containing the result of the PutBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutBotResponse> putBot(PutBotRequest putBotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutBotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutBotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBotRequest, PutBotResponse>().withOperationName("PutBot")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new PutBotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putBotRequest));
            CompletableFuture<PutBotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an alias for the specified version of the bot or replaces an alias for the specified bot. To change the
     * version of the bot that the alias points to, replace the alias. For more information about aliases, see
     * <a>versioning-aliases</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutBotAlias</code> action.
     * </p>
     *
     * @param putBotAliasRequest
     * @return A Java Future containing the result of the PutBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutBotAliasResponse> putBotAlias(PutBotAliasRequest putBotAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBotAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBotAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutBotAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutBotAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBotAliasRequest, PutBotAliasResponse>()
                            .withOperationName("PutBotAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBotAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putBotAliasRequest));
            CompletableFuture<PutBotAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an intent or replaces an existing intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you use one or more intents. For a pizza ordering bot,
     * for example, you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * To create an intent or replace an existing intent, you must provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Intent name. For example, <code>OrderPizza</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sample utterances. For example, "Can I order a pizza, please." and "I want to order a pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slot types for the information that your bot will request from the user.
     * You can specify standard slot types, such as a date or a time, or custom slot types such as the size and crust of
     * a pizza.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent will be fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to the client application. If you use a Lambda function, when all of the intent information is
     * available, Amazon Lex invokes your Lambda function. If you configure your intent to return the intent information
     * to the client application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify other optional information in the request, such as:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A confirmation prompt to ask the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent has been fulfilled. For example,
     * "I placed your pizza order."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example, asking
     * "Do you want to order a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify an existing intent name to update the intent, Amazon Lex replaces the values in the
     * <code>&#36LATEST</code> version of the intent with the values in the request. Amazon Lex removes fields that you
     * don't provide in the request. If you don't specify the required fields, Amazon Lex throws an exception. When you
     * update the <code>&#36LATEST</code> version of an intent, the <code>status</code> field of any bot that uses the
     * <code>&#36LATEST</code> version of the intent is set to <code>NOT_BUILT</code>.
     * </p>
     * <p>
     * For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutIntent</code> action.
     * </p>
     *
     * @param putIntentRequest
     * @return A Java Future containing the result of the PutIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutIntentResponse> putIntent(PutIntentRequest putIntentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putIntentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutIntentRequest, PutIntentResponse>().withOperationName("PutIntent")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutIntentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(putIntentRequest));
            CompletableFuture<PutIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom slot type or replaces an existing custom slot type.
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, which are the
     * values that a slot of this type can assume. For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * If you specify the name of an existing slot type, the fields in the request replace the existing values in the
     * <code>&#36LATEST</code> version of the slot type. Amazon Lex removes the fields that you don't provide in the
     * request. If you don't specify required fields, Amazon Lex throws an exception. When you update the
     * <code>&#36LATEST</code> version of a slot type, if a bot uses the <code>&#36LATEST</code> version of an intent
     * that contains the slot type, the bot's <code>status</code> field is set to <code>NOT_BUILT</code>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutSlotType</code> action.
     * </p>
     *
     * @param putSlotTypeRequest
     * @return A Java Future containing the result of the PutSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutSlotTypeResponse> putSlotType(PutSlotTypeRequest putSlotTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putSlotTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSlotType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutSlotTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutSlotTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutSlotTypeRequest, PutSlotTypeResponse>()
                            .withOperationName("PutSlotType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutSlotTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putSlotTypeRequest));
            CompletableFuture<PutSlotTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a job to import a resource to Amazon Lex.
     * </p>
     *
     * @param startImportRequest
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartImportResponse> startImport(StartImportRequest startImportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartImportRequest, StartImportResponse>()
                            .withOperationName("StartImport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartImportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startImportRequest));
            CompletableFuture<StartImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2. Migrate your bot when you want to take advantage of
     * the new features of Amazon Lex V2.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/migrate.html">Migrating a bot</a> in
     * the <i>Amazon Lex developer guide</i>.
     * </p>
     *
     * @param startMigrationRequest
     * @return A Java Future containing the result of the StartMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>AccessDeniedException Your IAM user or role does not have permission to call the Amazon Lex V2 APIs
     *         required to migrate your bot.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.StartMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/StartMigration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartMigrationResponse> startMigration(StartMigrationRequest startMigrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMigrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMigration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMigrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMigrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMigrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMigrationRequest, StartMigrationResponse>()
                            .withOperationName("StartMigration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMigrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMigrationRequest));
            CompletableFuture<StartMigrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Model Building Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final LexModelBuildingServiceClientConfiguration serviceClientConfiguration() {
        return new LexModelBuildingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LexModelBuildingException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        LexModelBuildingServiceClientConfigurationBuilder serviceConfigBuilder = new LexModelBuildingServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
