/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SlotValueSelectionStrategy {
    ORIGINAL_VALUE("ORIGINAL_VALUE"),
    TOP_RESOLUTION("TOP_RESOLUTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SlotValueSelectionStrategy> VALUE_MAP;
    private final String value;

    private SlotValueSelectionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SlotValueSelectionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SlotValueSelectionStrategy> knownValues() {
        EnumSet<SlotValueSelectionStrategy> knownValues = EnumSet.allOf(SlotValueSelectionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SlotValueSelectionStrategy.class, SlotValueSelectionStrategy::toString);
    }
}

