/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationSummary;
import software.amazon.awssdk.services.lexmodelbuilding.model.MigrationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMigrationsResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetMigrationsResponse> {
    private static final SdkField<List<MigrationSummary>> MIGRATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("migrationSummaries").getter(GetMigrationsResponse.getter(GetMigrationsResponse::migrationSummaries)).setter(GetMigrationsResponse.setter(Builder::migrationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MigrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetMigrationsResponse.getter(GetMigrationsResponse::nextToken)).setter(GetMigrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("migrationSummaries", MIGRATION_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MigrationSummary> migrationSummaries;
    private final String nextToken;

    private GetMigrationsResponse(BuilderImpl builder) {
        super(builder);
        this.migrationSummaries = builder.migrationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMigrationSummaries() {
        return this.migrationSummaries != null && !(this.migrationSummaries instanceof SdkAutoConstructList);
    }

    public final List<MigrationSummary> migrationSummaries() {
        return this.migrationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMigrationSummaries() ? this.migrationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMigrationsResponse)) {
            return false;
        }
        GetMigrationsResponse other = (GetMigrationsResponse)((Object)obj);
        return this.hasMigrationSummaries() == other.hasMigrationSummaries() && Objects.equals(this.migrationSummaries(), other.migrationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetMigrationsResponse").add("MigrationSummaries", this.hasMigrationSummaries() ? this.migrationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "migrationSummaries": {
                return Optional.ofNullable(clazz.cast(this.migrationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMigrationsResponse, T> g) {
        return obj -> g.apply((GetMigrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<MigrationSummary> migrationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMigrationsResponse model) {
            super(model);
            this.migrationSummaries(model.migrationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<MigrationSummary.Builder> getMigrationSummaries() {
            List<MigrationSummary.Builder> result = MigrationSummaryListCopier.copyToBuilder(this.migrationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMigrationSummaries(Collection<MigrationSummary.BuilderImpl> migrationSummaries) {
            this.migrationSummaries = MigrationSummaryListCopier.copyFromBuilder(migrationSummaries);
        }

        @Override
        public final Builder migrationSummaries(Collection<MigrationSummary> migrationSummaries) {
            this.migrationSummaries = MigrationSummaryListCopier.copy(migrationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationSummaries(MigrationSummary ... migrationSummaries) {
            this.migrationSummaries(Arrays.asList(migrationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationSummaries(Consumer<MigrationSummary.Builder> ... migrationSummaries) {
            this.migrationSummaries(Stream.of(migrationSummaries).map(c -> (MigrationSummary)((MigrationSummary.Builder)MigrationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetMigrationsResponse build() {
            return new GetMigrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMigrationsResponse> {
        public Builder migrationSummaries(Collection<MigrationSummary> var1);

        public Builder migrationSummaries(MigrationSummary ... var1);

        public Builder migrationSummaries(Consumer<MigrationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

