/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each slot type can have a set of values. Each enumeration value represents a value the slot type can take.
 * </p>
 * <p>
 * For example, a pizza ordering bot could have a slot type that specifies the type of crust that the pizza should have.
 * The slot type could include the values
 * </p>
 * <ul>
 * <li>
 * <p>
 * thick
 * </p>
 * </li>
 * <li>
 * <p>
 * thin
 * </p>
 * </li>
 * <li>
 * <p>
 * stuffed
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnumerationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<EnumerationValue.Builder, EnumerationValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnumerationValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<String>> SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EnumerationValue::synonyms))
            .setter(setter(Builder::synonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("synonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, SYNONYMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private final List<String> synonyms;

    private EnumerationValue(BuilderImpl builder) {
        this.value = builder.value;
        this.synonyms = builder.synonyms;
    }

    /**
     * <p>
     * The value of the slot type.
     * </p>
     * 
     * @return The value of the slot type.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * Additional values related to the slot type value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional values related to the slot type value.
     */
    public List<String> synonyms() {
        return synonyms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(synonyms());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumerationValue)) {
            return false;
        }
        EnumerationValue other = (EnumerationValue) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(synonyms(), other.synonyms());
    }

    @Override
    public String toString() {
        return ToString.builder("EnumerationValue").add("Value", value()).add("Synonyms", synonyms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "synonyms":
            return Optional.ofNullable(clazz.cast(synonyms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnumerationValue, T> g) {
        return obj -> g.apply((EnumerationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnumerationValue> {
        /**
         * <p>
         * The value of the slot type.
         * </p>
         * 
         * @param value
         *        The value of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Additional values related to the slot type value.
         * </p>
         * 
         * @param synonyms
         *        Additional values related to the slot type value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonyms(Collection<String> synonyms);

        /**
         * <p>
         * Additional values related to the slot type value.
         * </p>
         * 
         * @param synonyms
         *        Additional values related to the slot type value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonyms(String... synonyms);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private List<String> synonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnumerationValue model) {
            value(model.value);
            synonyms(model.synonyms);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Collection<String> getSynonyms() {
            return synonyms;
        }

        @Override
        public final Builder synonyms(Collection<String> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synonyms(String... synonyms) {
            synonyms(Arrays.asList(synonyms));
            return this;
        }

        public final void setSynonyms(Collection<String> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
        }

        @Override
        public EnumerationValue build() {
            return new EnumerationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
