/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesResponse;

public class GetBotAliasesPublisher
implements SdkPublisher<GetBotAliasesResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetBotAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBotAliasesPublisher(LexModelBuildingAsyncClient client, GetBotAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBotAliasesPublisher(LexModelBuildingAsyncClient client, GetBotAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBotAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBotAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetBotAliasesPublisher resume(GetBotAliasesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBotAliasesPublisher(this.client, (GetBotAliasesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBotAliasesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetBotAliasesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetBotAliasesResponseFetcher
    implements AsyncPageFetcher<GetBotAliasesResponse> {
        private GetBotAliasesResponseFetcher() {
        }

        public boolean hasNextPage(GetBotAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBotAliasesResponse> nextPage(GetBotAliasesResponse previousPage) {
            if (previousPage == null) {
                return GetBotAliasesPublisher.this.client.getBotAliases(GetBotAliasesPublisher.this.firstRequest);
            }
            return GetBotAliasesPublisher.this.client.getBotAliases((GetBotAliasesRequest)((Object)GetBotAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

