/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBuiltinIntentResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBuiltinIntentResponse.Builder, GetBuiltinIntentResponse> {
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBuiltinIntentResponse::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()).build();

    private static final SdkField<List<String>> SUPPORTED_LOCALES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetBuiltinIntentResponse::supportedLocalesAsStrings))
            .setter(setter(Builder::supportedLocalesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedLocales").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BuiltinIntentSlot>> SLOTS_FIELD = SdkField
            .<List<BuiltinIntentSlot>> builder(MarshallingType.LIST)
            .getter(getter(GetBuiltinIntentResponse::slots))
            .setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuiltinIntentSlot> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuiltinIntentSlot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_FIELD,
            SUPPORTED_LOCALES_FIELD, SLOTS_FIELD));

    private final String signature;

    private final List<String> supportedLocales;

    private final List<BuiltinIntentSlot> slots;

    private GetBuiltinIntentResponse(BuilderImpl builder) {
        super(builder);
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
        this.slots = builder.slots;
    }

    /**
     * <p>
     * The unique identifier for a built-in intent.
     * </p>
     * 
     * @return The unique identifier for a built-in intent.
     */
    public String signature() {
        return signature;
    }

    /**
     * <p>
     * A list of locales that the intent supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of locales that the intent supports.
     */
    public List<Locale> supportedLocales() {
        return TypeConverter.convert(supportedLocales, Locale::fromValue);
    }

    /**
     * <p>
     * A list of locales that the intent supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of locales that the intent supports.
     */
    public List<String> supportedLocalesAsStrings() {
        return supportedLocales;
    }

    /**
     * <p>
     * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
     */
    public List<BuiltinIntentSlot> slots() {
        return slots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        hashCode = 31 * hashCode + Objects.hashCode(supportedLocalesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(slots());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentResponse)) {
            return false;
        }
        GetBuiltinIntentResponse other = (GetBuiltinIntentResponse) obj;
        return Objects.equals(signature(), other.signature())
                && Objects.equals(supportedLocalesAsStrings(), other.supportedLocalesAsStrings())
                && Objects.equals(slots(), other.slots());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBuiltinIntentResponse").add("Signature", signature())
                .add("SupportedLocales", supportedLocalesAsStrings()).add("Slots", slots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signature":
            return Optional.ofNullable(clazz.cast(signature()));
        case "supportedLocales":
            return Optional.ofNullable(clazz.cast(supportedLocalesAsStrings()));
        case "slots":
            return Optional.ofNullable(clazz.cast(slots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBuiltinIntentResponse, T> g) {
        return obj -> g.apply((GetBuiltinIntentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBuiltinIntentResponse> {
        /**
         * <p>
         * The unique identifier for a built-in intent.
         * </p>
         * 
         * @param signature
         *        The unique identifier for a built-in intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocalesWithStrings(Collection<String> supportedLocales);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocalesWithStrings(String... supportedLocales);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(Collection<Locale> supportedLocales);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(Locale... supportedLocales);

        /**
         * <p>
         * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * </p>
         * 
         * @param slots
         *        An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<BuiltinIntentSlot> slots);

        /**
         * <p>
         * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * </p>
         * 
         * @param slots
         *        An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(BuiltinIntentSlot... slots);

        /**
         * <p>
         * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BuiltinIntentSlot>.Builder} avoiding the
         * need to create one manually via {@link List<BuiltinIntentSlot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BuiltinIntentSlot>.Builder#build()} is called immediately
         * and its result is passed to {@link #slots(List<BuiltinIntentSlot>)}.
         * 
         * @param slots
         *        a consumer that will call methods on {@link List<BuiltinIntentSlot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slots(List<BuiltinIntentSlot>)
         */
        Builder slots(Consumer<BuiltinIntentSlot.Builder>... slots);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String signature;

        private List<String> supportedLocales = DefaultSdkAutoConstructList.getInstance();

        private List<BuiltinIntentSlot> slots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentResponse model) {
            super(model);
            signature(model.signature);
            supportedLocalesWithStrings(model.supportedLocales);
            slots(model.slots);
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocalesAsStrings() {
            return supportedLocales;
        }

        @Override
        public final Builder supportedLocalesWithStrings(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocalesWithStrings(String... supportedLocales) {
            supportedLocalesWithStrings(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        public final Builder supportedLocales(Collection<Locale> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copyEnumToString(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale... supportedLocales) {
            supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        public final void setSupportedLocalesWithStrings(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        public final Collection<BuiltinIntentSlot.Builder> getSlots() {
            return slots != null ? slots.stream().map(BuiltinIntentSlot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(BuiltinIntentSlot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<BuiltinIntentSlot.Builder>... slots) {
            slots(Stream.of(slots).map(c -> BuiltinIntentSlot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlots(Collection<BuiltinIntentSlot.BuilderImpl> slots) {
            this.slots = BuiltinIntentSlotListCopier.copyFromBuilder(slots);
        }

        @Override
        public GetBuiltinIntentResponse build() {
            return new GetBuiltinIntentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
