/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBuiltinSlotTypesRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetBuiltinSlotTypesRequest.Builder, GetBuiltinSlotTypesRequest> {
    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBuiltinSlotTypesRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()).build();

    private static final SdkField<String> SIGNATURE_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBuiltinSlotTypesRequest::signatureContains)).setter(setter(Builder::signatureContains))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("signatureContains").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBuiltinSlotTypesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetBuiltinSlotTypesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_FIELD,
            SIGNATURE_CONTAINS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String locale;

    private final String signatureContains;

    private final String nextToken;

    private final Integer maxResults;

    private GetBuiltinSlotTypesRequest(BuilderImpl builder) {
        super(builder);
        this.locale = builder.locale;
        this.signatureContains = builder.signatureContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * A list of locales that the slot type supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return A list of locales that the slot type supports.
     * @see Locale
     */
    public Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * A list of locales that the slot type supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return A list of locales that the slot type supports.
     * @see Locale
     */
    public String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature
     * matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     * </p>
     * 
     * @return Substring to match in built-in slot type signatures. A slot type will be returned if any part of its
     *         signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     */
    public String signatureContains() {
        return signatureContains;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the
     * pagination token in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of slot types. If the response to this API call is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types,
     *         specify the pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of slot types to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of slot types to return in the response. The default is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signatureContains());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinSlotTypesRequest)) {
            return false;
        }
        GetBuiltinSlotTypesRequest other = (GetBuiltinSlotTypesRequest) obj;
        return Objects.equals(localeAsString(), other.localeAsString())
                && Objects.equals(signatureContains(), other.signatureContains())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBuiltinSlotTypesRequest").add("Locale", localeAsString())
                .add("SignatureContains", signatureContains()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "signatureContains":
            return Optional.ofNullable(clazz.cast(signatureContains()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBuiltinSlotTypesRequest, T> g) {
        return obj -> g.apply((GetBuiltinSlotTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBuiltinSlotTypesRequest> {
        /**
         * <p>
         * A list of locales that the slot type supports.
         * </p>
         * 
         * @param locale
         *        A list of locales that the slot type supports.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * A list of locales that the slot type supports.
         * </p>
         * 
         * @param locale
         *        A list of locales that the slot type supports.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * Substring to match in built-in slot type signatures. A slot type will be returned if any part of its
         * signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * </p>
         * 
         * @param signatureContains
         *        Substring to match in built-in slot type signatures. A slot type will be returned if any part of its
         *        signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureContains(String signatureContains);

        /**
         * <p>
         * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of slot types. If the response to this API call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot
         *        types, specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of slot types to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of slot types to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String locale;

        private String signatureContains;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinSlotTypesRequest model) {
            super(model);
            locale(model.locale);
            signatureContains(model.signatureContains);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getLocaleAsString() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getSignatureContains() {
            return signatureContains;
        }

        @Override
        public final Builder signatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
            return this;
        }

        public final void setSignatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBuiltinSlotTypesRequest build() {
            return new GetBuiltinSlotTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
