/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse;

public class GetSlotTypesPublisher
implements SdkPublisher<GetSlotTypesResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetSlotTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSlotTypesPublisher(LexModelBuildingAsyncClient client, GetSlotTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSlotTypesPublisher(LexModelBuildingAsyncClient client, GetSlotTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSlotTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSlotTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetSlotTypesPublisher resume(GetSlotTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetSlotTypesPublisher(this.client, (GetSlotTypesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetSlotTypesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetSlotTypesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetSlotTypesResponseFetcher
    implements AsyncPageFetcher<GetSlotTypesResponse> {
        private GetSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSlotTypesResponse> nextPage(GetSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypesPublisher.this.client.getSlotTypes(GetSlotTypesPublisher.this.firstRequest);
            }
            return GetSlotTypesPublisher.this.client.getSlotTypes((GetSlotTypesRequest)((Object)GetSlotTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

