/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.ImportStatus;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.MergeStrategy;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, StartImportResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartImportResponse.getter(StartImportResponse::name)).setter(StartImportResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartImportResponse.getter(StartImportResponse::resourceTypeAsString)).setter(StartImportResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartImportResponse.getter(StartImportResponse::mergeStrategyAsString)).setter(StartImportResponse.setter(Builder::mergeStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()}).build();
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartImportResponse.getter(StartImportResponse::importId)).setter(StartImportResponse.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartImportResponse.getter(StartImportResponse::importStatusAsString)).setter(StartImportResponse.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StartImportResponse.getter(StartImportResponse::createdDate)).setter(StartImportResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RESOURCE_TYPE_FIELD, MERGE_STRATEGY_FIELD, IMPORT_ID_FIELD, IMPORT_STATUS_FIELD, CREATED_DATE_FIELD));
    private final String name;
    private final String resourceType;
    private final String mergeStrategy;
    private final String importId;
    private final String importStatus;
    private final Instant createdDate;

    private StartImportResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourceType = builder.resourceType;
        this.mergeStrategy = builder.mergeStrategy;
        this.importId = builder.importId;
        this.importStatus = builder.importStatus;
        this.createdDate = builder.createdDate;
    }

    public String name() {
        return this.name;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(this.mergeStrategy);
    }

    public String mergeStrategyAsString() {
        return this.mergeStrategy;
    }

    public String importId() {
        return this.importId;
    }

    public ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public String importStatusAsString() {
        return this.importStatus;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportResponse)) {
            return false;
        }
        StartImportResponse other = (StartImportResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.mergeStrategyAsString(), other.mergeStrategyAsString()) && Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.createdDate(), other.createdDate());
    }

    public String toString() {
        return ToString.builder((String)"StartImportResponse").add("Name", (Object)this.name()).add("ResourceType", (Object)this.resourceTypeAsString()).add("MergeStrategy", (Object)this.mergeStrategyAsString()).add("ImportId", (Object)this.importId()).add("ImportStatus", (Object)this.importStatusAsString()).add("CreatedDate", (Object)this.createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "mergeStrategy": {
                return Optional.ofNullable(clazz.cast(this.mergeStrategyAsString()));
            }
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "importStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportResponse, T> g) {
        return obj -> g.apply((StartImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String name;
        private String resourceType;
        private String mergeStrategy;
        private String importId;
        private String importStatus;
        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportResponse model) {
            super(model);
            this.name(model.name);
            this.resourceType(model.resourceType);
            this.mergeStrategy(model.mergeStrategy);
            this.importId(model.importId);
            this.importStatus(model.importStatus);
            this.createdDate(model.createdDate);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getMergeStrategyAsString() {
            return this.mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy.toString());
            return this;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        public final String getImportId() {
            return this.importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        public final String getImportStatusAsString() {
            return this.importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus.toString());
            return this;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public StartImportResponse build() {
            return new StartImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportResponse> {
        public Builder name(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder mergeStrategy(String var1);

        public Builder mergeStrategy(MergeStrategy var1);

        public Builder importId(String var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder createdDate(Instant var1);
    }
}

