/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse;

public class GetBotsPublisher
implements SdkPublisher<GetBotsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetBotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBotsPublisher(LexModelBuildingAsyncClient client, GetBotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBotsPublisher(LexModelBuildingAsyncClient client, GetBotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetBotsPublisher resume(GetBotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBotsPublisher(this.client, (GetBotsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBotsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetBotsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetBotsResponseFetcher
    implements AsyncPageFetcher<GetBotsResponse> {
        private GetBotsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBotsResponse> nextPage(GetBotsResponse previousPage) {
            if (previousPage == null) {
                return GetBotsPublisher.this.client.getBots(GetBotsPublisher.this.firstRequest);
            }
            return GetBotsPublisher.this.client.getBots((GetBotsRequest)((Object)GetBotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

