/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse;

public class GetBuiltinSlotTypesIterable
implements SdkIterable<GetBuiltinSlotTypesResponse> {
    private final LexModelBuildingClient client;
    private final GetBuiltinSlotTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBuiltinSlotTypesIterable(LexModelBuildingClient client, GetBuiltinSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBuiltinSlotTypesResponseFetcher();
    }

    public Iterator<GetBuiltinSlotTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetBuiltinSlotTypesIterable resume(GetBuiltinSlotTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBuiltinSlotTypesIterable(this.client, (GetBuiltinSlotTypesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBuiltinSlotTypesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetBuiltinSlotTypesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetBuiltinSlotTypesResponseFetcher
    implements SyncPageFetcher<GetBuiltinSlotTypesResponse> {
        private GetBuiltinSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinSlotTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBuiltinSlotTypesResponse nextPage(GetBuiltinSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinSlotTypesIterable.this.client.getBuiltinSlotTypes(GetBuiltinSlotTypesIterable.this.firstRequest);
            }
            return GetBuiltinSlotTypesIterable.this.client.getBuiltinSlotTypes((GetBuiltinSlotTypesRequest)((Object)GetBuiltinSlotTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

