/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a built in slot type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuiltinSlotTypeMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<BuiltinSlotTypeMetadata.Builder, BuiltinSlotTypeMetadata> {
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signature").getter(getter(BuiltinSlotTypeMetadata::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()).build();

    private static final SdkField<List<String>> SUPPORTED_LOCALES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedLocales")
            .getter(getter(BuiltinSlotTypeMetadata::supportedLocalesAsStrings))
            .setter(setter(Builder::supportedLocalesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedLocales").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_FIELD,
            SUPPORTED_LOCALES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String signature;

    private final List<String> supportedLocales;

    private BuiltinSlotTypeMetadata(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
    }

    /**
     * <p>
     * A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     *         >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     */
    public final String signature() {
        return signature;
    }

    /**
     * <p>
     * A list of target locales for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedLocales} method.
     * </p>
     * 
     * @return A list of target locales for the slot.
     */
    public final List<Locale> supportedLocales() {
        return LocaleListCopier.copyStringToEnum(supportedLocales);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedLocales property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedLocales() {
        return supportedLocales != null && !(supportedLocales instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of target locales for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedLocales} method.
     * </p>
     * 
     * @return A list of target locales for the slot.
     */
    public final List<String> supportedLocalesAsStrings() {
        return supportedLocales;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedLocales() ? supportedLocalesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltinSlotTypeMetadata)) {
            return false;
        }
        BuiltinSlotTypeMetadata other = (BuiltinSlotTypeMetadata) obj;
        return Objects.equals(signature(), other.signature()) && hasSupportedLocales() == other.hasSupportedLocales()
                && Objects.equals(supportedLocalesAsStrings(), other.supportedLocalesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuiltinSlotTypeMetadata").add("Signature", signature())
                .add("SupportedLocales", hasSupportedLocales() ? supportedLocalesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signature":
            return Optional.ofNullable(clazz.cast(signature()));
        case "supportedLocales":
            return Optional.ofNullable(clazz.cast(supportedLocalesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signature", SIGNATURE_FIELD);
        map.put("supportedLocales", SUPPORTED_LOCALES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BuiltinSlotTypeMetadata, T> g) {
        return obj -> g.apply((BuiltinSlotTypeMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuiltinSlotTypeMetadata> {
        /**
         * <p>
         * A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param signature
         *        A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         *        >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocalesWithStrings(Collection<String> supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocalesWithStrings(String... supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(Collection<Locale> supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(Locale... supportedLocales);
    }

    static final class BuilderImpl implements Builder {
        private String signature;

        private List<String> supportedLocales = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltinSlotTypeMetadata model) {
            signature(model.signature);
            supportedLocalesWithStrings(model.supportedLocales);
        }

        public final String getSignature() {
            return signature;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final Collection<String> getSupportedLocales() {
            if (supportedLocales instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedLocales;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        @Override
        public final Builder supportedLocalesWithStrings(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocalesWithStrings(String... supportedLocales) {
            supportedLocalesWithStrings(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        public final Builder supportedLocales(Collection<Locale> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copyEnumToString(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale... supportedLocales) {
            supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        public BuiltinSlotTypeMetadata build() {
            return new BuiltinSlotTypeMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
