/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMigrationsRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetMigrationsRequest.Builder, GetMigrationsRequest> {
    private static final SdkField<String> SORT_BY_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortByAttribute").getter(getter(GetMigrationsRequest::sortByAttributeAsString))
            .setter(setter(Builder::sortByAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortByAttribute").build())
            .build();

    private static final SdkField<String> SORT_BY_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortByOrder").getter(getter(GetMigrationsRequest::sortByOrderAsString))
            .setter(setter(Builder::sortByOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortByOrder").build()).build();

    private static final SdkField<String> V1_BOT_NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("v1BotNameContains").getter(getter(GetMigrationsRequest::v1BotNameContains))
            .setter(setter(Builder::v1BotNameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("v1BotNameContains").build())
            .build();

    private static final SdkField<String> MIGRATION_STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("migrationStatusEquals").getter(getter(GetMigrationsRequest::migrationStatusEqualsAsString))
            .setter(setter(Builder::migrationStatusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("migrationStatusEquals").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetMigrationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetMigrationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_ATTRIBUTE_FIELD,
            SORT_BY_ORDER_FIELD, V1_BOT_NAME_CONTAINS_FIELD, MIGRATION_STATUS_EQUALS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sortByAttribute;

    private final String sortByOrder;

    private final String v1BotNameContains;

    private final String migrationStatusEquals;

    private final Integer maxResults;

    private final String nextToken;

    private GetMigrationsRequest(BuilderImpl builder) {
        super(builder);
        this.sortByAttribute = builder.sortByAttribute;
        this.sortByOrder = builder.sortByOrder;
        this.v1BotNameContains = builder.v1BotNameContains;
        this.migrationStatusEquals = builder.migrationStatusEquals;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time that
     * the migration was started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortByAttribute}
     * will return {@link MigrationSortAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAttributeAsString}.
     * </p>
     * 
     * @return The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and
     *         time that the migration was started.
     * @see MigrationSortAttribute
     */
    public final MigrationSortAttribute sortByAttribute() {
        return MigrationSortAttribute.fromValue(sortByAttribute);
    }

    /**
     * <p>
     * The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time that
     * the migration was started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortByAttribute}
     * will return {@link MigrationSortAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAttributeAsString}.
     * </p>
     * 
     * @return The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and
     *         time that the migration was started.
     * @see MigrationSortAttribute
     */
    public final String sortByAttributeAsString() {
        return sortByAttribute;
    }

    /**
     * <p>
     * The order so sort the list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortByOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByOrderAsString}.
     * </p>
     * 
     * @return The order so sort the list.
     * @see SortOrder
     */
    public final SortOrder sortByOrder() {
        return SortOrder.fromValue(sortByOrder);
    }

    /**
     * <p>
     * The order so sort the list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortByOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByOrderAsString}.
     * </p>
     * 
     * @return The order so sort the list.
     * @see SortOrder
     */
    public final String sortByOrderAsString() {
        return sortByOrder;
    }

    /**
     * <p>
     * Filters the list to contain only bots whose name contains the specified string. The string is matched anywhere in
     * bot name.
     * </p>
     * 
     * @return Filters the list to contain only bots whose name contains the specified string. The string is matched
     *         anywhere in bot name.
     */
    public final String v1BotNameContains() {
        return v1BotNameContains;
    }

    /**
     * <p>
     * Filters the list to contain only migrations in the specified state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #migrationStatusEquals} will return {@link MigrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #migrationStatusEqualsAsString}.
     * </p>
     * 
     * @return Filters the list to contain only migrations in the specified state.
     * @see MigrationStatus
     */
    public final MigrationStatus migrationStatusEquals() {
        return MigrationStatus.fromValue(migrationStatusEquals);
    }

    /**
     * <p>
     * Filters the list to contain only migrations in the specified state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #migrationStatusEquals} will return {@link MigrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #migrationStatusEqualsAsString}.
     * </p>
     * 
     * @return Filters the list to contain only migrations in the specified state.
     * @see MigrationStatus
     */
    public final String migrationStatusEqualsAsString() {
        return migrationStatusEquals;
    }

    /**
     * <p>
     * The maximum number of migrations to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of migrations to return in the response. The default is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of migrations. If the response to this operation is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch the next page of migrations, specify the
     * pagination token in the request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of migrations. If the response to this operation is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of migrations,
     *         specify the pagination token in the request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sortByAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(v1BotNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(migrationStatusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMigrationsRequest)) {
            return false;
        }
        GetMigrationsRequest other = (GetMigrationsRequest) obj;
        return Objects.equals(sortByAttributeAsString(), other.sortByAttributeAsString())
                && Objects.equals(sortByOrderAsString(), other.sortByOrderAsString())
                && Objects.equals(v1BotNameContains(), other.v1BotNameContains())
                && Objects.equals(migrationStatusEqualsAsString(), other.migrationStatusEqualsAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMigrationsRequest").add("SortByAttribute", sortByAttributeAsString())
                .add("SortByOrder", sortByOrderAsString()).add("V1BotNameContains", v1BotNameContains())
                .add("MigrationStatusEquals", migrationStatusEqualsAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sortByAttribute":
            return Optional.ofNullable(clazz.cast(sortByAttributeAsString()));
        case "sortByOrder":
            return Optional.ofNullable(clazz.cast(sortByOrderAsString()));
        case "v1BotNameContains":
            return Optional.ofNullable(clazz.cast(v1BotNameContains()));
        case "migrationStatusEquals":
            return Optional.ofNullable(clazz.cast(migrationStatusEqualsAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sortByAttribute", SORT_BY_ATTRIBUTE_FIELD);
        map.put("sortByOrder", SORT_BY_ORDER_FIELD);
        map.put("v1BotNameContains", V1_BOT_NAME_CONTAINS_FIELD);
        map.put("migrationStatusEquals", MIGRATION_STATUS_EQUALS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMigrationsRequest, T> g) {
        return obj -> g.apply((GetMigrationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMigrationsRequest> {
        /**
         * <p>
         * The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time
         * that the migration was started.
         * </p>
         * 
         * @param sortByAttribute
         *        The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date
         *        and time that the migration was started.
         * @see MigrationSortAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationSortAttribute
         */
        Builder sortByAttribute(String sortByAttribute);

        /**
         * <p>
         * The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time
         * that the migration was started.
         * </p>
         * 
         * @param sortByAttribute
         *        The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date
         *        and time that the migration was started.
         * @see MigrationSortAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationSortAttribute
         */
        Builder sortByAttribute(MigrationSortAttribute sortByAttribute);

        /**
         * <p>
         * The order so sort the list.
         * </p>
         * 
         * @param sortByOrder
         *        The order so sort the list.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortByOrder(String sortByOrder);

        /**
         * <p>
         * The order so sort the list.
         * </p>
         * 
         * @param sortByOrder
         *        The order so sort the list.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortByOrder(SortOrder sortByOrder);

        /**
         * <p>
         * Filters the list to contain only bots whose name contains the specified string. The string is matched
         * anywhere in bot name.
         * </p>
         * 
         * @param v1BotNameContains
         *        Filters the list to contain only bots whose name contains the specified string. The string is matched
         *        anywhere in bot name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1BotNameContains(String v1BotNameContains);

        /**
         * <p>
         * Filters the list to contain only migrations in the specified state.
         * </p>
         * 
         * @param migrationStatusEquals
         *        Filters the list to contain only migrations in the specified state.
         * @see MigrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStatus
         */
        Builder migrationStatusEquals(String migrationStatusEquals);

        /**
         * <p>
         * Filters the list to contain only migrations in the specified state.
         * </p>
         * 
         * @param migrationStatusEquals
         *        Filters the list to contain only migrations in the specified state.
         * @see MigrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationStatus
         */
        Builder migrationStatusEquals(MigrationStatus migrationStatusEquals);

        /**
         * <p>
         * The maximum number of migrations to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of migrations to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token that fetches the next page of migrations. If the response to this operation is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of migrations, specify the
         * pagination token in the request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of migrations. If the response to this operation is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of
         *        migrations, specify the pagination token in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String sortByAttribute;

        private String sortByOrder;

        private String v1BotNameContains;

        private String migrationStatusEquals;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMigrationsRequest model) {
            super(model);
            sortByAttribute(model.sortByAttribute);
            sortByOrder(model.sortByOrder);
            v1BotNameContains(model.v1BotNameContains);
            migrationStatusEquals(model.migrationStatusEquals);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getSortByAttribute() {
            return sortByAttribute;
        }

        public final void setSortByAttribute(String sortByAttribute) {
            this.sortByAttribute = sortByAttribute;
        }

        @Override
        public final Builder sortByAttribute(String sortByAttribute) {
            this.sortByAttribute = sortByAttribute;
            return this;
        }

        @Override
        public final Builder sortByAttribute(MigrationSortAttribute sortByAttribute) {
            this.sortByAttribute(sortByAttribute == null ? null : sortByAttribute.toString());
            return this;
        }

        public final String getSortByOrder() {
            return sortByOrder;
        }

        public final void setSortByOrder(String sortByOrder) {
            this.sortByOrder = sortByOrder;
        }

        @Override
        public final Builder sortByOrder(String sortByOrder) {
            this.sortByOrder = sortByOrder;
            return this;
        }

        @Override
        public final Builder sortByOrder(SortOrder sortByOrder) {
            this.sortByOrder(sortByOrder == null ? null : sortByOrder.toString());
            return this;
        }

        public final String getV1BotNameContains() {
            return v1BotNameContains;
        }

        public final void setV1BotNameContains(String v1BotNameContains) {
            this.v1BotNameContains = v1BotNameContains;
        }

        @Override
        public final Builder v1BotNameContains(String v1BotNameContains) {
            this.v1BotNameContains = v1BotNameContains;
            return this;
        }

        public final String getMigrationStatusEquals() {
            return migrationStatusEquals;
        }

        public final void setMigrationStatusEquals(String migrationStatusEquals) {
            this.migrationStatusEquals = migrationStatusEquals;
        }

        @Override
        public final Builder migrationStatusEquals(String migrationStatusEquals) {
            this.migrationStatusEquals = migrationStatusEquals;
            return this;
        }

        @Override
        public final Builder migrationStatusEquals(MigrationStatus migrationStatusEquals) {
            this.migrationStatusEquals(migrationStatusEquals == null ? null : migrationStatusEquals.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMigrationsRequest build() {
            return new GetMigrationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
