/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutIntentResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<PutIntentResponse.Builder, PutIntentResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutIntentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PutIntentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Slot>> SLOTS_FIELD = SdkField
            .<List<Slot>> builder(MarshallingType.LIST)
            .memberName("slots")
            .getter(getter(PutIntentResponse::slots))
            .setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Slot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Slot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(PutIntentResponse::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Prompt> CONFIRMATION_PROMPT_FIELD = SdkField.<Prompt> builder(MarshallingType.SDK_POJO)
            .memberName("confirmationPrompt").getter(getter(PutIntentResponse::confirmationPrompt))
            .setter(setter(Builder::confirmationPrompt)).constructor(Prompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationPrompt").build())
            .build();

    private static final SdkField<Statement> REJECTION_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .memberName("rejectionStatement").getter(getter(PutIntentResponse::rejectionStatement))
            .setter(setter(Builder::rejectionStatement)).constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionStatement").build())
            .build();

    private static final SdkField<FollowUpPrompt> FOLLOW_UP_PROMPT_FIELD = SdkField
            .<FollowUpPrompt> builder(MarshallingType.SDK_POJO).memberName("followUpPrompt")
            .getter(getter(PutIntentResponse::followUpPrompt)).setter(setter(Builder::followUpPrompt))
            .constructor(FollowUpPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followUpPrompt").build()).build();

    private static final SdkField<Statement> CONCLUSION_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .memberName("conclusionStatement").getter(getter(PutIntentResponse::conclusionStatement))
            .setter(setter(Builder::conclusionStatement)).constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conclusionStatement").build())
            .build();

    private static final SdkField<CodeHook> DIALOG_CODE_HOOK_FIELD = SdkField.<CodeHook> builder(MarshallingType.SDK_POJO)
            .memberName("dialogCodeHook").getter(getter(PutIntentResponse::dialogCodeHook))
            .setter(setter(Builder::dialogCodeHook)).constructor(CodeHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()).build();

    private static final SdkField<FulfillmentActivity> FULFILLMENT_ACTIVITY_FIELD = SdkField
            .<FulfillmentActivity> builder(MarshallingType.SDK_POJO).memberName("fulfillmentActivity")
            .getter(getter(PutIntentResponse::fulfillmentActivity)).setter(setter(Builder::fulfillmentActivity))
            .constructor(FulfillmentActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentActivity").build())
            .build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIntentSignature").getter(getter(PutIntentResponse::parentIntentSignature))
            .setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(PutIntentResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(PutIntentResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(PutIntentResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(PutIntentResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createVersion").getter(getter(PutIntentResponse::createVersion)).setter(setter(Builder::createVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()).build();

    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<KendraConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraConfiguration")
            .getter(getter(PutIntentResponse::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(KendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField
            .<List<InputContext>> builder(MarshallingType.LIST)
            .memberName("inputContexts")
            .getter(getter(PutIntentResponse::inputContexts))
            .setter(setter(Builder::inputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField
            .<List<OutputContext>> builder(MarshallingType.LIST)
            .memberName("outputContexts")
            .getter(getter(PutIntentResponse::outputContexts))
            .setter(setter(Builder::outputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SLOTS_FIELD, SAMPLE_UTTERANCES_FIELD, CONFIRMATION_PROMPT_FIELD, REJECTION_STATEMENT_FIELD, FOLLOW_UP_PROMPT_FIELD,
            CONCLUSION_STATEMENT_FIELD, DIALOG_CODE_HOOK_FIELD, FULFILLMENT_ACTIVITY_FIELD, PARENT_INTENT_SIGNATURE_FIELD,
            LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, CHECKSUM_FIELD, CREATE_VERSION_FIELD,
            KENDRA_CONFIGURATION_FIELD, INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final List<Slot> slots;

    private final List<String> sampleUtterances;

    private final Prompt confirmationPrompt;

    private final Statement rejectionStatement;

    private final FollowUpPrompt followUpPrompt;

    private final Statement conclusionStatement;

    private final CodeHook dialogCodeHook;

    private final FulfillmentActivity fulfillmentActivity;

    private final String parentIntentSignature;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String version;

    private final String checksum;

    private final Boolean createVersion;

    private final KendraConfiguration kendraConfiguration;

    private final List<InputContext> inputContexts;

    private final List<OutputContext> outputContexts;

    private PutIntentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
        this.createVersion = builder.createVersion;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
    }

    /**
     * <p>
     * The name of the intent.
     * </p>
     * 
     * @return The name of the intent.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the intent.
     * </p>
     * 
     * @return A description of the intent.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Slots property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSlots() {
        return slots != null && !(slots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of intent slots that are configured for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlots} method.
     * </p>
     * 
     * @return An array of intent slots that are configured for the intent.
     */
    public final List<Slot> slots() {
        return slots;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleUtterances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of sample utterances that are configured for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleUtterances} method.
     * </p>
     * 
     * @return An array of sample utterances that are configured for the intent.
     */
    public final List<String> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.
     * </p>
     * 
     * @return If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.
     */
    public final Prompt confirmationPrompt() {
        return confirmationPrompt;
    }

    /**
     * <p>
     * If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex responds with this
     * statement to acknowledge that the intent was canceled.
     * </p>
     * 
     * @return If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex responds
     *         with this statement to acknowledge that the intent was canceled.
     */
    public final Statement rejectionStatement() {
        return rejectionStatement;
    }

    /**
     * <p>
     * If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the intent is
     * fulfilled.
     * </p>
     * 
     * @return If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the
     *         intent is fulfilled.
     */
    public final FollowUpPrompt followUpPrompt() {
        return followUpPrompt;
    }

    /**
     * <p>
     * After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex
     * conveys this statement to the user.
     * </p>
     * 
     * @return After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent,
     *         Amazon Lex conveys this statement to the user.
     */
    public final Statement conclusionStatement() {
        return conclusionStatement;
    }

    /**
     * <p>
     * If defined in the intent, Amazon Lex invokes this Lambda function for each user input.
     * </p>
     * 
     * @return If defined in the intent, Amazon Lex invokes this Lambda function for each user input.
     */
    public final CodeHook dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user provides
     * all of the information required by the intent.
     * </p>
     * 
     * @return If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user
     *         provides all of the information required by the intent.
     */
    public final FulfillmentActivity fulfillmentActivity() {
        return fulfillmentActivity;
    }

    /**
     * <p>
     * A unique identifier for the built-in intent that this intent is based on.
     * </p>
     * 
     * @return A unique identifier for the built-in intent that this intent is based on.
     */
    public final String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * <p>
     * The date that the intent was updated. When you create a resource, the creation date and last update dates are the
     * same.
     * </p>
     * 
     * @return The date that the intent was updated. When you create a resource, the creation date and last update dates
     *         are the same.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the intent was created.
     * </p>
     * 
     * @return The date that the intent was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version of the intent. For a new intent, the version is always <code>$LATEST</code>.
     * </p>
     * 
     * @return The version of the intent. For a new intent, the version is always <code>$LATEST</code>.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * Checksum of the <code>$LATEST</code>version of the intent created or updated.
     * </p>
     * 
     * @return Checksum of the <code>$LATEST</code>version of the intent created or updated.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * <code>True</code> if a new version of the intent was created. If the <code>createVersion</code> field was not
     * specified in the request, the <code>createVersion</code> field is set to false in the response.
     * </p>
     * 
     * @return <code>True</code> if a new version of the intent was created. If the <code>createVersion</code> field was
     *         not specified in the request, the <code>createVersion</code> field is set to false in the response.
     */
    public final Boolean createVersion() {
        return createVersion;
    }

    /**
     * <p>
     * Configuration information, if any, required to connect to an Amazon Kendra index and use the
     * <code>AMAZON.KendraSearchIntent</code> intent.
     * </p>
     * 
     * @return Configuration information, if any, required to connect to an Amazon Kendra index and use the
     *         <code>AMAZON.KendraSearchIntent</code> intent.
     */
    public final KendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputContexts() {
        return inputContexts != null && !(inputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
     * choose the intent in a conversation with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputContexts} method.
     * </p>
     * 
     * @return An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex
     *         to choose the intent in a conversation with the user.
     */
    public final List<InputContext> inputContexts() {
        return inputContexts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputContexts() {
        return outputContexts != null && !(outputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent
     * is fulfilled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputContexts} method.
     * </p>
     * 
     * @return An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
     *         intent is fulfilled.
     */
    public final List<OutputContext> outputContexts() {
        return outputContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlots() ? slots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(confirmationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(followUpPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(conclusionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentActivity());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputContexts() ? inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputContexts() ? outputContexts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntentResponse)) {
            return false;
        }
        PutIntentResponse other = (PutIntentResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasSlots() == other.hasSlots() && Objects.equals(slots(), other.slots())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(confirmationPrompt(), other.confirmationPrompt())
                && Objects.equals(rejectionStatement(), other.rejectionStatement())
                && Objects.equals(followUpPrompt(), other.followUpPrompt())
                && Objects.equals(conclusionStatement(), other.conclusionStatement())
                && Objects.equals(dialogCodeHook(), other.dialogCodeHook())
                && Objects.equals(fulfillmentActivity(), other.fulfillmentActivity())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(version(), other.version())
                && Objects.equals(checksum(), other.checksum()) && Objects.equals(createVersion(), other.createVersion())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration())
                && hasInputContexts() == other.hasInputContexts() && Objects.equals(inputContexts(), other.inputContexts())
                && hasOutputContexts() == other.hasOutputContexts() && Objects.equals(outputContexts(), other.outputContexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutIntentResponse").add("Name", name()).add("Description", description())
                .add("Slots", hasSlots() ? slots() : null)
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("ConfirmationPrompt", confirmationPrompt()).add("RejectionStatement", rejectionStatement())
                .add("FollowUpPrompt", followUpPrompt()).add("ConclusionStatement", conclusionStatement())
                .add("DialogCodeHook", dialogCodeHook()).add("FulfillmentActivity", fulfillmentActivity())
                .add("ParentIntentSignature", parentIntentSignature()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("Version", version()).add("Checksum", checksum())
                .add("CreateVersion", createVersion()).add("KendraConfiguration", kendraConfiguration())
                .add("InputContexts", hasInputContexts() ? inputContexts() : null)
                .add("OutputContexts", hasOutputContexts() ? outputContexts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slots":
            return Optional.ofNullable(clazz.cast(slots()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "confirmationPrompt":
            return Optional.ofNullable(clazz.cast(confirmationPrompt()));
        case "rejectionStatement":
            return Optional.ofNullable(clazz.cast(rejectionStatement()));
        case "followUpPrompt":
            return Optional.ofNullable(clazz.cast(followUpPrompt()));
        case "conclusionStatement":
            return Optional.ofNullable(clazz.cast(conclusionStatement()));
        case "dialogCodeHook":
            return Optional.ofNullable(clazz.cast(dialogCodeHook()));
        case "fulfillmentActivity":
            return Optional.ofNullable(clazz.cast(fulfillmentActivity()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "createVersion":
            return Optional.ofNullable(clazz.cast(createVersion()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        case "inputContexts":
            return Optional.ofNullable(clazz.cast(inputContexts()));
        case "outputContexts":
            return Optional.ofNullable(clazz.cast(outputContexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("slots", SLOTS_FIELD);
        map.put("sampleUtterances", SAMPLE_UTTERANCES_FIELD);
        map.put("confirmationPrompt", CONFIRMATION_PROMPT_FIELD);
        map.put("rejectionStatement", REJECTION_STATEMENT_FIELD);
        map.put("followUpPrompt", FOLLOW_UP_PROMPT_FIELD);
        map.put("conclusionStatement", CONCLUSION_STATEMENT_FIELD);
        map.put("dialogCodeHook", DIALOG_CODE_HOOK_FIELD);
        map.put("fulfillmentActivity", FULFILLMENT_ACTIVITY_FIELD);
        map.put("parentIntentSignature", PARENT_INTENT_SIGNATURE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("checksum", CHECKSUM_FIELD);
        map.put("createVersion", CREATE_VERSION_FIELD);
        map.put("kendraConfiguration", KENDRA_CONFIGURATION_FIELD);
        map.put("inputContexts", INPUT_CONTEXTS_FIELD);
        map.put("outputContexts", OUTPUT_CONTEXTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIntentResponse, T> g) {
        return obj -> g.apply((PutIntentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutIntentResponse> {
        /**
         * <p>
         * The name of the intent.
         * </p>
         * 
         * @param name
         *        The name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the intent.
         * </p>
         * 
         * @param description
         *        A description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of intent slots that are configured for the intent.
         * </p>
         * 
         * @param slots
         *        An array of intent slots that are configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<Slot> slots);

        /**
         * <p>
         * An array of intent slots that are configured for the intent.
         * </p>
         * 
         * @param slots
         *        An array of intent slots that are configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Slot... slots);

        /**
         * <p>
         * An array of intent slots that are configured for the intent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.Slot.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelbuilding.model.Slot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.Slot.Builder#build()} is called immediately and
         * its result is passed to {@link #slots(List<Slot>)}.
         * 
         * @param slots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.Slot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slots(java.util.Collection<Slot>)
         */
        Builder slots(Consumer<Slot.Builder>... slots);

        /**
         * <p>
         * An array of sample utterances that are configured for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of sample utterances that are configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<String> sampleUtterances);

        /**
         * <p>
         * An array of sample utterances that are configured for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of sample utterances that are configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(String... sampleUtterances);

        /**
         * <p>
         * If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.
         * </p>
         * 
         * @param confirmationPrompt
         *        If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationPrompt(Prompt confirmationPrompt);

        /**
         * <p>
         * If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.
         * </p>
         * This is a convenience method that creates an instance of the {@link Prompt.Builder} avoiding the need to
         * create one manually via {@link Prompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #confirmationPrompt(Prompt)}.
         * 
         * @param confirmationPrompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationPrompt(Prompt)
         */
        default Builder confirmationPrompt(Consumer<Prompt.Builder> confirmationPrompt) {
            return confirmationPrompt(Prompt.builder().applyMutation(confirmationPrompt).build());
        }

        /**
         * <p>
         * If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * 
         * @param rejectionStatement
         *        If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex
         *        responds with this statement to acknowledge that the intent was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionStatement(Statement rejectionStatement);

        /**
         * <p>
         * If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * This is a convenience method that creates an instance of the {@link Statement.Builder} avoiding the need to
         * create one manually via {@link Statement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #rejectionStatement(Statement)}.
         * 
         * @param rejectionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectionStatement(Statement)
         */
        default Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return rejectionStatement(Statement.builder().applyMutation(rejectionStatement).build());
        }

        /**
         * <p>
         * If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the intent is
         * fulfilled.
         * </p>
         * 
         * @param followUpPrompt
         *        If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the
         *        intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder followUpPrompt(FollowUpPrompt followUpPrompt);

        /**
         * <p>
         * If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the intent is
         * fulfilled.
         * </p>
         * This is a convenience method that creates an instance of the {@link FollowUpPrompt.Builder} avoiding the need
         * to create one manually via {@link FollowUpPrompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FollowUpPrompt.Builder#build()} is called immediately and its
         * result is passed to {@link #followUpPrompt(FollowUpPrompt)}.
         * 
         * @param followUpPrompt
         *        a consumer that will call methods on {@link FollowUpPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #followUpPrompt(FollowUpPrompt)
         */
        default Builder followUpPrompt(Consumer<FollowUpPrompt.Builder> followUpPrompt) {
            return followUpPrompt(FollowUpPrompt.builder().applyMutation(followUpPrompt).build());
        }

        /**
         * <p>
         * After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon
         * Lex conveys this statement to the user.
         * </p>
         * 
         * @param conclusionStatement
         *        After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent,
         *        Amazon Lex conveys this statement to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conclusionStatement(Statement conclusionStatement);

        /**
         * <p>
         * After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon
         * Lex conveys this statement to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link Statement.Builder} avoiding the need to
         * create one manually via {@link Statement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #conclusionStatement(Statement)}.
         * 
         * @param conclusionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conclusionStatement(Statement)
         */
        default Builder conclusionStatement(Consumer<Statement.Builder> conclusionStatement) {
            return conclusionStatement(Statement.builder().applyMutation(conclusionStatement).build());
        }

        /**
         * <p>
         * If defined in the intent, Amazon Lex invokes this Lambda function for each user input.
         * </p>
         * 
         * @param dialogCodeHook
         *        If defined in the intent, Amazon Lex invokes this Lambda function for each user input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(CodeHook dialogCodeHook);

        /**
         * <p>
         * If defined in the intent, Amazon Lex invokes this Lambda function for each user input.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeHook.Builder} avoiding the need to
         * create one manually via {@link CodeHook#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeHook.Builder#build()} is called immediately and its result is
         * passed to {@link #dialogCodeHook(CodeHook)}.
         * 
         * @param dialogCodeHook
         *        a consumer that will call methods on {@link CodeHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogCodeHook(CodeHook)
         */
        default Builder dialogCodeHook(Consumer<CodeHook.Builder> dialogCodeHook) {
            return dialogCodeHook(CodeHook.builder().applyMutation(dialogCodeHook).build());
        }

        /**
         * <p>
         * If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user
         * provides all of the information required by the intent.
         * </p>
         * 
         * @param fulfillmentActivity
         *        If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user
         *        provides all of the information required by the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity);

        /**
         * <p>
         * If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user
         * provides all of the information required by the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link FulfillmentActivity.Builder} avoiding the
         * need to create one manually via {@link FulfillmentActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FulfillmentActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #fulfillmentActivity(FulfillmentActivity)}.
         * 
         * @param fulfillmentActivity
         *        a consumer that will call methods on {@link FulfillmentActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentActivity(FulfillmentActivity)
         */
        default Builder fulfillmentActivity(Consumer<FulfillmentActivity.Builder> fulfillmentActivity) {
            return fulfillmentActivity(FulfillmentActivity.builder().applyMutation(fulfillmentActivity).build());
        }

        /**
         * <p>
         * A unique identifier for the built-in intent that this intent is based on.
         * </p>
         * 
         * @param parentIntentSignature
         *        A unique identifier for the built-in intent that this intent is based on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * The date that the intent was updated. When you create a resource, the creation date and last update dates are
         * the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the intent was updated. When you create a resource, the creation date and last update
         *        dates are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the intent was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the intent was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The version of the intent. For a new intent, the version is always <code>$LATEST</code>.
         * </p>
         * 
         * @param version
         *        The version of the intent. For a new intent, the version is always <code>$LATEST</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Checksum of the <code>$LATEST</code>version of the intent created or updated.
         * </p>
         * 
         * @param checksum
         *        Checksum of the <code>$LATEST</code>version of the intent created or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * <code>True</code> if a new version of the intent was created. If the <code>createVersion</code> field was not
         * specified in the request, the <code>createVersion</code> field is set to false in the response.
         * </p>
         * 
         * @param createVersion
         *        <code>True</code> if a new version of the intent was created. If the <code>createVersion</code> field
         *        was not specified in the request, the <code>createVersion</code> field is set to false in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVersion(Boolean createVersion);

        /**
         * <p>
         * Configuration information, if any, required to connect to an Amazon Kendra index and use the
         * <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * 
         * @param kendraConfiguration
         *        Configuration information, if any, required to connect to an Amazon Kendra index and use the
         *        <code>AMAZON.KendraSearchIntent</code> intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(KendraConfiguration kendraConfiguration);

        /**
         * <p>
         * Configuration information, if any, required to connect to an Amazon Kendra index and use the
         * <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link KendraConfiguration.Builder} avoiding the
         * need to create one manually via {@link KendraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(KendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link KendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(KendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(KendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }

        /**
         * <p>
         * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
         * choose the intent in a conversation with the user.
         * </p>
         * 
         * @param inputContexts
         *        An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon
         *        Lex to choose the intent in a conversation with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(Collection<InputContext> inputContexts);

        /**
         * <p>
         * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
         * choose the intent in a conversation with the user.
         * </p>
         * 
         * @param inputContexts
         *        An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon
         *        Lex to choose the intent in a conversation with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(InputContext... inputContexts);

        /**
         * <p>
         * An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to
         * choose the intent in a conversation with the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.InputContext.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelbuilding.model.InputContext#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.InputContext.Builder#build()} is called
         * immediately and its result is passed to {@link #inputContexts(List<InputContext>)}.
         * 
         * @param inputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.InputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputContexts(java.util.Collection<InputContext>)
         */
        Builder inputContexts(Consumer<InputContext.Builder>... inputContexts);

        /**
         * <p>
         * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
         * intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when
         *        the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(Collection<OutputContext> outputContexts);

        /**
         * <p>
         * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
         * intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when
         *        the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(OutputContext... outputContexts);

        /**
         * <p>
         * An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the
         * intent is fulfilled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.OutputContext.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.OutputContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.OutputContext.Builder#build()} is called
         * immediately and its result is passed to {@link #outputContexts(List<OutputContext>)}.
         * 
         * @param outputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.OutputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputContexts(java.util.Collection<OutputContext>)
         */
        Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Slot> slots = DefaultSdkAutoConstructList.getInstance();

        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private Prompt confirmationPrompt;

        private Statement rejectionStatement;

        private FollowUpPrompt followUpPrompt;

        private Statement conclusionStatement;

        private CodeHook dialogCodeHook;

        private FulfillmentActivity fulfillmentActivity;

        private String parentIntentSignature;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String version;

        private String checksum;

        private Boolean createVersion;

        private KendraConfiguration kendraConfiguration;

        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();

        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntentResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            slots(model.slots);
            sampleUtterances(model.sampleUtterances);
            confirmationPrompt(model.confirmationPrompt);
            rejectionStatement(model.rejectionStatement);
            followUpPrompt(model.followUpPrompt);
            conclusionStatement(model.conclusionStatement);
            dialogCodeHook(model.dialogCodeHook);
            fulfillmentActivity(model.fulfillmentActivity);
            parentIntentSignature(model.parentIntentSignature);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            version(model.version);
            checksum(model.checksum);
            createVersion(model.createVersion);
            kendraConfiguration(model.kendraConfiguration);
            inputContexts(model.inputContexts);
            outputContexts(model.outputContexts);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Slot.Builder> getSlots() {
            List<Slot.Builder> result = SlotListCopier.copyToBuilder(this.slots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotListCopier.copyFromBuilder(slots);
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<Slot.Builder>... slots) {
            slots(Stream.of(slots).map(c -> Slot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSampleUtterances() {
            if (sampleUtterances instanceof SdkAutoConstructList) {
                return null;
            }
            return sampleUtterances;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final Prompt.Builder getConfirmationPrompt() {
            return confirmationPrompt != null ? confirmationPrompt.toBuilder() : null;
        }

        public final void setConfirmationPrompt(Prompt.BuilderImpl confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt != null ? confirmationPrompt.build() : null;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final Statement.Builder getRejectionStatement() {
            return rejectionStatement != null ? rejectionStatement.toBuilder() : null;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final FollowUpPrompt.Builder getFollowUpPrompt() {
            return followUpPrompt != null ? followUpPrompt.toBuilder() : null;
        }

        public final void setFollowUpPrompt(FollowUpPrompt.BuilderImpl followUpPrompt) {
            this.followUpPrompt = followUpPrompt != null ? followUpPrompt.build() : null;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final Statement.Builder getConclusionStatement() {
            return conclusionStatement != null ? conclusionStatement.toBuilder() : null;
        }

        public final void setConclusionStatement(Statement.BuilderImpl conclusionStatement) {
            this.conclusionStatement = conclusionStatement != null ? conclusionStatement.build() : null;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final CodeHook.Builder getDialogCodeHook() {
            return dialogCodeHook != null ? dialogCodeHook.toBuilder() : null;
        }

        public final void setDialogCodeHook(CodeHook.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final FulfillmentActivity.Builder getFulfillmentActivity() {
            return fulfillmentActivity != null ? fulfillmentActivity.toBuilder() : null;
        }

        public final void setFulfillmentActivity(FulfillmentActivity.BuilderImpl fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity != null ? fulfillmentActivity.build() : null;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Boolean getCreateVersion() {
            return createVersion;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext... inputContexts) {
            inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder>... inputContexts) {
            inputContexts(Stream.of(inputContexts).map(c -> InputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext... outputContexts) {
            outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts) {
            outputContexts(Stream.of(outputContexts).map(c -> OutputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutIntentResponse build() {
            return new PutIntentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
