/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for a slot type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotTypeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotTypeConfiguration.Builder, SlotTypeConfiguration> {
    private static final SdkField<SlotTypeRegexConfiguration> REGEX_CONFIGURATION_FIELD = SdkField
            .<SlotTypeRegexConfiguration> builder(MarshallingType.SDK_POJO).memberName("regexConfiguration")
            .getter(getter(SlotTypeConfiguration::regexConfiguration)).setter(setter(Builder::regexConfiguration))
            .constructor(SlotTypeRegexConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SlotTypeRegexConfiguration regexConfiguration;

    private SlotTypeConfiguration(BuilderImpl builder) {
        this.regexConfiguration = builder.regexConfiguration;
    }

    /**
     * <p>
     * A regular expression used to validate the value of a slot.
     * </p>
     * 
     * @return A regular expression used to validate the value of a slot.
     */
    public final SlotTypeRegexConfiguration regexConfiguration() {
        return regexConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regexConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeConfiguration)) {
            return false;
        }
        SlotTypeConfiguration other = (SlotTypeConfiguration) obj;
        return Objects.equals(regexConfiguration(), other.regexConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotTypeConfiguration").add("RegexConfiguration", regexConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "regexConfiguration":
            return Optional.ofNullable(clazz.cast(regexConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("regexConfiguration", REGEX_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeConfiguration, T> g) {
        return obj -> g.apply((SlotTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotTypeConfiguration> {
        /**
         * <p>
         * A regular expression used to validate the value of a slot.
         * </p>
         * 
         * @param regexConfiguration
         *        A regular expression used to validate the value of a slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexConfiguration(SlotTypeRegexConfiguration regexConfiguration);

        /**
         * <p>
         * A regular expression used to validate the value of a slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotTypeRegexConfiguration.Builder}
         * avoiding the need to create one manually via {@link SlotTypeRegexConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotTypeRegexConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #regexConfiguration(SlotTypeRegexConfiguration)}.
         * 
         * @param regexConfiguration
         *        a consumer that will call methods on {@link SlotTypeRegexConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexConfiguration(SlotTypeRegexConfiguration)
         */
        default Builder regexConfiguration(Consumer<SlotTypeRegexConfiguration.Builder> regexConfiguration) {
            return regexConfiguration(SlotTypeRegexConfiguration.builder().applyMutation(regexConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SlotTypeRegexConfiguration regexConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeConfiguration model) {
            regexConfiguration(model.regexConfiguration);
        }

        public final SlotTypeRegexConfiguration.Builder getRegexConfiguration() {
            return regexConfiguration != null ? regexConfiguration.toBuilder() : null;
        }

        public final void setRegexConfiguration(SlotTypeRegexConfiguration.BuilderImpl regexConfiguration) {
            this.regexConfiguration = regexConfiguration != null ? regexConfiguration.build() : null;
        }

        @Override
        public final Builder regexConfiguration(SlotTypeRegexConfiguration regexConfiguration) {
            this.regexConfiguration = regexConfiguration;
            return this;
        }

        @Override
        public SlotTypeConfiguration build() {
            return new SlotTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
