/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.SynonymListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnumerationValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnumerationValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(EnumerationValue.getter(EnumerationValue::value)).setter(EnumerationValue.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<List<String>> SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("synonyms").getter(EnumerationValue.getter(EnumerationValue::synonyms)).setter(EnumerationValue.setter(Builder::synonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("synonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, SYNONYMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnumerationValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String value;
    private final List<String> synonyms;

    private EnumerationValue(BuilderImpl builder) {
        this.value = builder.value;
        this.synonyms = builder.synonyms;
    }

    public final String value() {
        return this.value;
    }

    public final boolean hasSynonyms() {
        return this.synonyms != null && !(this.synonyms instanceof SdkAutoConstructList);
    }

    public final List<String> synonyms() {
        return this.synonyms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSynonyms() ? this.synonyms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumerationValue)) {
            return false;
        }
        EnumerationValue other = (EnumerationValue)obj;
        return Objects.equals(this.value(), other.value()) && this.hasSynonyms() == other.hasSynonyms() && Objects.equals(this.synonyms(), other.synonyms());
    }

    public final String toString() {
        return ToString.builder((String)"EnumerationValue").add("Value", (Object)this.value()).add("Synonyms", this.hasSynonyms() ? this.synonyms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "synonyms": {
                return Optional.ofNullable(clazz.cast(this.synonyms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", VALUE_FIELD);
        map.put("synonyms", SYNONYMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnumerationValue, T> g) {
        return obj -> g.apply((EnumerationValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private List<String> synonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnumerationValue model) {
            this.value(model.value);
            this.synonyms(model.synonyms);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Collection<String> getSynonyms() {
            if (this.synonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.synonyms;
        }

        public final void setSynonyms(Collection<String> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
        }

        @Override
        public final Builder synonyms(Collection<String> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synonyms(String ... synonyms) {
            this.synonyms(Arrays.asList(synonyms));
            return this;
        }

        public EnumerationValue build() {
            return new EnumerationValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnumerationValue> {
        public Builder value(String var1);

        public Builder synonyms(Collection<String> var1);

        public Builder synonyms(String ... var1);
    }
}

