/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetExportRequest.Builder, GetExportRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetExportRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(GetExportRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(GetExportRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<String> EXPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportType").getter(getter(GetExportRequest::exportTypeAsString)).setter(setter(Builder::exportType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("exportType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            RESOURCE_TYPE_FIELD, EXPORT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String version;

    private final String resourceType;

    private final String exportType;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
        this.exportType = builder.exportType;
    }

    /**
     * <p>
     * The name of the bot to export.
     * </p>
     * 
     * @return The name of the bot to export.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the bot to export.
     * </p>
     * 
     * @return The version of the bot to export.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The type of resource to export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to export.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource to export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to export.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public final ExportType exportType() {
        return ExportType.fromValue(exportType);
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public final String exportTypeAsString() {
        return exportType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(exportTypeAsString(), other.exportTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExportRequest").add("Name", name()).add("Version", version())
                .add("ResourceType", resourceTypeAsString()).add("ExportType", exportTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "exportType":
            return Optional.ofNullable(clazz.cast(exportTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("exportType", EXPORT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExportRequest, T> g) {
        return obj -> g.apply((GetExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetExportRequest> {
        /**
         * <p>
         * The name of the bot to export.
         * </p>
         * 
         * @param name
         *        The name of the bot to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the bot to export.
         * </p>
         * 
         * @param version
         *        The version of the bot to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The type of resource to export.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to export.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource to export.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to export.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(ExportType exportType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String version;

        private String resourceType;

        private String exportType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            super(model);
            name(model.name);
            version(model.version);
            resourceType(model.resourceType);
            exportType(model.exportType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getExportType() {
            return exportType;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType == null ? null : exportType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
