/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMigrationsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetMigrationsResponse.Builder, GetMigrationsResponse> {
    private static final SdkField<List<MigrationSummary>> MIGRATION_SUMMARIES_FIELD = SdkField
            .<List<MigrationSummary>> builder(MarshallingType.LIST)
            .memberName("migrationSummaries")
            .getter(getter(GetMigrationsResponse::migrationSummaries))
            .setter(setter(Builder::migrationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MigrationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MigrationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetMigrationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MigrationSummary> migrationSummaries;

    private final String nextToken;

    private GetMigrationsResponse(BuilderImpl builder) {
        super(builder);
        this.migrationSummaries = builder.migrationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MigrationSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMigrationSummaries() {
        return migrationSummaries != null && !(migrationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration, use
     * the <code>migrationId</code> from the summary in a call to the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMigrationSummaries} method.
     * </p>
     * 
     * @return An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the
     *         migration, use the <code>migrationId</code> from the summary in a call to the operation.
     */
    public final List<MigrationSummary> migrationSummaries() {
        return migrationSummaries;
    }

    /**
     * <p>
     * If the response is truncated, it includes a pagination token that you can specify in your next request to fetch
     * the next page of migrations.
     * </p>
     * 
     * @return If the response is truncated, it includes a pagination token that you can specify in your next request to
     *         fetch the next page of migrations.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMigrationSummaries() ? migrationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMigrationsResponse)) {
            return false;
        }
        GetMigrationsResponse other = (GetMigrationsResponse) obj;
        return hasMigrationSummaries() == other.hasMigrationSummaries()
                && Objects.equals(migrationSummaries(), other.migrationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMigrationsResponse")
                .add("MigrationSummaries", hasMigrationSummaries() ? migrationSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "migrationSummaries":
            return Optional.ofNullable(clazz.cast(migrationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("migrationSummaries", MIGRATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMigrationsResponse, T> g) {
        return obj -> g.apply((GetMigrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMigrationsResponse> {
        /**
         * <p>
         * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration,
         * use the <code>migrationId</code> from the summary in a call to the operation.
         * </p>
         * 
         * @param migrationSummaries
         *        An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the
         *        migration, use the <code>migrationId</code> from the summary in a call to the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationSummaries(Collection<MigrationSummary> migrationSummaries);

        /**
         * <p>
         * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration,
         * use the <code>migrationId</code> from the summary in a call to the operation.
         * </p>
         * 
         * @param migrationSummaries
         *        An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the
         *        migration, use the <code>migrationId</code> from the summary in a call to the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationSummaries(MigrationSummary... migrationSummaries);

        /**
         * <p>
         * An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration,
         * use the <code>migrationId</code> from the summary in a call to the operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.MigrationSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.MigrationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.MigrationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #migrationSummaries(List<MigrationSummary>)}.
         * 
         * @param migrationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.MigrationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationSummaries(java.util.Collection<MigrationSummary>)
         */
        Builder migrationSummaries(Consumer<MigrationSummary.Builder>... migrationSummaries);

        /**
         * <p>
         * If the response is truncated, it includes a pagination token that you can specify in your next request to
         * fetch the next page of migrations.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, it includes a pagination token that you can specify in your next request
         *        to fetch the next page of migrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<MigrationSummary> migrationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMigrationsResponse model) {
            super(model);
            migrationSummaries(model.migrationSummaries);
            nextToken(model.nextToken);
        }

        public final List<MigrationSummary.Builder> getMigrationSummaries() {
            List<MigrationSummary.Builder> result = MigrationSummaryListCopier.copyToBuilder(this.migrationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMigrationSummaries(Collection<MigrationSummary.BuilderImpl> migrationSummaries) {
            this.migrationSummaries = MigrationSummaryListCopier.copyFromBuilder(migrationSummaries);
        }

        @Override
        public final Builder migrationSummaries(Collection<MigrationSummary> migrationSummaries) {
            this.migrationSummaries = MigrationSummaryListCopier.copy(migrationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationSummaries(MigrationSummary... migrationSummaries) {
            migrationSummaries(Arrays.asList(migrationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationSummaries(Consumer<MigrationSummary.Builder>... migrationSummaries) {
            migrationSummaries(Stream.of(migrationSummaries).map(c -> MigrationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetMigrationsResponse build() {
            return new GetMigrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
