/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBotAliasResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<PutBotAliasResponse.Builder, PutBotAliasResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutBotAliasResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PutBotAliasResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(PutBotAliasResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(PutBotAliasResponse::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(PutBotAliasResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(PutBotAliasResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(PutBotAliasResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<ConversationLogsResponse> CONVERSATION_LOGS_FIELD = SdkField
            .<ConversationLogsResponse> builder(MarshallingType.SDK_POJO).memberName("conversationLogs")
            .getter(getter(PutBotAliasResponse::conversationLogs)).setter(setter(Builder::conversationLogs))
            .constructor(ConversationLogsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogs").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(PutBotAliasResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            BOT_VERSION_FIELD, BOT_NAME_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, CHECKSUM_FIELD,
            CONVERSATION_LOGS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String botVersion;

    private final String botName;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String checksum;

    private final ConversationLogsResponse conversationLogs;

    private final List<Tag> tags;

    private PutBotAliasResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botName = builder.botName;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.checksum = builder.checksum;
        this.conversationLogs = builder.conversationLogs;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the alias.
     * </p>
     * 
     * @return The name of the alias.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the alias.
     * </p>
     * 
     * @return A description of the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot that the alias points to.
     * </p>
     * 
     * @return The version of the bot that the alias points to.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The name of the bot that the alias points to.
     * </p>
     * 
     * @return The name of the bot that the alias points to.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the bot alias was updated. When you create a resource, the creation date and the last updated date
     * are the same.
     * </p>
     * 
     * @return The date that the bot alias was updated. When you create a resource, the creation date and the last
     *         updated date are the same.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the bot alias was created.
     * </p>
     * 
     * @return The date that the bot alias was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The checksum for the current version of the alias.
     * </p>
     * 
     * @return The checksum for the current version of the alias.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The settings that determine how Amazon Lex uses conversation logs for the alias.
     * </p>
     * 
     * @return The settings that determine how Amazon Lex uses conversation logs for the alias.
     */
    public final ConversationLogsResponse conversationLogs() {
        return conversationLogs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags associated with a bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with a bot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(conversationLogs());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotAliasResponse)) {
            return false;
        }
        PutBotAliasResponse other = (PutBotAliasResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(botName(), other.botName())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(conversationLogs(), other.conversationLogs()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutBotAliasResponse").add("Name", name()).add("Description", description())
                .add("BotVersion", botVersion()).add("BotName", botName()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("Checksum", checksum()).add("ConversationLogs", conversationLogs())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "conversationLogs":
            return Optional.ofNullable(clazz.cast(conversationLogs()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("botName", BOT_NAME_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("checksum", CHECKSUM_FIELD);
        map.put("conversationLogs", CONVERSATION_LOGS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutBotAliasResponse, T> g) {
        return obj -> g.apply((PutBotAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutBotAliasResponse> {
        /**
         * <p>
         * The name of the alias.
         * </p>
         * 
         * @param name
         *        The name of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the alias.
         * </p>
         * 
         * @param description
         *        A description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot that the alias points to.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that the alias points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The name of the bot that the alias points to.
         * </p>
         * 
         * @param botName
         *        The name of the bot that the alias points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the bot alias was updated. When you create a resource, the creation date and the last updated
         * date are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the bot alias was updated. When you create a resource, the creation date and the last
         *        updated date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the bot alias was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the bot alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The checksum for the current version of the alias.
         * </p>
         * 
         * @param checksum
         *        The checksum for the current version of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The settings that determine how Amazon Lex uses conversation logs for the alias.
         * </p>
         * 
         * @param conversationLogs
         *        The settings that determine how Amazon Lex uses conversation logs for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLogs(ConversationLogsResponse conversationLogs);

        /**
         * <p>
         * The settings that determine how Amazon Lex uses conversation logs for the alias.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationLogsResponse.Builder}
         * avoiding the need to create one manually via {@link ConversationLogsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationLogsResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #conversationLogs(ConversationLogsResponse)}.
         * 
         * @param conversationLogs
         *        a consumer that will call methods on {@link ConversationLogsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLogs(ConversationLogsResponse)
         */
        default Builder conversationLogs(Consumer<ConversationLogsResponse.Builder> conversationLogs) {
            return conversationLogs(ConversationLogsResponse.builder().applyMutation(conversationLogs).build());
        }

        /**
         * <p>
         * A list of tags associated with a bot.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with a bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with a bot.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with a bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags associated with a bot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botVersion;

        private String botName;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String checksum;

        private ConversationLogsResponse conversationLogs;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotAliasResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            botVersion(model.botVersion);
            botName(model.botName);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            checksum(model.checksum);
            conversationLogs(model.conversationLogs);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final ConversationLogsResponse.Builder getConversationLogs() {
            return conversationLogs != null ? conversationLogs.toBuilder() : null;
        }

        public final void setConversationLogs(ConversationLogsResponse.BuilderImpl conversationLogs) {
            this.conversationLogs = conversationLogs != null ? conversationLogs.build() : null;
        }

        @Override
        public final Builder conversationLogs(ConversationLogsResponse conversationLogs) {
            this.conversationLogs = conversationLogs;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutBotAliasResponse build() {
            return new PutBotAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
