/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the default values for a slot. Default values are used when Amazon Lex hasn't determined a value for a slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotDefaultValueSpec implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotDefaultValueSpec.Builder, SlotDefaultValueSpec> {
    private static final SdkField<List<SlotDefaultValue>> DEFAULT_VALUE_LIST_FIELD = SdkField
            .<List<SlotDefaultValue>> builder(MarshallingType.LIST)
            .memberName("defaultValueList")
            .getter(getter(SlotDefaultValueSpec::defaultValueList))
            .setter(setter(Builder::defaultValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotDefaultValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotDefaultValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SlotDefaultValue> defaultValueList;

    private SlotDefaultValueSpec(BuilderImpl builder) {
        this.defaultValueList = builder.defaultValueList;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultValueList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultValueList() {
        return defaultValueList != null && !(defaultValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default values for a slot. You can specify more than one default. For example, you can specify a default
     * value to use from a matching context variable, a session attribute, or a fixed value.
     * </p>
     * <p>
     * The default value chosen is selected based on the order that you specify them in the list. For example, if you
     * specify a context variable and a fixed value in that order, Amazon Lex uses the context variable if it is
     * available, else it uses the fixed value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultValueList} method.
     * </p>
     * 
     * @return The default values for a slot. You can specify more than one default. For example, you can specify a
     *         default value to use from a matching context variable, a session attribute, or a fixed value.</p>
     *         <p>
     *         The default value chosen is selected based on the order that you specify them in the list. For example,
     *         if you specify a context variable and a fixed value in that order, Amazon Lex uses the context variable
     *         if it is available, else it uses the fixed value.
     */
    public final List<SlotDefaultValue> defaultValueList() {
        return defaultValueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultValueList() ? defaultValueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotDefaultValueSpec)) {
            return false;
        }
        SlotDefaultValueSpec other = (SlotDefaultValueSpec) obj;
        return hasDefaultValueList() == other.hasDefaultValueList()
                && Objects.equals(defaultValueList(), other.defaultValueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotDefaultValueSpec")
                .add("DefaultValueList", hasDefaultValueList() ? defaultValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultValueList":
            return Optional.ofNullable(clazz.cast(defaultValueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("defaultValueList", DEFAULT_VALUE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotDefaultValueSpec, T> g) {
        return obj -> g.apply((SlotDefaultValueSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotDefaultValueSpec> {
        /**
         * <p>
         * The default values for a slot. You can specify more than one default. For example, you can specify a default
         * value to use from a matching context variable, a session attribute, or a fixed value.
         * </p>
         * <p>
         * The default value chosen is selected based on the order that you specify them in the list. For example, if
         * you specify a context variable and a fixed value in that order, Amazon Lex uses the context variable if it is
         * available, else it uses the fixed value.
         * </p>
         * 
         * @param defaultValueList
         *        The default values for a slot. You can specify more than one default. For example, you can specify a
         *        default value to use from a matching context variable, a session attribute, or a fixed value.</p>
         *        <p>
         *        The default value chosen is selected based on the order that you specify them in the list. For
         *        example, if you specify a context variable and a fixed value in that order, Amazon Lex uses the
         *        context variable if it is available, else it uses the fixed value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValueList(Collection<SlotDefaultValue> defaultValueList);

        /**
         * <p>
         * The default values for a slot. You can specify more than one default. For example, you can specify a default
         * value to use from a matching context variable, a session attribute, or a fixed value.
         * </p>
         * <p>
         * The default value chosen is selected based on the order that you specify them in the list. For example, if
         * you specify a context variable and a fixed value in that order, Amazon Lex uses the context variable if it is
         * available, else it uses the fixed value.
         * </p>
         * 
         * @param defaultValueList
         *        The default values for a slot. You can specify more than one default. For example, you can specify a
         *        default value to use from a matching context variable, a session attribute, or a fixed value.</p>
         *        <p>
         *        The default value chosen is selected based on the order that you specify them in the list. For
         *        example, if you specify a context variable and a fixed value in that order, Amazon Lex uses the
         *        context variable if it is available, else it uses the fixed value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValueList(SlotDefaultValue... defaultValueList);

        /**
         * <p>
         * The default values for a slot. You can specify more than one default. For example, you can specify a default
         * value to use from a matching context variable, a session attribute, or a fixed value.
         * </p>
         * <p>
         * The default value chosen is selected based on the order that you specify them in the list. For example, if
         * you specify a context variable and a fixed value in that order, Amazon Lex uses the context variable if it is
         * available, else it uses the fixed value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotDefaultValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotDefaultValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotDefaultValue.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultValueList(List<SlotDefaultValue>)}.
         * 
         * @param defaultValueList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotDefaultValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValueList(java.util.Collection<SlotDefaultValue>)
         */
        Builder defaultValueList(Consumer<SlotDefaultValue.Builder>... defaultValueList);
    }

    static final class BuilderImpl implements Builder {
        private List<SlotDefaultValue> defaultValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotDefaultValueSpec model) {
            defaultValueList(model.defaultValueList);
        }

        public final List<SlotDefaultValue.Builder> getDefaultValueList() {
            List<SlotDefaultValue.Builder> result = SlotDefaultValueListCopier.copyToBuilder(this.defaultValueList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultValueList(Collection<SlotDefaultValue.BuilderImpl> defaultValueList) {
            this.defaultValueList = SlotDefaultValueListCopier.copyFromBuilder(defaultValueList);
        }

        @Override
        public final Builder defaultValueList(Collection<SlotDefaultValue> defaultValueList) {
            this.defaultValueList = SlotDefaultValueListCopier.copy(defaultValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValueList(SlotDefaultValue... defaultValueList) {
            defaultValueList(Arrays.asList(defaultValueList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValueList(Consumer<SlotDefaultValue.Builder>... defaultValueList) {
            defaultValueList(Stream.of(defaultValueList).map(c -> SlotDefaultValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SlotDefaultValueSpec build() {
            return new SlotDefaultValueSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
