/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.Intent;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.services.lexmodelbuilding.model.Status;
import software.amazon.awssdk.services.lexmodelbuilding.model.Tag;
import software.amazon.awssdk.services.lexmodelbuilding.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutBotResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, PutBotResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PutBotResponse.getter(PutBotResponse::name)).setter(PutBotResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PutBotResponse.getter(PutBotResponse::description)).setter(PutBotResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Intent>> INTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("intents").getter(PutBotResponse.getter(PutBotResponse::intents)).setter(PutBotResponse.setter(Builder::intents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Intent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_MODEL_IMPROVEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableModelImprovements").getter(PutBotResponse.getter(PutBotResponse::enableModelImprovements)).setter(PutBotResponse.setter(Builder::enableModelImprovements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableModelImprovements").build()}).build();
    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("nluIntentConfidenceThreshold").getter(PutBotResponse.getter(PutBotResponse::nluIntentConfidenceThreshold)).setter(PutBotResponse.setter(Builder::nluIntentConfidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold").build()}).build();
    private static final SdkField<Prompt> CLARIFICATION_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clarificationPrompt").getter(PutBotResponse.getter(PutBotResponse::clarificationPrompt)).setter(PutBotResponse.setter(Builder::clarificationPrompt)).constructor(Prompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clarificationPrompt").build()}).build();
    private static final SdkField<Statement> ABORT_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("abortStatement").getter(PutBotResponse.getter(PutBotResponse::abortStatement)).setter(PutBotResponse.setter(Builder::abortStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortStatement").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PutBotResponse.getter(PutBotResponse::statusAsString)).setter(PutBotResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(PutBotResponse.getter(PutBotResponse::failureReason)).setter(PutBotResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(PutBotResponse.getter(PutBotResponse::lastUpdatedDate)).setter(PutBotResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(PutBotResponse.getter(PutBotResponse::createdDate)).setter(PutBotResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(PutBotResponse.getter(PutBotResponse::idleSessionTTLInSeconds)).setter(PutBotResponse.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("voiceId").getter(PutBotResponse.getter(PutBotResponse::voiceId)).setter(PutBotResponse.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceId").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checksum").getter(PutBotResponse.getter(PutBotResponse::checksum)).setter(PutBotResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(PutBotResponse.getter(PutBotResponse::version)).setter(PutBotResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(PutBotResponse.getter(PutBotResponse::localeAsString)).setter(PutBotResponse.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<Boolean> CHILD_DIRECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("childDirected").getter(PutBotResponse.getter(PutBotResponse::childDirected)).setter(PutBotResponse.setter(Builder::childDirected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childDirected").build()}).build();
    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createVersion").getter(PutBotResponse.getter(PutBotResponse::createVersion)).setter(PutBotResponse.setter(Builder::createVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()}).build();
    private static final SdkField<Boolean> DETECT_SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("detectSentiment").getter(PutBotResponse.getter(PutBotResponse::detectSentiment)).setter(PutBotResponse.setter(Builder::detectSentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectSentiment").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(PutBotResponse.getter(PutBotResponse::tags)).setter(PutBotResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, INTENTS_FIELD, ENABLE_MODEL_IMPROVEMENTS_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, CLARIFICATION_PROMPT_FIELD, ABORT_STATEMENT_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, VOICE_ID_FIELD, CHECKSUM_FIELD, VERSION_FIELD, LOCALE_FIELD, CHILD_DIRECTED_FIELD, CREATE_VERSION_FIELD, DETECT_SENTIMENT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutBotResponse.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<Intent> intents;
    private final Boolean enableModelImprovements;
    private final Double nluIntentConfidenceThreshold;
    private final Prompt clarificationPrompt;
    private final Statement abortStatement;
    private final String status;
    private final String failureReason;
    private final Instant lastUpdatedDate;
    private final Instant createdDate;
    private final Integer idleSessionTTLInSeconds;
    private final String voiceId;
    private final String checksum;
    private final String version;
    private final String locale;
    private final Boolean childDirected;
    private final Boolean createVersion;
    private final Boolean detectSentiment;
    private final List<Tag> tags;

    private PutBotResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.enableModelImprovements = builder.enableModelImprovements;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.version = builder.version;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
        this.createVersion = builder.createVersion;
        this.detectSentiment = builder.detectSentiment;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasIntents() {
        return this.intents != null && !(this.intents instanceof SdkAutoConstructList);
    }

    public final List<Intent> intents() {
        return this.intents;
    }

    public final Boolean enableModelImprovements() {
        return this.enableModelImprovements;
    }

    public final Double nluIntentConfidenceThreshold() {
        return this.nluIntentConfidenceThreshold;
    }

    public final Prompt clarificationPrompt() {
        return this.clarificationPrompt;
    }

    public final Statement abortStatement() {
        return this.abortStatement;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final String voiceId() {
        return this.voiceId;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final String version() {
        return this.version;
    }

    public final Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    public final Boolean childDirected() {
        return this.childDirected;
    }

    public final Boolean createVersion() {
        return this.createVersion;
    }

    public final Boolean detectSentiment() {
        return this.detectSentiment;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntents() ? this.intents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableModelImprovements());
        hashCode = 31 * hashCode + Objects.hashCode(this.nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.clarificationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.childDirected());
        hashCode = 31 * hashCode + Objects.hashCode(this.createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectSentiment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotResponse)) {
            return false;
        }
        PutBotResponse other = (PutBotResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasIntents() == other.hasIntents() && Objects.equals(this.intents(), other.intents()) && Objects.equals(this.enableModelImprovements(), other.enableModelImprovements()) && Objects.equals(this.nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold()) && Objects.equals(this.clarificationPrompt(), other.clarificationPrompt()) && Objects.equals(this.abortStatement(), other.abortStatement()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.voiceId(), other.voiceId()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.childDirected(), other.childDirected()) && Objects.equals(this.createVersion(), other.createVersion()) && Objects.equals(this.detectSentiment(), other.detectSentiment()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutBotResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Intents", this.hasIntents() ? this.intents() : null).add("EnableModelImprovements", (Object)this.enableModelImprovements()).add("NluIntentConfidenceThreshold", (Object)this.nluIntentConfidenceThreshold()).add("ClarificationPrompt", (Object)this.clarificationPrompt()).add("AbortStatement", (Object)this.abortStatement()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("CreatedDate", (Object)this.createdDate()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("VoiceId", (Object)this.voiceId()).add("Checksum", (Object)this.checksum()).add("Version", (Object)this.version()).add("Locale", (Object)this.localeAsString()).add("ChildDirected", (Object)this.childDirected()).add("CreateVersion", (Object)this.createVersion()).add("DetectSentiment", (Object)this.detectSentiment()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "intents": {
                return Optional.ofNullable(clazz.cast(this.intents()));
            }
            case "enableModelImprovements": {
                return Optional.ofNullable(clazz.cast(this.enableModelImprovements()));
            }
            case "nluIntentConfidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.nluIntentConfidenceThreshold()));
            }
            case "clarificationPrompt": {
                return Optional.ofNullable(clazz.cast(this.clarificationPrompt()));
            }
            case "abortStatement": {
                return Optional.ofNullable(clazz.cast(this.abortStatement()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "voiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceId()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "childDirected": {
                return Optional.ofNullable(clazz.cast(this.childDirected()));
            }
            case "createVersion": {
                return Optional.ofNullable(clazz.cast(this.createVersion()));
            }
            case "detectSentiment": {
                return Optional.ofNullable(clazz.cast(this.detectSentiment()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("intents", INTENTS_FIELD);
        map.put("enableModelImprovements", ENABLE_MODEL_IMPROVEMENTS_FIELD);
        map.put("nluIntentConfidenceThreshold", NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD);
        map.put("clarificationPrompt", CLARIFICATION_PROMPT_FIELD);
        map.put("abortStatement", ABORT_STATEMENT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("voiceId", VOICE_ID_FIELD);
        map.put("checksum", CHECKSUM_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("childDirected", CHILD_DIRECTED_FIELD);
        map.put("createVersion", CREATE_VERSION_FIELD);
        map.put("detectSentiment", DETECT_SENTIMENT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutBotResponse, T> g) {
        return obj -> g.apply((PutBotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Intent> intents = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableModelImprovements;
        private Double nluIntentConfidenceThreshold;
        private Prompt clarificationPrompt;
        private Statement abortStatement;
        private String status;
        private String failureReason;
        private Instant lastUpdatedDate;
        private Instant createdDate;
        private Integer idleSessionTTLInSeconds;
        private String voiceId;
        private String checksum;
        private String version;
        private String locale;
        private Boolean childDirected;
        private Boolean createVersion;
        private Boolean detectSentiment;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.intents(model.intents);
            this.enableModelImprovements(model.enableModelImprovements);
            this.nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            this.clarificationPrompt(model.clarificationPrompt);
            this.abortStatement(model.abortStatement);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.createdDate(model.createdDate);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.voiceId(model.voiceId);
            this.checksum(model.checksum);
            this.version(model.version);
            this.locale(model.locale);
            this.childDirected(model.childDirected);
            this.createVersion(model.createVersion);
            this.detectSentiment(model.detectSentiment);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Intent.Builder> getIntents() {
            List<Intent.Builder> result = IntentListCopier.copyToBuilder(this.intents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntents(Collection<Intent.BuilderImpl> intents) {
            this.intents = IntentListCopier.copyFromBuilder(intents);
        }

        @Override
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Intent ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<Intent.Builder> ... intents) {
            this.intents(Stream.of(intents).map(c -> (Intent)((Intent.Builder)Intent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableModelImprovements() {
            return this.enableModelImprovements;
        }

        public final void setEnableModelImprovements(Boolean enableModelImprovements) {
            this.enableModelImprovements = enableModelImprovements;
        }

        @Override
        public final Builder enableModelImprovements(Boolean enableModelImprovements) {
            this.enableModelImprovements = enableModelImprovements;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return this.nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final Prompt.Builder getClarificationPrompt() {
            return this.clarificationPrompt != null ? this.clarificationPrompt.toBuilder() : null;
        }

        public final void setClarificationPrompt(Prompt.BuilderImpl clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt != null ? clarificationPrompt.build() : null;
        }

        @Override
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final Statement.Builder getAbortStatement() {
            return this.abortStatement != null ? this.abortStatement.toBuilder() : null;
        }

        public final void setAbortStatement(Statement.BuilderImpl abortStatement) {
            this.abortStatement = abortStatement != null ? abortStatement.build() : null;
        }

        @Override
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final Boolean getChildDirected() {
            return this.childDirected;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final Boolean getCreateVersion() {
            return this.createVersion;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final Boolean getDetectSentiment() {
            return this.detectSentiment;
        }

        public final void setDetectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
        }

        @Override
        public final Builder detectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutBotResponse build() {
            return new PutBotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutBotResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder intents(Collection<Intent> var1);

        public Builder intents(Intent ... var1);

        public Builder intents(Consumer<Intent.Builder> ... var1);

        public Builder enableModelImprovements(Boolean var1);

        public Builder nluIntentConfidenceThreshold(Double var1);

        public Builder clarificationPrompt(Prompt var1);

        default public Builder clarificationPrompt(Consumer<Prompt.Builder> clarificationPrompt) {
            return this.clarificationPrompt((Prompt)((Prompt.Builder)Prompt.builder().applyMutation(clarificationPrompt)).build());
        }

        public Builder abortStatement(Statement var1);

        default public Builder abortStatement(Consumer<Statement.Builder> abortStatement) {
            return this.abortStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(abortStatement)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder failureReason(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder createdDate(Instant var1);

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder voiceId(String var1);

        public Builder checksum(String var1);

        public Builder version(String var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder childDirected(Boolean var1);

        public Builder createVersion(Boolean var1);

        public Builder detectSentiment(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

