/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProcessBehavior {
    SAVE("SAVE"),
    BUILD("BUILD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessBehavior> VALUE_MAP;
    private final String value;

    private ProcessBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProcessBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProcessBehavior> knownValues() {
        EnumSet<ProcessBehavior> knownValues = EnumSet.allOf(ProcessBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProcessBehavior.class, ProcessBehavior::toString);
    }
}

