/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBotChannelAssociationRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<DeleteBotChannelAssociationRequest.Builder, DeleteBotChannelAssociationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeleteBotChannelAssociationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(DeleteBotChannelAssociationRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()).build();

    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAlias").getter(getter(DeleteBotChannelAssociationRequest::botAlias))
            .setter(setter(Builder::botAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("aliasName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BOT_NAME_FIELD,
            BOT_ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String botName;

    private final String botAlias;

    private DeleteBotChannelAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
    }

    /**
     * <p>
     * The name of the association. The name is case sensitive.
     * </p>
     * 
     * @return The name of the association. The name is case sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the Amazon Lex bot.
     * </p>
     * 
     * @return The name of the Amazon Lex bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * An alias that points to the specific version of the Amazon Lex bot to which this association is being made.
     * </p>
     * 
     * @return An alias that points to the specific version of the Amazon Lex bot to which this association is being
     *         made.
     */
    public final String botAlias() {
        return botAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotChannelAssociationRequest)) {
            return false;
        }
        DeleteBotChannelAssociationRequest other = (DeleteBotChannelAssociationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(botName(), other.botName())
                && Objects.equals(botAlias(), other.botAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBotChannelAssociationRequest").add("Name", name()).add("BotName", botName())
                .add("BotAlias", botAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "botAlias":
            return Optional.ofNullable(clazz.cast(botAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("botName", BOT_NAME_FIELD);
        map.put("aliasName", BOT_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotChannelAssociationRequest, T> g) {
        return obj -> g.apply((DeleteBotChannelAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteBotChannelAssociationRequest> {
        /**
         * <p>
         * The name of the association. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the association. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the Amazon Lex bot.
         * </p>
         * 
         * @param botName
         *        The name of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * An alias that points to the specific version of the Amazon Lex bot to which this association is being made.
         * </p>
         * 
         * @param botAlias
         *        An alias that points to the specific version of the Amazon Lex bot to which this association is being
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String botName;

        private String botAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotChannelAssociationRequest model) {
            super(model);
            name(model.name);
            botName(model.botName);
            botAlias(model.botAlias);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBotChannelAssociationRequest build() {
            return new DeleteBotChannelAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
