/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBotChannelAssociationResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotChannelAssociationResponse.Builder, GetBotChannelAssociationResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetBotChannelAssociationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetBotChannelAssociationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAlias").getter(getter(GetBotChannelAssociationResponse::botAlias)).setter(setter(Builder::botAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAlias").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(GetBotChannelAssociationResponse::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetBotChannelAssociationResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetBotChannelAssociationResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Map<String, String>> BOT_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("botConfiguration")
            .getter(getter(GetBotChannelAssociationResponse::botConfiguration))
            .setter(setter(Builder::botConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetBotChannelAssociationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetBotChannelAssociationResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            BOT_ALIAS_FIELD, BOT_NAME_FIELD, CREATED_DATE_FIELD, TYPE_FIELD, BOT_CONFIGURATION_FIELD, STATUS_FIELD,
            FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String botAlias;

    private final String botName;

    private final Instant createdDate;

    private final String type;

    private final Map<String, String> botConfiguration;

    private final String status;

    private final String failureReason;

    private GetBotChannelAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.botAlias = builder.botAlias;
        this.botName = builder.botName;
        this.createdDate = builder.createdDate;
        this.type = builder.type;
        this.botConfiguration = builder.botConfiguration;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the association between the bot and the channel.
     * </p>
     * 
     * @return The name of the association between the bot and the channel.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the association between the bot and the channel.
     * </p>
     * 
     * @return A description of the association between the bot and the channel.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
     * </p>
     * 
     * @return An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
     */
    public final String botAlias() {
        return botAlias;
    }

    /**
     * <p>
     * The name of the Amazon Lex bot.
     * </p>
     * 
     * @return The name of the Amazon Lex bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the association between the bot and the channel was created.
     * </p>
     * 
     * @return The date that the association between the bot and the channel was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The type of the messaging platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the messaging platform.
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * The type of the messaging platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the messaging platform.
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotConfiguration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBotConfiguration() {
        return botConfiguration != null && !(botConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotConfiguration} method.
     * </p>
     * 
     * @return Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
     */
    public final Map<String, String> botConfiguration() {
        return botConfiguration;
    }

    /**
     * <p>
     * The status of the bot channel.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED</code> - The channel has been created and is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Channel creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - There was an error creating the channel. For information about the reason for the failure,
     * see the <code>failureReason</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the bot channel. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED</code> - The channel has been created and is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Channel creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - There was an error creating the channel. For information about the reason for the
     *         failure, see the <code>failureReason</code> field.
     *         </p>
     *         </li>
     * @see ChannelStatus
     */
    public final ChannelStatus status() {
        return ChannelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the bot channel.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED</code> - The channel has been created and is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Channel creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - There was an error creating the channel. For information about the reason for the failure,
     * see the <code>failureReason</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the bot channel. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED</code> - The channel has been created and is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Channel creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - There was an error creating the channel. For information about the reason for the
     *         failure, see the <code>failureReason</code> field.
     *         </p>
     *         </li>
     * @see ChannelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to create the
     * association.
     * </p>
     * 
     * @return If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to create
     *         the association.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotConfiguration() ? botConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationResponse)) {
            return false;
        }
        GetBotChannelAssociationResponse other = (GetBotChannelAssociationResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(botAlias(), other.botAlias()) && Objects.equals(botName(), other.botName())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasBotConfiguration() == other.hasBotConfiguration()
                && Objects.equals(botConfiguration(), other.botConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBotChannelAssociationResponse").add("Name", name()).add("Description", description())
                .add("BotAlias", botAlias()).add("BotName", botName()).add("CreatedDate", createdDate())
                .add("Type", typeAsString())
                .add("BotConfiguration", botConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botAlias":
            return Optional.ofNullable(clazz.cast(botAlias()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "botConfiguration":
            return Optional.ofNullable(clazz.cast(botConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("botAlias", BOT_ALIAS_FIELD);
        map.put("botName", BOT_NAME_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("botConfiguration", BOT_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBotChannelAssociationResponse, T> g) {
        return obj -> g.apply((GetBotChannelAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBotChannelAssociationResponse> {
        /**
         * <p>
         * The name of the association between the bot and the channel.
         * </p>
         * 
         * @param name
         *        The name of the association between the bot and the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the association between the bot and the channel.
         * </p>
         * 
         * @param description
         *        A description of the association between the bot and the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
         * </p>
         * 
         * @param botAlias
         *        An alias pointing to the specific version of the Amazon Lex bot to which this association is being
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        /**
         * <p>
         * The name of the Amazon Lex bot.
         * </p>
         * 
         * @param botName
         *        The name of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the association between the bot and the channel was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the association between the bot and the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The type of the messaging platform.
         * </p>
         * 
         * @param type
         *        The type of the messaging platform.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the messaging platform.
         * </p>
         * 
         * @param type
         *        The type of the messaging platform.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
         * </p>
         * 
         * @param botConfiguration
         *        Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botConfiguration(Map<String, String> botConfiguration);

        /**
         * <p>
         * The status of the bot channel.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED</code> - The channel has been created and is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Channel creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - There was an error creating the channel. For information about the reason for the
         * failure, see the <code>failureReason</code> field.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the bot channel. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED</code> - The channel has been created and is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Channel creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - There was an error creating the channel. For information about the reason for
         *        the failure, see the <code>failureReason</code> field.
         *        </p>
         *        </li>
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the bot channel.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED</code> - The channel has been created and is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Channel creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - There was an error creating the channel. For information about the reason for the
         * failure, see the <code>failureReason</code> field.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the bot channel. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED</code> - The channel has been created and is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Channel creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - There was an error creating the channel. For information about the reason for
         *        the failure, see the <code>failureReason</code> field.
         *        </p>
         *        </li>
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder status(ChannelStatus status);

        /**
         * <p>
         * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to create the
         * association.
         * </p>
         * 
         * @param failureReason
         *        If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to create
         *        the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botAlias;

        private String botName;

        private Instant createdDate;

        private String type;

        private Map<String, String> botConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            botAlias(model.botAlias);
            botName(model.botName);
            createdDate(model.createdDate);
            type(model.type);
            botConfiguration(model.botConfiguration);
            status(model.status);
            failureReason(model.failureReason);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Map<String, String> getBotConfiguration() {
            if (botConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return botConfiguration;
        }

        public final void setBotConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
        }

        @Override
        public final Builder botConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public GetBotChannelAssociationResponse build() {
            return new GetBotChannelAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
